/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.AbstractPlainDatagramSocketImpl;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.DatagramSocketImpl;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketOption;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Objects;
import java.util.Set;

final class NetMulticastSocket
extends MulticastSocket {
    private boolean bound = false;
    private boolean closed = false;
    private volatile boolean created;
    private final Object closeLock = new Object();
    private final DatagramSocketImpl impl;
    private final boolean oldImpl;
    private boolean explicitFilter = false;
    private int bytesLeftToFilter;
    static final int ST_NOT_CONNECTED = 0;
    static final int ST_CONNECTED = 1;
    static final int ST_CONNECTED_NO_IMPL = 2;
    int connectState = 0;
    InetAddress connectedAddress = null;
    int connectedPort = -1;
    private volatile Set<SocketOption<?>> options;
    private final Object optionsLock = new Object();
    private boolean interfaceSet;
    private final Object ttlLock = new Object();
    private final Object infLock = new Object();
    private InetAddress infAddress = null;

    NetMulticastSocket(DatagramSocketImpl impl) {
        super((MulticastSocket)null);
        this.impl = Objects.requireNonNull(impl);
        this.oldImpl = NetMulticastSocket.checkOldImpl(impl);
    }

    private synchronized void connectInternal(InetAddress address, int port) throws SocketException {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("connect: " + port);
        }
        if (address == null) {
            throw new IllegalArgumentException("connect: null address");
        }
        NetMulticastSocket.checkAddress(address, "connect");
        if (this.isClosed()) {
            return;
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            if (address.isMulticastAddress()) {
                security.checkMulticast(address);
            } else {
                security.checkConnect(address.getHostAddress(), port);
                security.checkAccept(address.getHostAddress(), port);
            }
        }
        if (port == 0) {
            throw new SocketException("Can't connect to port 0");
        }
        if (!this.isBound()) {
            this.bind(new InetSocketAddress(0));
        }
        if (this.oldImpl || this.impl instanceof AbstractPlainDatagramSocketImpl && ((AbstractPlainDatagramSocketImpl)this.impl).nativeConnectDisabled()) {
            this.connectState = 2;
        } else {
            try {
                this.getImpl().connect(address, port);
                this.connectState = 1;
                int avail = this.getImpl().dataAvailable();
                if (avail == -1) {
                    throw new SocketException();
                }
                boolean bl = this.explicitFilter = avail > 0;
                if (this.explicitFilter) {
                    this.bytesLeftToFilter = this.getReceiveBufferSize();
                }
            }
            catch (SocketException se) {
                this.connectState = 2;
            }
        }
        this.connectedAddress = address;
        this.connectedPort = port;
    }

    private static boolean checkOldImpl(final DatagramSocketImpl impl) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Void run() throws NoSuchMethodException {
                    Class[] cl = new Class[]{DatagramPacket.class};
                    impl.getClass().getDeclaredMethod("peekData", cl);
                    return null;
                }
            });
            return false;
        }
        catch (PrivilegedActionException e) {
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final DatagramSocketImpl getImpl() throws SocketException {
        if (!this.created) {
            NetMulticastSocket netMulticastSocket = this;
            synchronized (netMulticastSocket) {
                if (!this.created) {
                    this.impl.create();
                    this.created = true;
                }
            }
        }
        return this.impl;
    }

    @Override
    public synchronized void bind(SocketAddress addr) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (this.isBound()) {
            throw new SocketException("already bound");
        }
        if (addr == null) {
            addr = new InetSocketAddress(0);
        }
        if (!(addr instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type!");
        }
        InetSocketAddress epoint = (InetSocketAddress)addr;
        if (epoint.isUnresolved()) {
            throw new SocketException("Unresolved address");
        }
        InetAddress iaddr = epoint.getAddress();
        int port = epoint.getPort();
        NetMulticastSocket.checkAddress(iaddr, "bind");
        SecurityManager sec = System.getSecurityManager();
        if (sec != null) {
            sec.checkListen(port);
        }
        try {
            this.getImpl().bind(port, iaddr);
        }
        catch (SocketException e) {
            this.getImpl().close();
            throw e;
        }
        this.bound = true;
    }

    static void checkAddress(InetAddress addr, String op) {
        if (addr == null) {
            return;
        }
        if (!(addr instanceof Inet4Address) && !(addr instanceof Inet6Address)) {
            throw new IllegalArgumentException(op + ": invalid address type");
        }
    }

    @Override
    public void connect(InetAddress address, int port) {
        try {
            this.connectInternal(address, port);
        }
        catch (SocketException se) {
            throw new UncheckedIOException("connect failed", se);
        }
    }

    @Override
    public void connect(SocketAddress addr) throws SocketException {
        if (addr == null) {
            throw new IllegalArgumentException("Address can't be null");
        }
        if (!(addr instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type");
        }
        InetSocketAddress epoint = (InetSocketAddress)addr;
        if (epoint.isUnresolved()) {
            throw new SocketException("Unresolved address");
        }
        this.connectInternal(epoint.getAddress(), epoint.getPort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        NetMulticastSocket netMulticastSocket = this;
        synchronized (netMulticastSocket) {
            if (this.isClosed()) {
                return;
            }
            if (this.connectState == 1) {
                this.impl.disconnect();
            }
            this.connectedAddress = null;
            this.connectedPort = -1;
            this.connectState = 0;
            this.explicitFilter = false;
        }
    }

    @Override
    public boolean isBound() {
        return this.bound;
    }

    @Override
    public boolean isConnected() {
        return this.connectState != 0;
    }

    @Override
    public InetAddress getInetAddress() {
        return this.connectedAddress;
    }

    @Override
    public int getPort() {
        return this.connectedPort;
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        if (!this.isConnected()) {
            return null;
        }
        return new InetSocketAddress(this.getInetAddress(), this.getPort());
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        if (this.isClosed()) {
            return null;
        }
        if (!this.isBound()) {
            return null;
        }
        return new InetSocketAddress(this.getLocalAddress(), this.getLocalPort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(DatagramPacket p) throws IOException {
        DatagramPacket datagramPacket = p;
        synchronized (datagramPacket) {
            if (this.isClosed()) {
                throw new SocketException("Socket is closed");
            }
            InetAddress packetAddress = p.getAddress();
            int packetPort = p.getPort();
            NetMulticastSocket.checkAddress(packetAddress, "send");
            if (this.connectState == 0) {
                if (packetAddress == null) {
                    throw new IllegalArgumentException("Address not set");
                }
                if (packetPort < 0 || packetPort > 65535) {
                    throw new IllegalArgumentException("port out of range: " + packetPort);
                }
                SecurityManager security = System.getSecurityManager();
                if (security != null) {
                    if (packetAddress.isMulticastAddress()) {
                        security.checkMulticast(packetAddress);
                    } else {
                        security.checkConnect(packetAddress.getHostAddress(), packetPort);
                    }
                }
                if (packetPort == 0) {
                    throw new SocketException("Can't send to port 0");
                }
            } else if (packetAddress == null) {
                p.setAddress(this.connectedAddress);
                p.setPort(this.connectedPort);
            } else if (!packetAddress.equals(this.connectedAddress) || packetPort != this.connectedPort) {
                throw new IllegalArgumentException("connected address and packet address differ");
            }
            if (!this.isBound()) {
                this.bind(new InetSocketAddress(0));
            }
            this.getImpl().send(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void receive(DatagramPacket p) throws IOException {
        DatagramPacket datagramPacket = p;
        synchronized (datagramPacket) {
            SecurityManager security;
            if (!this.isBound()) {
                this.bind(new InetSocketAddress(0));
            }
            if (this.connectState == 0 && (security = System.getSecurityManager()) != null) {
                while (true) {
                    String peekAd = null;
                    int peekPort = 0;
                    if (!this.oldImpl) {
                        DatagramPacket peekPacket = new DatagramPacket(new byte[1], 1);
                        peekPort = this.getImpl().peekData(peekPacket);
                        peekAd = peekPacket.getAddress().getHostAddress();
                    } else {
                        InetAddress adr = new InetAddress();
                        peekPort = this.getImpl().peek(adr);
                        peekAd = adr.getHostAddress();
                    }
                    try {
                        security.checkAccept(peekAd, peekPort);
                    }
                    catch (SecurityException se) {
                        DatagramPacket tmp = new DatagramPacket(new byte[1], 1);
                        this.getImpl().receive(tmp);
                        continue;
                    }
                    break;
                }
            }
            DatagramPacket tmp = null;
            if (this.connectState == 2 || this.explicitFilter) {
                boolean stop = false;
                while (!stop) {
                    InetAddress peekAddress = null;
                    int peekPort = -1;
                    if (!this.oldImpl) {
                        DatagramPacket peekPacket = new DatagramPacket(new byte[1], 1);
                        peekPort = this.getImpl().peekData(peekPacket);
                        peekAddress = peekPacket.getAddress();
                    } else {
                        peekAddress = new InetAddress();
                        peekPort = this.getImpl().peek(peekAddress);
                    }
                    if (!this.connectedAddress.equals(peekAddress) || this.connectedPort != peekPort) {
                        tmp = new DatagramPacket(new byte[1024], 1024);
                        this.getImpl().receive(tmp);
                        if (!this.explicitFilter || !this.checkFiltering(tmp)) continue;
                        stop = true;
                        continue;
                    }
                    stop = true;
                }
            }
            this.getImpl().receive(p);
            if (this.explicitFilter && tmp == null) {
                this.checkFiltering(p);
            }
        }
    }

    private boolean checkFiltering(DatagramPacket p) throws SocketException {
        this.bytesLeftToFilter -= p.getLength();
        if (this.bytesLeftToFilter <= 0 || this.getImpl().dataAvailable() <= 0) {
            this.explicitFilter = false;
            return true;
        }
        return false;
    }

    @Override
    public InetAddress getLocalAddress() {
        InetAddress in;
        if (this.isClosed()) {
            return null;
        }
        try {
            SecurityManager s;
            in = (InetAddress)this.getImpl().getOption(15);
            if (in.isAnyLocalAddress()) {
                in = InetAddress.anyLocalAddress();
            }
            if ((s = System.getSecurityManager()) != null) {
                s.checkConnect(in.getHostAddress(), -1);
            }
        }
        catch (Exception e) {
            in = InetAddress.anyLocalAddress();
        }
        return in;
    }

    @Override
    public int getLocalPort() {
        if (this.isClosed()) {
            return -1;
        }
        try {
            return this.getImpl().getLocalPort();
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Override
    public synchronized void setSoTimeout(int timeout) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("timeout < 0");
        }
        this.getImpl().setOption(4102, (Object)timeout);
    }

    @Override
    public synchronized int getSoTimeout() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (this.getImpl() == null) {
            return 0;
        }
        Object o = this.getImpl().getOption(4102);
        if (o instanceof Integer) {
            return (Integer)o;
        }
        return 0;
    }

    @Override
    public synchronized void setSendBufferSize(int size) throws SocketException {
        if (size <= 0) {
            throw new IllegalArgumentException("negative send size");
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setOption(4097, (Object)size);
    }

    @Override
    public synchronized int getSendBufferSize() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        int result = 0;
        Object o = this.getImpl().getOption(4097);
        if (o instanceof Integer) {
            result = (Integer)o;
        }
        return result;
    }

    @Override
    public synchronized void setReceiveBufferSize(int size) throws SocketException {
        if (size <= 0) {
            throw new IllegalArgumentException("invalid receive size");
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setOption(4098, (Object)size);
    }

    @Override
    public synchronized int getReceiveBufferSize() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        int result = 0;
        Object o = this.getImpl().getOption(4098);
        if (o instanceof Integer) {
            result = (Integer)o;
        }
        return result;
    }

    @Override
    public synchronized void setReuseAddress(boolean on) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (this.oldImpl) {
            this.getImpl().setOption(4, (Object)(on ? -1 : 0));
        } else {
            this.getImpl().setOption(4, (Object)on);
        }
    }

    @Override
    public synchronized boolean getReuseAddress() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        Object o = this.getImpl().getOption(4);
        return (Boolean)o;
    }

    @Override
    public synchronized void setBroadcast(boolean on) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setOption(32, (Object)on);
    }

    @Override
    public synchronized boolean getBroadcast() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        return (Boolean)this.getImpl().getOption(32);
    }

    @Override
    public synchronized void setTrafficClass(int tc) throws SocketException {
        block4: {
            if (tc < 0 || tc > 255) {
                throw new IllegalArgumentException("tc is not in range 0 -- 255");
            }
            if (this.isClosed()) {
                throw new SocketException("Socket is closed");
            }
            try {
                this.getImpl().setOption(3, (Object)tc);
            }
            catch (SocketException se) {
                if (this.isConnected()) break block4;
                throw se;
            }
        }
    }

    @Override
    public synchronized int getTrafficClass() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        return (Integer)this.getImpl().getOption(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object2 = this.closeLock;
        synchronized (object2) {
            if (this.isClosed()) {
                return;
            }
            this.impl.close();
            this.closed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isClosed() {
        Object object2 = this.closeLock;
        synchronized (object2) {
            return this.closed;
        }
    }

    @Override
    public <T> DatagramSocket setOption(SocketOption<T> name, T value) throws IOException {
        Objects.requireNonNull(name);
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setOption(name, value);
        return this;
    }

    @Override
    public <T> T getOption(SocketOption<T> name) throws IOException {
        Objects.requireNonNull(name);
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        return this.getImpl().getOption(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<SocketOption<?>> supportedOptions() {
        Set<SocketOption<Object>> options = this.options;
        if (options != null) {
            return options;
        }
        Object object2 = this.optionsLock;
        synchronized (object2) {
            options = this.options;
            if (options != null) {
                return options;
            }
            try {
                DatagramSocketImpl impl = this.getImpl();
                options = Collections.unmodifiableSet(impl.supportedOptions());
            }
            catch (IOException e) {
                options = Collections.emptySet();
            }
            this.options = options;
            return this.options;
        }
    }

    @Override
    @Deprecated
    public void setTTL(byte ttl) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setTTL(ttl);
    }

    @Override
    public void setTimeToLive(int ttl) throws IOException {
        if (ttl < 0 || ttl > 255) {
            throw new IllegalArgumentException("ttl out of range");
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setTimeToLive(ttl);
    }

    @Override
    @Deprecated
    public byte getTTL() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        return this.getImpl().getTTL();
    }

    @Override
    public int getTimeToLive() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        return this.getImpl().getTimeToLive();
    }

    @Override
    @Deprecated
    public void joinGroup(InetAddress mcastaddr) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        NetMulticastSocket.checkAddress(mcastaddr, "joinGroup");
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkMulticast(mcastaddr);
        }
        if (!mcastaddr.isMulticastAddress()) {
            throw new SocketException("Not a multicast address");
        }
        NetworkInterface defaultInterface = NetworkInterface.getDefault();
        if (!this.interfaceSet && defaultInterface != null) {
            this.setNetworkInterface(defaultInterface);
        }
        this.getImpl().join(mcastaddr);
    }

    @Override
    @Deprecated
    public void leaveGroup(InetAddress mcastaddr) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        NetMulticastSocket.checkAddress(mcastaddr, "leaveGroup");
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkMulticast(mcastaddr);
        }
        if (!mcastaddr.isMulticastAddress()) {
            throw new SocketException("Not a multicast address");
        }
        this.getImpl().leave(mcastaddr);
    }

    @Override
    public void joinGroup(SocketAddress mcastaddr, NetworkInterface netIf) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!(mcastaddr instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type");
        }
        InetSocketAddress addr = (InetSocketAddress)mcastaddr;
        if (this.oldImpl) {
            throw new UnsupportedOperationException();
        }
        NetMulticastSocket.checkAddress(addr.getAddress(), "joinGroup");
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkMulticast(addr.getAddress());
        }
        if (!addr.getAddress().isMulticastAddress()) {
            throw new SocketException("Not a multicast address");
        }
        this.getImpl().joinGroup(mcastaddr, netIf);
    }

    @Override
    public void leaveGroup(SocketAddress mcastaddr, NetworkInterface netIf) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!(mcastaddr instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type");
        }
        InetSocketAddress addr = (InetSocketAddress)mcastaddr;
        if (this.oldImpl) {
            throw new UnsupportedOperationException();
        }
        NetMulticastSocket.checkAddress(addr.getAddress(), "leaveGroup");
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkMulticast(addr.getAddress());
        }
        if (!addr.getAddress().isMulticastAddress()) {
            throw new SocketException("Not a multicast address");
        }
        this.getImpl().leaveGroup(mcastaddr, netIf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void setInterface(InetAddress inf) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        NetMulticastSocket.checkAddress(inf, "setInterface");
        Object object2 = this.infLock;
        synchronized (object2) {
            this.getImpl().setOption(16, inf);
            this.infAddress = inf;
            this.interfaceSet = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public InetAddress getInterface() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        Object object2 = this.infLock;
        synchronized (object2) {
            InetAddress ia = (InetAddress)this.getImpl().getOption(16);
            if (this.infAddress == null) {
                return ia;
            }
            if (ia.equals(this.infAddress)) {
                return ia;
            }
            try {
                NetworkInterface ni = NetworkInterface.getByInetAddress(ia);
                Enumeration<InetAddress> addrs = ni.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    InetAddress addr = addrs.nextElement();
                    if (!addr.equals(this.infAddress)) continue;
                    return this.infAddress;
                }
                this.infAddress = null;
                return ia;
            }
            catch (Exception e) {
                return ia;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNetworkInterface(NetworkInterface netIf) throws SocketException {
        Object object2 = this.infLock;
        synchronized (object2) {
            this.getImpl().setOption(31, netIf);
            this.infAddress = null;
            this.interfaceSet = true;
        }
    }

    @Override
    public NetworkInterface getNetworkInterface() throws SocketException {
        NetworkInterface ni = (NetworkInterface)this.getImpl().getOption(31);
        if (ni == null) {
            InetAddress[] addrs = new InetAddress[]{InetAddress.anyLocalAddress()};
            return new NetworkInterface(addrs[0].getHostName(), 0, addrs);
        }
        return ni;
    }

    @Override
    @Deprecated
    public void setLoopbackMode(boolean disable) throws SocketException {
        this.getImpl().setOption(18, (Object)disable);
    }

    @Override
    @Deprecated
    public boolean getLoopbackMode() throws SocketException {
        return (Boolean)this.getImpl().getOption(18);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void send(DatagramPacket p, byte ttl) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        Object object2 = this.ttlLock;
        synchronized (object2) {
            DatagramPacket datagramPacket = p;
            synchronized (datagramPacket) {
                InetAddress packetAddress = p.getAddress();
                NetMulticastSocket.checkAddress(packetAddress, "send");
                if (this.connectState == 0) {
                    if (packetAddress == null) {
                        throw new IllegalArgumentException("Address not set");
                    }
                    SecurityManager security = System.getSecurityManager();
                    if (security != null) {
                        if (packetAddress.isMulticastAddress()) {
                            security.checkMulticast(packetAddress, ttl);
                        } else {
                            security.checkConnect(packetAddress.getHostAddress(), p.getPort());
                        }
                    }
                } else if (packetAddress == null) {
                    p.setAddress(this.connectedAddress);
                    p.setPort(this.connectedPort);
                } else if (!packetAddress.equals(this.connectedAddress) || p.getPort() != this.connectedPort) {
                    throw new IllegalArgumentException("connected address and packet address differ");
                }
                byte dttl = this.getTTL();
                try {
                    if (ttl != dttl) {
                        this.getImpl().setTTL(ttl);
                    }
                    if (p.getPort() == 0) {
                        throw new SocketException("Can't send to port 0");
                    }
                    this.getImpl().send(p);
                }
                finally {
                    if (ttl != dttl) {
                        this.getImpl().setTTL(dttl);
                    }
                }
            }
        }
    }
}

