/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.net.AbstractPlainSocketImpl;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetAddressContainer;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.security.AccessController;
import jdk.internal.access.JavaIOFileDescriptorAccess;
import jdk.internal.access.SharedSecrets;
import sun.security.action.GetPropertyAction;

class PlainSocketImpl
extends AbstractPlainSocketImpl {
    private static final JavaIOFileDescriptorAccess fdAccess = SharedSecrets.getJavaIOFileDescriptorAccess();
    private static final boolean preferIPv4Stack = Boolean.parseBoolean(AccessController.doPrivileged(new GetPropertyAction("java.net.preferIPv4Stack", "false")));
    private static final boolean useExclusiveBind;
    private boolean isReuseAddress;
    static final int WOULDBLOCK = -2;

    PlainSocketImpl(boolean isServer) {
        super(isServer);
    }

    @Override
    void socketCreate(boolean stream) throws IOException {
        if (this.fd == null) {
            throw new SocketException("Socket closed");
        }
        int newfd = PlainSocketImpl.socket0(stream);
        fdAccess.set(this.fd, newfd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void socketConnect(InetAddress address, int port, int timeout) throws IOException {
        int nativefd = this.checkAndReturnNativeFD();
        if (address == null) {
            throw new NullPointerException("inet address argument is null.");
        }
        if (preferIPv4Stack && !(address instanceof Inet4Address)) {
            throw new SocketException("Protocol family not supported");
        }
        if (timeout <= 0) {
            int connectResult = PlainSocketImpl.connect0(nativefd, address, port);
        } else {
            PlainSocketImpl.configureBlocking(nativefd, false);
            try {
                int connectResult = PlainSocketImpl.connect0(nativefd, address, port);
                if (connectResult == -2) {
                    PlainSocketImpl.waitForConnect(nativefd, timeout);
                }
            }
            finally {
                PlainSocketImpl.configureBlocking(nativefd, true);
            }
        }
        if (this.localport == 0) {
            this.localport = PlainSocketImpl.localPort0(nativefd);
        }
    }

    @Override
    void socketBind(InetAddress address, int port) throws IOException {
        int nativefd = this.checkAndReturnNativeFD();
        if (address == null) {
            throw new NullPointerException("inet address argument is null.");
        }
        if (preferIPv4Stack && !(address instanceof Inet4Address)) {
            throw new SocketException("Protocol family not supported");
        }
        PlainSocketImpl.bind0(nativefd, address, port, useExclusiveBind);
        this.localport = port == 0 ? PlainSocketImpl.localPort0(nativefd) : port;
        this.address = address;
    }

    @Override
    void socketListen(int backlog) throws IOException {
        int nativefd = this.checkAndReturnNativeFD();
        PlainSocketImpl.listen0(nativefd, backlog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void socketAccept(SocketImpl s) throws IOException {
        int nativefd = this.checkAndReturnNativeFD();
        if (s == null) {
            throw new NullPointerException("socket is null");
        }
        int newfd = -1;
        InetSocketAddress[] isaa = new InetSocketAddress[1];
        if (this.timeout <= 0) {
            newfd = PlainSocketImpl.accept0(nativefd, isaa);
        } else {
            PlainSocketImpl.configureBlocking(nativefd, false);
            try {
                PlainSocketImpl.waitForNewConnection(nativefd, this.timeout);
                newfd = PlainSocketImpl.accept0(nativefd, isaa);
                if (newfd != -1) {
                    PlainSocketImpl.configureBlocking(newfd, true);
                }
            }
            finally {
                PlainSocketImpl.configureBlocking(nativefd, true);
            }
        }
        fdAccess.set(s.fd, newfd);
        InetSocketAddress isa = isaa[0];
        s.port = isa.getPort();
        s.address = isa.getAddress();
        s.localport = this.localport;
        if (preferIPv4Stack && !(s.address instanceof Inet4Address)) {
            throw new SocketException("Protocol family not supported");
        }
    }

    @Override
    int socketAvailable() throws IOException {
        int nativefd = this.checkAndReturnNativeFD();
        return PlainSocketImpl.available0(nativefd);
    }

    @Override
    void socketClose0(boolean useDeferredClose) throws IOException {
        if (this.fd == null) {
            throw new SocketException("Socket closed");
        }
        if (!this.fd.valid()) {
            return;
        }
        int nativefd = fdAccess.get(this.fd);
        fdAccess.set(this.fd, -1);
        PlainSocketImpl.close0(nativefd);
    }

    @Override
    void socketShutdown(int howto) throws IOException {
        int nativefd = this.checkAndReturnNativeFD();
        PlainSocketImpl.shutdown0(nativefd, howto);
    }

    @Override
    void socketSetOption(int opt, boolean on, Object value) throws SocketException {
        if (opt == 14) {
            throw new UnsupportedOperationException("unsupported option");
        }
        int nativefd = this.checkAndReturnNativeFD();
        if (opt == 4102) {
            if (preferIPv4Stack && !this.isServer) {
                PlainSocketImpl.setSoTimeout0(nativefd, (Integer)value);
            }
            return;
        }
        int optionValue = 0;
        switch (opt) {
            case 4: {
                if (useExclusiveBind) {
                    this.isReuseAddress = on;
                    return;
                }
            }
            case 1: 
            case 8: 
            case 4099: {
                optionValue = on ? 1 : 0;
                break;
            }
            case 3: 
            case 4097: 
            case 4098: {
                optionValue = (Integer)value;
                break;
            }
            case 128: {
                if (on) {
                    optionValue = (Integer)value;
                    break;
                }
                optionValue = -1;
                break;
            }
            default: {
                throw new SocketException("Option not supported");
            }
        }
        PlainSocketImpl.setIntOption(nativefd, opt, optionValue);
    }

    @Override
    int socketGetOption(int opt, Object iaContainerObj) throws SocketException {
        if (opt == 14) {
            throw new UnsupportedOperationException("unsupported option");
        }
        int nativefd = this.checkAndReturnNativeFD();
        if (opt == 15) {
            PlainSocketImpl.localAddress(nativefd, (InetAddressContainer)iaContainerObj);
            return 0;
        }
        if (opt == 4 && useExclusiveBind) {
            return this.isReuseAddress ? 1 : -1;
        }
        int value = PlainSocketImpl.getIntOption(nativefd, opt);
        switch (opt) {
            case 1: 
            case 4: 
            case 8: 
            case 4099: {
                return value == 0 ? -1 : 1;
            }
        }
        return value;
    }

    @Override
    void socketSendUrgentData(int data) throws IOException {
        int nativefd = this.checkAndReturnNativeFD();
        PlainSocketImpl.sendOOB(nativefd, data);
    }

    private int checkAndReturnNativeFD() throws SocketException {
        if (this.fd == null || !this.fd.valid()) {
            throw new SocketException("Socket closed");
        }
        return fdAccess.get(this.fd);
    }

    static native void initIDs();

    static native int socket0(boolean var0) throws IOException;

    static native void bind0(int var0, InetAddress var1, int var2, boolean var3) throws IOException;

    static native int connect0(int var0, InetAddress var1, int var2) throws IOException;

    static native void waitForConnect(int var0, int var1) throws IOException;

    static native int localPort0(int var0) throws IOException;

    static native void localAddress(int var0, InetAddressContainer var1) throws SocketException;

    static native void listen0(int var0, int var1) throws IOException;

    static native int accept0(int var0, InetSocketAddress[] var1) throws IOException;

    static native void waitForNewConnection(int var0, int var1) throws IOException;

    static native int available0(int var0) throws IOException;

    static native void close0(int var0) throws IOException;

    static native void shutdown0(int var0, int var1) throws IOException;

    static native void setIntOption(int var0, int var1, int var2) throws SocketException;

    static native void setSoTimeout0(int var0, int var1) throws SocketException;

    static native int getIntOption(int var0, int var1) throws SocketException;

    static native void sendOOB(int var0, int var1) throws IOException;

    static native void configureBlocking(int var0, boolean var1) throws IOException;

    static {
        String exclBindProp = AccessController.doPrivileged(new GetPropertyAction("sun.net.useExclusiveBind", ""));
        useExclusiveBind = exclBindProp.isEmpty() || Boolean.parseBoolean(exclBindProp);
        PlainSocketImpl.initIDs();
    }
}

