/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.Closeable;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.DelegatingSocketImpl;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketImplFactory;
import java.net.SocketOption;
import java.nio.channels.ServerSocketChannel;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import sun.net.PlatformSocketImpl;
import sun.security.util.SecurityConstants;

public class ServerSocket
implements Closeable {
    private boolean created = false;
    private boolean bound = false;
    private boolean closed = false;
    private Object closeLock = new Object();
    private SocketImpl impl;
    private static volatile SocketImplFactory factory;
    private volatile Set<SocketOption<?>> options;

    protected ServerSocket(SocketImpl impl) {
        Objects.requireNonNull(impl);
        ServerSocket.checkPermission();
        this.impl = impl;
    }

    private static Void checkPermission() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SecurityConstants.SET_SOCKETIMPL_PERMISSION);
        }
        return null;
    }

    public ServerSocket() throws IOException {
        this.setImpl();
    }

    public ServerSocket(int port) throws IOException {
        this(port, 50, null);
    }

    public ServerSocket(int port, int backlog) throws IOException {
        this(port, backlog, null);
    }

    public ServerSocket(int port, int backlog, InetAddress bindAddr) throws IOException {
        this.setImpl();
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("Port value out of range: " + port);
        }
        if (backlog < 1) {
            backlog = 50;
        }
        try {
            this.bind(new InetSocketAddress(bindAddr, port), backlog);
        }
        catch (SecurityException e) {
            this.close();
            throw e;
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
    }

    SocketImpl getImpl() throws SocketException {
        if (!this.created) {
            this.createImpl();
        }
        return this.impl;
    }

    private void setImpl() {
        SocketImplFactory factory = ServerSocket.factory;
        this.impl = factory != null ? factory.createSocketImpl() : SocketImpl.createPlatformSocketImpl(true);
    }

    void createImpl() throws SocketException {
        if (this.impl == null) {
            this.setImpl();
        }
        try {
            this.impl.create(true);
            this.created = true;
        }
        catch (IOException e) {
            throw new SocketException(e.getMessage());
        }
    }

    public void bind(SocketAddress endpoint) throws IOException {
        this.bind(endpoint, 50);
    }

    public void bind(SocketAddress endpoint, int backlog) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (this.isBound()) {
            throw new SocketException("Already bound");
        }
        if (endpoint == null) {
            endpoint = new InetSocketAddress(0);
        }
        if (!(endpoint instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type");
        }
        InetSocketAddress epoint = (InetSocketAddress)endpoint;
        if (epoint.isUnresolved()) {
            throw new SocketException("Unresolved address");
        }
        if (backlog < 1) {
            backlog = 50;
        }
        try {
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkListen(epoint.getPort());
            }
            this.getImpl().bind(epoint.getAddress(), epoint.getPort());
            this.getImpl().listen(backlog);
            this.bound = true;
        }
        catch (SecurityException e) {
            this.bound = false;
            throw e;
        }
        catch (IOException e) {
            this.bound = false;
            throw e;
        }
    }

    public InetAddress getInetAddress() {
        if (!this.isBound()) {
            return null;
        }
        try {
            InetAddress in = this.getImpl().getInetAddress();
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkConnect(in.getHostAddress(), -1);
            }
            return in;
        }
        catch (SecurityException e) {
            return InetAddress.getLoopbackAddress();
        }
        catch (SocketException socketException) {
            return null;
        }
    }

    public int getLocalPort() {
        if (!this.isBound()) {
            return -1;
        }
        try {
            return this.getImpl().getLocalPort();
        }
        catch (SocketException socketException) {
            return -1;
        }
    }

    public SocketAddress getLocalSocketAddress() {
        if (!this.isBound()) {
            return null;
        }
        return new InetSocketAddress(this.getInetAddress(), this.getLocalPort());
    }

    public Socket accept() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isBound()) {
            throw new SocketException("Socket is not bound yet");
        }
        Socket s = new Socket((SocketImpl)null);
        this.implAccept(s);
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void implAccept(Socket s) throws IOException {
        SocketImpl si = s.impl;
        if (si == null) {
            si = this.implAccept();
            s.setImpl(si);
            s.postAccept();
            return;
        }
        if (si instanceof DelegatingSocketImpl) {
            si = ((DelegatingSocketImpl)si).delegate();
            assert (si instanceof PlatformSocketImpl);
        }
        this.ensureCompatible(si);
        if (this.impl instanceof PlatformSocketImpl) {
            SocketImpl psi = this.platformImplAccept();
            si.copyOptionsTo(psi);
            s.setImpl(psi);
            si.closeQuietly();
        } else {
            s.impl = null;
            try {
                this.customImplAccept(si);
            }
            finally {
                s.impl = si;
            }
        }
        s.postAccept();
    }

    private SocketImpl implAccept() throws IOException {
        if (this.impl instanceof PlatformSocketImpl) {
            return this.platformImplAccept();
        }
        SocketImplFactory factory = Socket.socketImplFactory();
        if (factory == null) {
            throw new IOException("An instance of " + this.impl.getClass() + " cannot accept connection with 'null' SocketImpl: client socket implementation factory not set");
        }
        SocketImpl si = factory.createSocketImpl();
        this.customImplAccept(si);
        return si;
    }

    private SocketImpl platformImplAccept() throws IOException {
        assert (this.impl instanceof PlatformSocketImpl);
        Object psi = SocketImpl.createPlatformSocketImpl(false);
        this.implAccept((SocketImpl)psi);
        return psi;
    }

    private void customImplAccept(SocketImpl si) throws IOException {
        assert (!(this.impl instanceof PlatformSocketImpl) && !(si instanceof PlatformSocketImpl));
        si.reset();
        try {
            si.fd = new FileDescriptor();
            si.address = new InetAddress();
            this.implAccept(si);
        }
        catch (Exception e) {
            si.reset();
            throw e;
        }
    }

    private void implAccept(SocketImpl si) throws IOException {
        assert (!(si instanceof DelegatingSocketImpl));
        this.impl.accept(si);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkAccept(si.getInetAddress().getHostAddress(), si.getPort());
            }
            catch (SecurityException se) {
                si.close();
                throw se;
            }
        }
    }

    private void ensureCompatible(SocketImpl si) throws IOException {
        if (this.impl instanceof PlatformSocketImpl != si instanceof PlatformSocketImpl) {
            throw new IOException("An instance of " + this.impl.getClass() + " cannot accept a connection with an instance of " + si.getClass());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object2 = this.closeLock;
        synchronized (object2) {
            if (this.isClosed()) {
                return;
            }
            if (this.created) {
                this.impl.close();
            }
            this.closed = true;
        }
    }

    public ServerSocketChannel getChannel() {
        return null;
    }

    public boolean isBound() {
        return this.bound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        Object object2 = this.closeLock;
        synchronized (object2) {
            return this.closed;
        }
    }

    public synchronized void setSoTimeout(int timeout) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("timeout < 0");
        }
        this.getImpl().setOption(4102, (Object)timeout);
    }

    public synchronized int getSoTimeout() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        Object o = this.getImpl().getOption(4102);
        if (o instanceof Integer) {
            return (Integer)o;
        }
        return 0;
    }

    public void setReuseAddress(boolean on) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setOption(4, (Object)on);
    }

    public boolean getReuseAddress() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        return (Boolean)this.getImpl().getOption(4);
    }

    public String toString() {
        if (!this.isBound()) {
            return "ServerSocket[unbound]";
        }
        InetAddress in = System.getSecurityManager() != null ? this.getInetAddress() : this.impl.getInetAddress();
        return "ServerSocket[addr=" + in + ",localport=" + this.impl.getLocalPort() + "]";
    }

    @Deprecated(since="17")
    public static synchronized void setSocketFactory(SocketImplFactory fac) throws IOException {
        if (factory != null) {
            throw new SocketException("factory already defined");
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkSetFactory();
        }
        factory = fac;
    }

    public synchronized void setReceiveBufferSize(int size) throws SocketException {
        if (size <= 0) {
            throw new IllegalArgumentException("negative receive size");
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setOption(4098, (Object)size);
    }

    public synchronized int getReceiveBufferSize() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        int result = 0;
        Object o = this.getImpl().getOption(4098);
        if (o instanceof Integer) {
            result = (Integer)o;
        }
        return result;
    }

    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
    }

    public <T> ServerSocket setOption(SocketOption<T> name, T value) throws IOException {
        Objects.requireNonNull(name);
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setOption(name, value);
        return this;
    }

    public <T> T getOption(SocketOption<T> name) throws IOException {
        Objects.requireNonNull(name);
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        return this.getImpl().getOption(name);
    }

    public Set<SocketOption<?>> supportedOptions() {
        Set<SocketOption<?>> so = this.options;
        if (so != null) {
            return so;
        }
        try {
            SocketImpl impl = this.getImpl();
            this.options = Collections.unmodifiableSet(impl.supportedOptions());
        }
        catch (IOException e) {
            this.options = Collections.emptySet();
        }
        return this.options;
    }
}

