/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.net.HttpConnectSocketImpl;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketImplFactory;
import java.net.SocketOption;
import java.net.SocksSocketImpl;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import sun.net.ApplicationProxy;
import sun.security.util.SecurityConstants;

public class Socket
implements Closeable {
    private boolean created = false;
    private boolean bound = false;
    private boolean connected = false;
    private boolean closed = false;
    private Object closeLock = new Object();
    private boolean shutIn = false;
    private boolean shutOut = false;
    SocketImpl impl;
    private volatile InputStream in;
    private volatile OutputStream out;
    private static final VarHandle IN;
    private static final VarHandle OUT;
    private static volatile SocketImplFactory factory;
    private volatile Set<SocketOption<?>> options;

    public Socket() {
        this.setImpl();
    }

    public Socket(Proxy proxy) {
        if (proxy == null) {
            throw new IllegalArgumentException("Invalid Proxy");
        }
        Proxy p = proxy == Proxy.NO_PROXY ? Proxy.NO_PROXY : ApplicationProxy.create(proxy);
        Proxy.Type type = p.type();
        if (type == Proxy.Type.SOCKS || type == Proxy.Type.HTTP) {
            SecurityManager security = System.getSecurityManager();
            InetSocketAddress epoint = (InetSocketAddress)p.address();
            if (epoint.getAddress() != null) {
                this.checkAddress(epoint.getAddress(), "Socket");
            }
            if (security != null) {
                if (epoint.isUnresolved()) {
                    epoint = new InetSocketAddress(epoint.getHostName(), epoint.getPort());
                }
                if (epoint.isUnresolved()) {
                    security.checkConnect(epoint.getHostName(), epoint.getPort());
                } else {
                    security.checkConnect(epoint.getAddress().getHostAddress(), epoint.getPort());
                }
            }
            Object delegate = SocketImpl.createPlatformSocketImpl(false);
            this.impl = type == Proxy.Type.SOCKS ? new SocksSocketImpl(p, (SocketImpl)delegate) : new HttpConnectSocketImpl(p, (SocketImpl)delegate, this);
        } else if (p == Proxy.NO_PROXY) {
            SocketImplFactory factory = Socket.factory;
            this.impl = factory == null ? SocketImpl.createPlatformSocketImpl(false) : factory.createSocketImpl();
        } else {
            throw new IllegalArgumentException("Invalid Proxy");
        }
    }

    protected Socket(SocketImpl impl) throws SocketException {
        Socket.checkPermission(impl);
        this.impl = impl;
    }

    private static Void checkPermission(SocketImpl impl) {
        if (impl == null) {
            return null;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SecurityConstants.SET_SOCKETIMPL_PERMISSION);
        }
        return null;
    }

    public Socket(String host, int port) throws UnknownHostException, IOException {
        this(host != null ? new InetSocketAddress(host, port) : new InetSocketAddress(InetAddress.getByName(null), port), null, true);
    }

    public Socket(InetAddress address, int port) throws IOException {
        this(address != null ? new InetSocketAddress(address, port) : null, null, true);
    }

    public Socket(String host, int port, InetAddress localAddr, int localPort) throws IOException {
        this(host != null ? new InetSocketAddress(host, port) : new InetSocketAddress(InetAddress.getByName(null), port), new InetSocketAddress(localAddr, localPort), true);
    }

    public Socket(InetAddress address, int port, InetAddress localAddr, int localPort) throws IOException {
        this(address != null ? new InetSocketAddress(address, port) : null, new InetSocketAddress(localAddr, localPort), true);
    }

    @Deprecated
    public Socket(String host, int port, boolean stream) throws IOException {
        this(host != null ? new InetSocketAddress(host, port) : new InetSocketAddress(InetAddress.getByName(null), port), null, stream);
    }

    @Deprecated
    public Socket(InetAddress host, int port, boolean stream) throws IOException {
        this(host != null ? new InetSocketAddress(host, port) : null, new InetSocketAddress(0), stream);
    }

    private Socket(SocketAddress address, SocketAddress localAddr, boolean stream) throws IOException {
        this.setImpl();
        if (address == null) {
            throw new NullPointerException();
        }
        try {
            this.createImpl(stream);
            if (localAddr != null) {
                this.bind(localAddr);
            }
            this.connect(address);
        }
        catch (IOException | IllegalArgumentException | SecurityException e) {
            try {
                this.close();
            }
            catch (IOException ce) {
                e.addSuppressed(ce);
            }
            throw e;
        }
    }

    void createImpl(boolean stream) throws SocketException {
        if (this.impl == null) {
            this.setImpl();
        }
        try {
            this.impl.create(stream);
            this.created = true;
        }
        catch (IOException e) {
            throw new SocketException(e.getMessage());
        }
    }

    void setImpl(SocketImpl si) {
        this.impl = si;
    }

    void setImpl() {
        SocketImplFactory factory = Socket.factory;
        if (factory != null) {
            this.impl = factory.createSocketImpl();
        } else {
            Object delegate = SocketImpl.createPlatformSocketImpl(false);
            this.impl = new SocksSocketImpl((SocketImpl)delegate);
        }
    }

    SocketImpl getImpl() throws SocketException {
        if (!this.created) {
            this.createImpl(true);
        }
        return this.impl;
    }

    public void connect(SocketAddress endpoint) throws IOException {
        this.connect(endpoint, 0);
    }

    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        if (endpoint == null) {
            throw new IllegalArgumentException("connect: The address can't be null");
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("connect: timeout can't be negative");
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (this.isConnected()) {
            throw new SocketException("already connected");
        }
        if (!(endpoint instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type");
        }
        InetSocketAddress epoint = (InetSocketAddress)endpoint;
        InetAddress addr = epoint.getAddress();
        int port = epoint.getPort();
        this.checkAddress(addr, "connect");
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            if (epoint.isUnresolved()) {
                security.checkConnect(epoint.getHostName(), port);
            } else {
                security.checkConnect(addr.getHostAddress(), port);
            }
        }
        if (!this.created) {
            this.createImpl(true);
        }
        this.impl.connect(epoint, timeout);
        this.connected = true;
        this.bound = true;
    }

    public void bind(SocketAddress bindpoint) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (this.isBound()) {
            throw new SocketException("Already bound");
        }
        if (bindpoint != null && !(bindpoint instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type");
        }
        InetSocketAddress epoint = (InetSocketAddress)bindpoint;
        if (epoint != null && epoint.isUnresolved()) {
            throw new SocketException("Unresolved address");
        }
        if (epoint == null) {
            epoint = new InetSocketAddress(0);
        }
        InetAddress addr = epoint.getAddress();
        int port = epoint.getPort();
        this.checkAddress(addr, "bind");
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkListen(port);
        }
        this.getImpl().bind(addr, port);
        this.bound = true;
    }

    private void checkAddress(InetAddress addr, String op) {
        if (addr == null) {
            return;
        }
        if (!(addr instanceof Inet4Address) && !(addr instanceof Inet6Address)) {
            throw new IllegalArgumentException(op + ": invalid address type");
        }
    }

    final void postAccept() {
        this.connected = true;
        this.created = true;
        this.bound = true;
    }

    public InetAddress getInetAddress() {
        if (!this.isConnected()) {
            return null;
        }
        try {
            return this.getImpl().getInetAddress();
        }
        catch (SocketException socketException) {
            return null;
        }
    }

    public InetAddress getLocalAddress() {
        if (!this.isBound()) {
            return InetAddress.anyLocalAddress();
        }
        InetAddress in = null;
        try {
            in = (InetAddress)this.getImpl().getOption(15);
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkConnect(in.getHostAddress(), -1);
            }
            if (in.isAnyLocalAddress()) {
                in = InetAddress.anyLocalAddress();
            }
        }
        catch (SecurityException e) {
            in = InetAddress.getLoopbackAddress();
        }
        catch (Exception e) {
            in = InetAddress.anyLocalAddress();
        }
        return in;
    }

    public int getPort() {
        if (!this.isConnected()) {
            return 0;
        }
        try {
            return this.getImpl().getPort();
        }
        catch (SocketException socketException) {
            return -1;
        }
    }

    public int getLocalPort() {
        if (!this.isBound()) {
            return -1;
        }
        try {
            return this.getImpl().getLocalPort();
        }
        catch (SocketException socketException) {
            return -1;
        }
    }

    public SocketAddress getRemoteSocketAddress() {
        if (!this.isConnected()) {
            return null;
        }
        return new InetSocketAddress(this.getInetAddress(), this.getPort());
    }

    public SocketAddress getLocalSocketAddress() {
        if (!this.isBound()) {
            return null;
        }
        return new InetSocketAddress(this.getLocalAddress(), this.getLocalPort());
    }

    public SocketChannel getChannel() {
        return null;
    }

    public InputStream getInputStream() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (this.isInputShutdown()) {
            throw new SocketException("Socket input is shutdown");
        }
        InputStream in = this.in;
        if (in == null && !IN.compareAndSet(this, null, in = new SocketInputStream(this, this.impl.getInputStream()))) {
            in = this.in;
        }
        return in;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (this.isOutputShutdown()) {
            throw new SocketException("Socket output is shutdown");
        }
        OutputStream out = this.out;
        if (out == null && !OUT.compareAndSet(this, null, out = new SocketOutputStream(this, this.impl.getOutputStream()))) {
            out = this.out;
        }
        return out;
    }

    public void setTcpNoDelay(boolean on) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setOption(1, (Object)on);
    }

    public boolean getTcpNoDelay() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        return (Boolean)this.getImpl().getOption(1);
    }

    public void setSoLinger(boolean on, int linger) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!on) {
            this.getImpl().setOption(128, (Object)on);
        } else {
            if (linger < 0) {
                throw new IllegalArgumentException("invalid value for SO_LINGER");
            }
            if (linger > 65535) {
                linger = 65535;
            }
            this.getImpl().setOption(128, (Object)linger);
        }
    }

    public int getSoLinger() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        Object o = this.getImpl().getOption(128);
        if (o instanceof Integer) {
            return (Integer)o;
        }
        return -1;
    }

    public void sendUrgentData(int data) throws IOException {
        if (!this.getImpl().supportsUrgentData()) {
            throw new SocketException("Urgent data not supported");
        }
        this.getImpl().sendUrgentData(data);
    }

    public void setOOBInline(boolean on) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setOption(4099, (Object)on);
    }

    public boolean getOOBInline() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        return (Boolean)this.getImpl().getOption(4099);
    }

    public synchronized void setSoTimeout(int timeout) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("timeout can't be negative");
        }
        this.getImpl().setOption(4102, (Object)timeout);
    }

    public synchronized int getSoTimeout() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        Object o = this.getImpl().getOption(4102);
        if (o instanceof Integer) {
            return (Integer)o;
        }
        return 0;
    }

    public synchronized void setSendBufferSize(int size) throws SocketException {
        if (size <= 0) {
            throw new IllegalArgumentException("negative send size");
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setOption(4097, (Object)size);
    }

    public synchronized int getSendBufferSize() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        int result = 0;
        Object o = this.getImpl().getOption(4097);
        if (o instanceof Integer) {
            result = (Integer)o;
        }
        return result;
    }

    public synchronized void setReceiveBufferSize(int size) throws SocketException {
        if (size <= 0) {
            throw new IllegalArgumentException("invalid receive size");
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setOption(4098, (Object)size);
    }

    public synchronized int getReceiveBufferSize() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        int result = 0;
        Object o = this.getImpl().getOption(4098);
        if (o instanceof Integer) {
            result = (Integer)o;
        }
        return result;
    }

    public void setKeepAlive(boolean on) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setOption(8, (Object)on);
    }

    public boolean getKeepAlive() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        return (Boolean)this.getImpl().getOption(8);
    }

    public void setTrafficClass(int tc) throws SocketException {
        block4: {
            if (tc < 0 || tc > 255) {
                throw new IllegalArgumentException("tc is not in range 0 -- 255");
            }
            if (this.isClosed()) {
                throw new SocketException("Socket is closed");
            }
            try {
                this.getImpl().setOption(3, (Object)tc);
            }
            catch (SocketException se) {
                if (this.isConnected()) break block4;
                throw se;
            }
        }
    }

    public int getTrafficClass() throws SocketException {
        return (Integer)this.getImpl().getOption(3);
    }

    public void setReuseAddress(boolean on) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setOption(4, (Object)on);
    }

    public boolean getReuseAddress() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        return (Boolean)this.getImpl().getOption(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        Object object2 = this.closeLock;
        synchronized (object2) {
            if (this.isClosed()) {
                return;
            }
            if (this.created) {
                this.impl.close();
            }
            this.closed = true;
        }
    }

    public void shutdownInput() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (this.isInputShutdown()) {
            throw new SocketException("Socket input is already shutdown");
        }
        this.getImpl().shutdownInput();
        this.shutIn = true;
    }

    public void shutdownOutput() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (this.isOutputShutdown()) {
            throw new SocketException("Socket output is already shutdown");
        }
        this.getImpl().shutdownOutput();
        this.shutOut = true;
    }

    public String toString() {
        try {
            if (this.isConnected()) {
                return "Socket[addr=" + this.getImpl().getInetAddress() + ",port=" + this.getImpl().getPort() + ",localport=" + this.getImpl().getLocalPort() + "]";
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return "Socket[unconnected]";
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean isBound() {
        return this.bound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        Object object2 = this.closeLock;
        synchronized (object2) {
            return this.closed;
        }
    }

    public boolean isInputShutdown() {
        return this.shutIn;
    }

    public boolean isOutputShutdown() {
        return this.shutOut;
    }

    static SocketImplFactory socketImplFactory() {
        return factory;
    }

    @Deprecated(since="17")
    public static synchronized void setSocketImplFactory(SocketImplFactory fac) throws IOException {
        if (factory != null) {
            throw new SocketException("factory already defined");
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkSetFactory();
        }
        factory = fac;
    }

    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
    }

    public <T> Socket setOption(SocketOption<T> name, T value) throws IOException {
        Objects.requireNonNull(name);
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setOption(name, value);
        return this;
    }

    public <T> T getOption(SocketOption<T> name) throws IOException {
        Objects.requireNonNull(name);
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        return this.getImpl().getOption(name);
    }

    public Set<SocketOption<?>> supportedOptions() {
        Set<SocketOption<?>> so = this.options;
        if (so != null) {
            return so;
        }
        try {
            SocketImpl impl = this.getImpl();
            this.options = Collections.unmodifiableSet(impl.supportedOptions());
        }
        catch (IOException e) {
            this.options = Collections.emptySet();
        }
        return this.options;
    }

    static {
        try {
            MethodHandles.Lookup l = MethodHandles.lookup();
            IN = l.findVarHandle(Socket.class, "in", InputStream.class);
            OUT = l.findVarHandle(Socket.class, "out", OutputStream.class);
        }
        catch (Exception e) {
            throw new InternalError(e);
        }
    }

    private static class SocketInputStream
    extends InputStream {
        private final Socket parent;
        private final InputStream in;

        SocketInputStream(Socket parent, InputStream in) {
            this.parent = parent;
            this.in = in;
        }

        @Override
        public int read() throws IOException {
            byte[] a = new byte[1];
            int n = this.read(a, 0, 1);
            return n > 0 ? a[0] & 0xFF : -1;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.in.read(b, off, len);
        }

        @Override
        public int available() throws IOException {
            return this.in.available();
        }

        @Override
        public void close() throws IOException {
            this.parent.close();
        }
    }

    private static class SocketOutputStream
    extends OutputStream {
        private final Socket parent;
        private final OutputStream out;

        SocketOutputStream(Socket parent, OutputStream out) {
            this.parent = parent;
            this.out = out;
        }

        @Override
        public void write(int b) throws IOException {
            byte[] a = new byte[]{(byte)b};
            this.write(a, 0, 1);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }

        @Override
        public void close() throws IOException {
            this.parent.close();
        }
    }
}

