/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.FileDescriptor;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.ref.Cleaner;
import jdk.internal.access.JavaIOFileDescriptorAccess;
import jdk.internal.access.SharedSecrets;
import jdk.internal.ref.CleanerFactory;
import jdk.internal.ref.PhantomCleanable;
import sun.net.ResourceManager;

final class SocketCleanable
extends PhantomCleanable<FileDescriptor> {
    private static final JavaIOFileDescriptorAccess fdAccess = SharedSecrets.getJavaIOFileDescriptorAccess();
    private final int fd;
    private final boolean stream;

    private static native void cleanupClose0(int var0) throws IOException;

    static void register(FileDescriptor fdo, boolean stream) {
        if (fdo != null && fdo.valid()) {
            int fd = fdAccess.get(fdo);
            fdAccess.registerCleanup(fdo, new SocketCleanable(fdo, CleanerFactory.cleaner(), fd, stream));
        }
    }

    static void unregister(FileDescriptor fdo) {
        if (fdo != null) {
            fdAccess.unregisterCleanup(fdo);
        }
    }

    private SocketCleanable(FileDescriptor obj, Cleaner cleaner, int fd, boolean stream) {
        super(obj, cleaner);
        this.fd = fd;
        this.stream = stream;
    }

    @Override
    protected void performCleanup() {
        try {
            SocketCleanable.cleanupClose0(this.fd);
        }
        catch (IOException ioe) {
            throw new UncheckedIOException("close", ioe);
        }
        finally {
            if (!this.stream) {
                ResourceManager.afterUdpClose();
            }
        }
    }
}

