/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.AbstractPlainSocketImpl;
import java.net.SocketException;
import java.nio.channels.FileChannel;
import sun.net.ConnectionResetException;

class SocketInputStream
extends FileInputStream {
    private boolean eof;
    private AbstractPlainSocketImpl impl = null;
    private byte[] temp;

    SocketInputStream(AbstractPlainSocketImpl impl) throws IOException {
        super(impl.getFileDescriptor());
        this.impl = impl;
    }

    @Override
    public final FileChannel getChannel() {
        return null;
    }

    private native int socketRead0(FileDescriptor var1, byte[] var2, int var3, int var4, int var5) throws IOException;

    private int socketRead(FileDescriptor fd, byte[] b, int off, int len, int timeout) throws IOException {
        return this.socketRead0(fd, b, off, len, timeout);
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int length) throws IOException {
        return this.read(b, off, length, this.impl.getTimeout());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int read(byte[] b, int off, int length, int timeout) throws IOException {
        if (this.eof) {
            return -1;
        }
        if (this.impl.isConnectionReset()) {
            throw new SocketException("Connection reset");
        }
        if (length <= 0 || off < 0 || length > b.length - off) {
            if (length == 0) {
                return 0;
            }
            throw new ArrayIndexOutOfBoundsException("length == " + length + " off == " + off + " buffer length == " + b.length);
        }
        FileDescriptor fd = this.impl.acquireFD();
        try {
            int n = this.socketRead(fd, b, off, length, timeout);
            if (n > 0) {
                int n2 = n;
                return n2;
            }
        }
        catch (ConnectionResetException rstExc) {
            this.impl.setConnectionReset();
        }
        finally {
            this.impl.releaseFD();
        }
        if (this.impl.isClosedOrPending()) {
            throw new SocketException("Socket closed");
        }
        if (this.impl.isConnectionReset()) {
            throw new SocketException("Connection reset");
        }
        this.eof = true;
        return -1;
    }

    @Override
    public int read() throws IOException {
        if (this.eof) {
            return -1;
        }
        this.temp = new byte[1];
        int n = this.read(this.temp, 0, 1);
        if (n <= 0) {
            return -1;
        }
        return this.temp[0] & 0xFF;
    }

    @Override
    public long skip(long numbytes) throws IOException {
        int r;
        long n;
        if (numbytes <= 0L) {
            return 0L;
        }
        int buflen = (int)Math.min(1024L, n);
        byte[] data = new byte[buflen];
        for (n = numbytes; n > 0L && (r = this.read(data, 0, (int)Math.min((long)buflen, n))) >= 0; n -= (long)r) {
        }
        return numbytes - n;
    }

    @Override
    public int available() throws IOException {
        int available = this.impl.available();
        return this.eof ? 0 : available;
    }

    void setEOF(boolean eof) {
        this.eof = eof;
    }

    @Override
    public void close() throws IOException {
        assert (false);
    }

    private static native void init();

    static {
        SocketInputStream.init();
    }
}

