/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.AbstractPlainDatagramSocketImpl;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketCleanable;
import java.net.SocketException;
import sun.net.ResourceManager;

final class TwoStacksPlainDatagramSocketImpl
extends AbstractPlainDatagramSocketImpl {
    private FileDescriptor fd1;
    private InetAddress anyLocalBoundAddr = null;
    private int fduse = -1;
    private int lastfd = -1;
    private final boolean exclusiveBind;
    private boolean reuseAddressEmulated;
    private boolean isReuseAddress;

    TwoStacksPlainDatagramSocketImpl(boolean exclBind, boolean isMulticast) {
        super(isMulticast);
        this.exclusiveBind = exclBind;
    }

    @Override
    protected synchronized void create() throws SocketException {
        this.fd1 = new FileDescriptor();
        try {
            super.create();
            SocketCleanable.register(this.fd1, true);
        }
        catch (SocketException e) {
            this.fd1 = null;
            throw e;
        }
    }

    @Override
    protected synchronized void bind(int lport, InetAddress laddr) throws SocketException {
        super.bind(lport, laddr);
        if (laddr.isAnyLocalAddress()) {
            this.anyLocalBoundAddr = laddr;
        }
    }

    @Override
    protected synchronized void bind0(int lport, InetAddress laddr) throws SocketException {
        SocketCleanable.unregister(this.fd);
        SocketCleanable.unregister(this.fd1);
        this.bind0(lport, laddr, this.exclusiveBind);
        SocketCleanable.register(this.fd, false);
        SocketCleanable.register(this.fd1, true);
    }

    @Override
    protected synchronized void receive(DatagramPacket p) throws IOException {
        try {
            this.receive0(p);
        }
        finally {
            this.fduse = -1;
        }
    }

    @Override
    public Object getOption(int optID) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket Closed");
        }
        if (optID == 15) {
            if (this.fd != null && this.fd1 != null && !this.connected) {
                return this.anyLocalBoundAddr;
            }
            int family = this.connectedAddress == null ? -1 : this.connectedAddress.holder().getFamily();
            return this.socketLocalAddress(family);
        }
        if (optID == 4 && this.reuseAddressEmulated) {
            return this.isReuseAddress;
        }
        if (optID == 14) {
            throw new UnsupportedOperationException("unsupported option");
        }
        return super.getOption(optID);
    }

    @Override
    protected void socketSetOption(int opt, Object val) throws SocketException {
        if (opt == 4 && this.exclusiveBind && this.localPort != 0) {
            this.reuseAddressEmulated = true;
            this.isReuseAddress = (Boolean)val;
        } else {
            if (opt == 14) {
                throw new UnsupportedOperationException("unsupported option");
            }
            this.socketNativeSetOption(opt, val);
        }
    }

    @Override
    protected boolean isClosed() {
        return this.fd == null && this.fd1 == null;
    }

    @Override
    protected void close() {
        if (this.fd != null || this.fd1 != null) {
            SocketCleanable.unregister(this.fd);
            SocketCleanable.unregister(this.fd1);
            this.datagramSocketClose();
            ResourceManager.afterUdpClose();
            this.fd = null;
            this.fd1 = null;
        }
    }

    protected synchronized native void bind0(int var1, InetAddress var2, boolean var3) throws SocketException;

    @Override
    protected native void send0(DatagramPacket var1) throws IOException;

    @Override
    protected synchronized native int peek(InetAddress var1) throws IOException;

    @Override
    protected synchronized native int peekData(DatagramPacket var1) throws IOException;

    @Override
    protected synchronized native void receive0(DatagramPacket var1) throws IOException;

    @Override
    protected native void setTimeToLive(int var1) throws IOException;

    @Override
    protected native int getTimeToLive() throws IOException;

    @Override
    @Deprecated
    protected native void setTTL(byte var1) throws IOException;

    @Override
    @Deprecated
    protected native byte getTTL() throws IOException;

    @Override
    protected native void join(InetAddress var1, NetworkInterface var2) throws IOException;

    @Override
    protected native void leave(InetAddress var1, NetworkInterface var2) throws IOException;

    @Override
    protected native void datagramSocketCreate() throws SocketException;

    @Override
    protected native void datagramSocketClose();

    protected native void socketNativeSetOption(int var1, Object var2) throws SocketException;

    @Override
    protected native Object socketGetOption(int var1) throws SocketException;

    @Override
    protected native void connect0(InetAddress var1, int var2) throws SocketException;

    protected native Object socketLocalAddress(int var1) throws SocketException;

    @Override
    protected native void disconnect0(int var1);

    @Override
    native int dataAvailable();

    private static native void init();

    static {
        TwoStacksPlainDatagramSocketImpl.init();
    }
}

