/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.net.UnknownHostException;
import java.net.UrlDeserializedState;
import java.net.spi.URLStreamHandlerProvider;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import jdk.internal.access.JavaNetURLAccess;
import jdk.internal.access.SharedSecrets;
import jdk.internal.misc.VM;
import sun.net.ApplicationProxy;
import sun.net.util.IPAddressUtil;
import sun.net.www.protocol.jrt.Handler;
import sun.security.action.GetPropertyAction;
import sun.security.util.SecurityConstants;

public final class URL
implements Serializable {
    static final String BUILTIN_HANDLERS_PREFIX = "sun.net.www.protocol";
    static final long serialVersionUID = -7627629688361524110L;
    private static final String protocolPathProp = "java.protocol.handler.pkgs";
    private String protocol;
    private String host;
    private int port = -1;
    private String file;
    private transient String query;
    private String authority;
    private transient String path;
    private transient String userInfo;
    private String ref;
    private transient InetAddress hostAddress;
    transient URLStreamHandler handler;
    private int hashCode = -1;
    private transient UrlDeserializedState tempState;
    private static volatile URLStreamHandlerFactory factory;
    private static final URLStreamHandlerFactory defaultFactory;
    private static ThreadLocal<Object> gate;
    static Hashtable<String, URLStreamHandler> handlers;
    private static final Object streamHandlerLock;
    private static final ObjectStreamField[] serialPersistentFields;

    public URL(String protocol, String host, int port, String file) throws MalformedURLException {
        this(protocol, host, port, file, null);
    }

    public URL(String protocol, String host, String file) throws MalformedURLException {
        this(protocol, host, -1, file);
    }

    public URL(String protocol, String host, int port, String file, URLStreamHandler handler) throws MalformedURLException {
        String s;
        int index;
        SecurityManager sm;
        if (handler != null && (sm = System.getSecurityManager()) != null) {
            this.checkSpecifyHandler(sm);
        }
        this.protocol = protocol = URL.toLowerCase(protocol);
        if (host != null) {
            if (host.indexOf(58) >= 0 && !host.startsWith("[")) {
                host = "[" + host + "]";
            }
            this.host = host;
            if (port < -1) {
                throw new MalformedURLException("Invalid port number :" + port);
            }
            this.port = port;
            this.authority = port == -1 ? host : host + ":" + port;
        }
        this.ref = (index = file.indexOf(35)) < 0 ? null : file.substring(index + 1);
        file = index < 0 ? file : file.substring(0, index);
        int q = file.lastIndexOf(63);
        if (q != -1) {
            this.query = file.substring(q + 1);
            this.path = file.substring(0, q);
            this.file = this.path + "?" + this.query;
        } else {
            this.file = this.path = file;
        }
        if (handler == null && (handler = URL.getURLStreamHandler(protocol)) == null) {
            throw new MalformedURLException("unknown protocol: " + protocol);
        }
        this.handler = handler;
        if (host != null && this.isBuiltinStreamHandler(handler) && (s = IPAddressUtil.checkExternalForm(this)) != null) {
            throw new MalformedURLException(s);
        }
        if ("jar".equalsIgnoreCase(protocol) && handler instanceof sun.net.www.protocol.jar.Handler && (s = ((sun.net.www.protocol.jar.Handler)handler).checkNestedProtocol(file)) != null) {
            throw new MalformedURLException(s);
        }
    }

    public URL(String spec) throws MalformedURLException {
        this(null, spec);
    }

    public URL(URL context, String spec) throws MalformedURLException {
        this(context, spec, null);
    }

    public URL(URL context, String spec, URLStreamHandler handler) throws MalformedURLException {
        SecurityManager sm;
        String original = spec;
        int start = 0;
        String newProtocol = null;
        boolean aRef = false;
        boolean isRelative = false;
        if (handler != null && (sm = System.getSecurityManager()) != null) {
            this.checkSpecifyHandler(sm);
        }
        try {
            char c;
            int i;
            int limit;
            for (limit = spec.length(); limit > 0 && spec.charAt(limit - 1) <= ' '; --limit) {
            }
            while (start < limit && spec.charAt(start) <= ' ') {
                ++start;
            }
            if (spec.regionMatches(true, start, "url:", 0, 4)) {
                start += 4;
            }
            if (start < spec.length() && spec.charAt(start) == '#') {
                aRef = true;
            }
            for (i = start; !aRef && i < limit && (c = spec.charAt(i)) != '/'; ++i) {
                if (c != ':') continue;
                String s = URL.toLowerCase(spec.substring(start, i));
                if (!this.isValidProtocol(s)) break;
                newProtocol = s;
                start = i + 1;
                break;
            }
            this.protocol = newProtocol;
            if (context != null && (newProtocol == null || newProtocol.equalsIgnoreCase(context.protocol))) {
                if (handler == null) {
                    handler = context.handler;
                }
                if (context.path != null && context.path.startsWith("/")) {
                    newProtocol = null;
                }
                if (newProtocol == null) {
                    this.protocol = context.protocol;
                    this.authority = context.authority;
                    this.userInfo = context.userInfo;
                    this.host = context.host;
                    this.port = context.port;
                    this.file = context.file;
                    this.path = context.path;
                    isRelative = true;
                }
            }
            if (this.protocol == null) {
                throw new MalformedURLException("no protocol: " + original);
            }
            if (handler == null && (handler = URL.getURLStreamHandler(this.protocol)) == null) {
                throw new MalformedURLException("unknown protocol: " + this.protocol);
            }
            this.handler = handler;
            i = spec.indexOf(35, start);
            if (i >= 0) {
                this.ref = spec.substring(i + 1, limit);
                limit = i;
            }
            if (isRelative && start == limit) {
                this.query = context.query;
                if (this.ref == null) {
                    this.ref = context.ref;
                }
            }
            handler.parseURL(this, spec, start, limit);
        }
        catch (MalformedURLException e) {
            throw e;
        }
        catch (Exception e) {
            MalformedURLException exception = new MalformedURLException(e.getMessage());
            exception.initCause(e);
            throw exception;
        }
    }

    static URL fromURI(URI uri) throws MalformedURLException {
        if (!uri.isAbsolute()) {
            throw new IllegalArgumentException("URI is not absolute");
        }
        String protocol = uri.getScheme();
        if (protocol.equals("jrt") && !uri.isOpaque() && uri.getRawFragment() == null) {
            String query = uri.getRawQuery();
            String path = uri.getRawPath();
            String file = query == null ? path : path + "?" + query;
            String host = uri.getHost();
            if (host == null) {
                host = "";
            }
            int port = uri.getPort();
            return new URL("jrt", host, port, file, null);
        }
        return new URL((URL)null, uri.toString(), null);
    }

    private boolean isValidProtocol(String protocol) {
        int len = protocol.length();
        if (len < 1) {
            return false;
        }
        char c = protocol.charAt(0);
        if (!Character.isLetter(c)) {
            return false;
        }
        for (int i = 1; i < len; ++i) {
            c = protocol.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '.' || c == '+' || c == '-') continue;
            return false;
        }
        return true;
    }

    private void checkSpecifyHandler(SecurityManager sm) {
        sm.checkPermission(SecurityConstants.SPECIFY_HANDLER_PERMISSION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void set(String protocol, String host, int port, String authority, String userInfo, String path, String query, String ref) {
        URL uRL = this;
        synchronized (uRL) {
            this.protocol = protocol;
            this.host = host;
            this.port = port;
            this.file = query == null ? path : path + "?" + query;
            this.userInfo = userInfo;
            this.path = path;
            this.ref = ref;
            this.hashCode = -1;
            this.hostAddress = null;
            this.query = query;
            this.authority = authority;
        }
    }

    synchronized InetAddress getHostAddress() {
        if (this.hostAddress != null) {
            return this.hostAddress;
        }
        if (this.host == null || this.host.isEmpty()) {
            return null;
        }
        try {
            this.hostAddress = InetAddress.getByName(this.host);
        }
        catch (SecurityException | UnknownHostException ex) {
            return null;
        }
        return this.hostAddress;
    }

    public String getQuery() {
        return this.query;
    }

    public String getPath() {
        return this.path;
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    public String getAuthority() {
        return this.authority;
    }

    public int getPort() {
        return this.port;
    }

    public int getDefaultPort() {
        return this.handler.getDefaultPort();
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public String getFile() {
        return this.file;
    }

    public String getRef() {
        return this.ref;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof URL)) {
            return false;
        }
        URL u2 = (URL)obj;
        return this.handler.equals(this, u2);
    }

    public synchronized int hashCode() {
        if (this.hashCode != -1) {
            return this.hashCode;
        }
        this.hashCode = this.handler.hashCode(this);
        return this.hashCode;
    }

    public boolean sameFile(URL other) {
        return this.handler.sameFile(this, other);
    }

    public String toString() {
        return this.toExternalForm();
    }

    public String toExternalForm() {
        return this.handler.toExternalForm(this);
    }

    public URI toURI() throws URISyntaxException {
        String s;
        URI uri = new URI(this.toString());
        if (this.authority != null && this.isBuiltinStreamHandler(this.handler) && (s = IPAddressUtil.checkAuthority(this)) != null) {
            throw new URISyntaxException(this.authority, s);
        }
        return uri;
    }

    public URLConnection openConnection() throws IOException {
        return this.handler.openConnection(this);
    }

    public URLConnection openConnection(Proxy proxy) throws IOException {
        if (proxy == null) {
            throw new IllegalArgumentException("proxy can not be null");
        }
        Proxy p = proxy == Proxy.NO_PROXY ? Proxy.NO_PROXY : ApplicationProxy.create(proxy);
        SecurityManager sm = System.getSecurityManager();
        if (p.type() != Proxy.Type.DIRECT && sm != null) {
            InetSocketAddress epoint = (InetSocketAddress)p.address();
            if (epoint.isUnresolved()) {
                sm.checkConnect(epoint.getHostName(), epoint.getPort());
            } else {
                sm.checkConnect(epoint.getAddress().getHostAddress(), epoint.getPort());
            }
        }
        return this.handler.openConnection(this, p);
    }

    public final InputStream openStream() throws IOException {
        return this.openConnection().getInputStream();
    }

    public final Object getContent() throws IOException {
        return this.openConnection().getContent();
    }

    public final Object getContent(Class<?>[] classes) throws IOException {
        return this.openConnection().getContent(classes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setURLStreamHandlerFactory(URLStreamHandlerFactory fac) {
        Object object2 = streamHandlerLock;
        synchronized (object2) {
            if (factory != null) {
                throw new Error("factory already defined");
            }
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkSetFactory();
            }
            handlers.clear();
            factory = fac;
        }
    }

    private static URLStreamHandler lookupViaProperty(String protocol) {
        String packagePrefixList = GetPropertyAction.privilegedGetProperty(protocolPathProp);
        if (packagePrefixList == null) {
            return null;
        }
        String[] packagePrefixes = packagePrefixList.split("\\|");
        URLStreamHandler handler = null;
        for (int i = 0; handler == null && i < packagePrefixes.length; ++i) {
            String packagePrefix = packagePrefixes[i].trim();
            try {
                Class<?> cls;
                block6: {
                    String clsName = packagePrefix + "." + protocol + ".Handler";
                    cls = null;
                    try {
                        cls = Class.forName(clsName);
                    }
                    catch (ClassNotFoundException e) {
                        ClassLoader cl = ClassLoader.getSystemClassLoader();
                        if (cl == null) break block6;
                        cls = cl.loadClass(clsName);
                    }
                }
                if (cls == null) continue;
                Object tmp = cls.newInstance();
                handler = (URLStreamHandler)tmp;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return handler;
    }

    private static Iterator<URLStreamHandlerProvider> providers() {
        return new Iterator<URLStreamHandlerProvider>(){
            ClassLoader cl = ClassLoader.getSystemClassLoader();
            ServiceLoader<URLStreamHandlerProvider> sl = ServiceLoader.load(URLStreamHandlerProvider.class, this.cl);
            Iterator<URLStreamHandlerProvider> i = this.sl.iterator();
            URLStreamHandlerProvider next = null;

            private boolean getNext() {
                while (this.next == null) {
                    try {
                        if (!this.i.hasNext()) {
                            return false;
                        }
                        this.next = this.i.next();
                    }
                    catch (ServiceConfigurationError sce) {
                        if (sce.getCause() instanceof SecurityException) continue;
                        throw sce;
                    }
                }
                return true;
            }

            @Override
            public boolean hasNext() {
                return this.getNext();
            }

            @Override
            public URLStreamHandlerProvider next() {
                if (!this.getNext()) {
                    throw new NoSuchElementException();
                }
                URLStreamHandlerProvider n = this.next;
                this.next = null;
                return n;
            }
        };
    }

    private static URLStreamHandler lookupViaProviders(final String protocol) {
        if (gate.get() != null) {
            throw new Error("Circular loading of URL stream handler providers detected");
        }
        gate.set(gate);
        try {
            URLStreamHandler uRLStreamHandler = AccessController.doPrivileged(new PrivilegedAction<URLStreamHandler>(){

                @Override
                public URLStreamHandler run() {
                    Iterator<URLStreamHandlerProvider> itr = URL.providers();
                    while (itr.hasNext()) {
                        URLStreamHandlerProvider f = itr.next();
                        URLStreamHandler h = f.createURLStreamHandler(protocol);
                        if (h == null) continue;
                        return h;
                    }
                    return null;
                }
            });
            return uRLStreamHandler;
        }
        finally {
            gate.set(null);
        }
    }

    static String toLowerCase(String protocol) {
        if (protocol.equals("jrt") || protocol.equals("file") || protocol.equals("jar")) {
            return protocol;
        }
        return protocol.toLowerCase(Locale.ROOT);
    }

    static boolean isOverrideable(String protocol) {
        return !(protocol.length() == 3 ? Character.toLowerCase(protocol.charAt(0)) == 'j' && Character.toLowerCase(protocol.charAt(1)) == 'r' && Character.toLowerCase(protocol.charAt(2)) == 't' : protocol.length() == 4 && Character.toLowerCase(protocol.charAt(0)) == 'f' && Character.toLowerCase(protocol.charAt(1)) == 'i' && Character.toLowerCase(protocol.charAt(2)) == 'l' && Character.toLowerCase(protocol.charAt(3)) == 'e');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static URLStreamHandler getURLStreamHandler(String protocol) {
        URLStreamHandlerFactory fac;
        URLStreamHandler handler = handlers.get(protocol);
        if (handler != null) {
            return handler;
        }
        boolean checkedWithFactory = false;
        boolean overrideableProtocol = URL.isOverrideable(protocol);
        if (overrideableProtocol && VM.isBooted()) {
            fac = factory;
            if (fac != null) {
                handler = fac.createURLStreamHandler(protocol);
                checkedWithFactory = true;
            }
            if (handler == null && !protocol.equalsIgnoreCase("jar")) {
                handler = URL.lookupViaProviders(protocol);
            }
            if (handler == null) {
                handler = URL.lookupViaProperty(protocol);
            }
        }
        if (handler == null) {
            handler = defaultFactory.createURLStreamHandler(protocol);
        }
        Object object2 = streamHandlerLock;
        synchronized (object2) {
            URLStreamHandler handler2 = null;
            handler2 = handlers.get(protocol);
            if (handler2 != null) {
                return handler2;
            }
            if (overrideableProtocol && !checkedWithFactory && (fac = factory) != null) {
                handler2 = fac.createURLStreamHandler(protocol);
            }
            if (handler2 != null) {
                handler = handler2;
            }
            if (handler != null) {
                handlers.put(protocol, handler);
            }
        }
        return handler;
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField gf = s.readFields();
        String protocol = (String)gf.get("protocol", null);
        if (URL.getURLStreamHandler(protocol) == null) {
            throw new IOException("unknown protocol: " + protocol);
        }
        String host = (String)gf.get("host", null);
        int port = gf.get("port", -1);
        String authority = (String)gf.get("authority", null);
        String file = (String)gf.get("file", null);
        String ref = (String)gf.get("ref", null);
        int hashCode = gf.get("hashCode", -1);
        if (authority == null && (host != null && !host.isEmpty() || port != -1)) {
            if (host == null) {
                host = "";
            }
            authority = port == -1 ? host : host + ":" + port;
        }
        this.tempState = new UrlDeserializedState(protocol, host, port, authority, file, ref, hashCode);
    }

    private Object readResolve() throws ObjectStreamException {
        URLStreamHandler handler = null;
        handler = URL.getURLStreamHandler(this.tempState.getProtocol());
        URL replacementURL = null;
        replacementURL = this.isBuiltinStreamHandler(handler.getClass().getName()) ? this.fabricateNewURL() : this.setDeserializedFields(handler);
        return replacementURL;
    }

    private URL setDeserializedFields(URLStreamHandler handler) {
        int ind;
        String userInfo = null;
        String protocol = this.tempState.getProtocol();
        String host = this.tempState.getHost();
        int port = this.tempState.getPort();
        String authority = this.tempState.getAuthority();
        String file = this.tempState.getFile();
        String ref = this.tempState.getRef();
        int hashCode = this.tempState.getHashCode();
        if (authority == null && (host != null && !host.isEmpty() || port != -1)) {
            if (host == null) {
                host = "";
            }
            authority = port == -1 ? host : host + ":" + port;
            int at = host.lastIndexOf(64);
            if (at != -1) {
                userInfo = host.substring(0, at);
                host = host.substring(at + 1);
            }
        } else if (authority != null && (ind = authority.indexOf(64)) != -1) {
            userInfo = authority.substring(0, ind);
        }
        String path = null;
        String query = null;
        if (file != null) {
            int q = file.lastIndexOf(63);
            if (q != -1) {
                query = file.substring(q + 1);
                path = file.substring(0, q);
            } else {
                path = file;
            }
        }
        this.protocol = protocol;
        this.host = host;
        this.port = port;
        this.file = file;
        this.authority = authority;
        this.ref = ref;
        this.hashCode = hashCode;
        this.handler = handler;
        this.query = query;
        this.path = path;
        this.userInfo = userInfo;
        URL replacementURL = this;
        return replacementURL;
    }

    private URL fabricateNewURL() throws InvalidObjectException {
        URL replacementURL = null;
        String urlString = this.tempState.reconstituteUrlString();
        try {
            replacementURL = new URL(urlString);
        }
        catch (MalformedURLException mEx) {
            this.resetState();
            InvalidObjectException invoEx = new InvalidObjectException("Malformed URL:  " + urlString);
            invoEx.initCause(mEx);
            throw invoEx;
        }
        replacementURL.setSerializedHashCode(this.tempState.getHashCode());
        this.resetState();
        return replacementURL;
    }

    boolean isBuiltinStreamHandler(URLStreamHandler handler) {
        Class<?> handlerClass = handler.getClass();
        return this.isBuiltinStreamHandler(handlerClass.getName()) || VM.isSystemDomainLoader(handlerClass.getClassLoader());
    }

    private boolean isBuiltinStreamHandler(String handlerClassName) {
        return handlerClassName.startsWith(BUILTIN_HANDLERS_PREFIX);
    }

    private void resetState() {
        this.protocol = null;
        this.host = null;
        this.port = -1;
        this.file = null;
        this.authority = null;
        this.ref = null;
        this.hashCode = -1;
        this.handler = null;
        this.query = null;
        this.path = null;
        this.userInfo = null;
        this.tempState = null;
    }

    private void setSerializedHashCode(int hc) {
        this.hashCode = hc;
    }

    static {
        defaultFactory = new DefaultFactory();
        gate = new ThreadLocal();
        handlers = new Hashtable();
        streamHandlerLock = new Object();
        serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("protocol", String.class), new ObjectStreamField("host", String.class), new ObjectStreamField("port", Integer.TYPE), new ObjectStreamField("authority", String.class), new ObjectStreamField("file", String.class), new ObjectStreamField("ref", String.class), new ObjectStreamField("hashCode", Integer.TYPE)};
        SharedSecrets.setJavaNetURLAccess(new JavaNetURLAccess(){

            @Override
            public URLStreamHandler getHandler(URL u) {
                return u.handler;
            }
        });
    }

    private static class DefaultFactory
    implements URLStreamHandlerFactory {
        private static String PREFIX = "sun.net.www.protocol.";

        private DefaultFactory() {
        }

        @Override
        public URLStreamHandler createURLStreamHandler(String protocol) {
            switch (protocol) {
                case "file": {
                    return new sun.net.www.protocol.file.Handler();
                }
                case "jar": {
                    return new sun.net.www.protocol.jar.Handler();
                }
                case "jrt": {
                    return new Handler();
                }
            }
            String name = PREFIX + protocol + ".Handler";
            try {
                Object o = Class.forName(name).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                return (URLStreamHandler)o;
            }
            catch (Exception exception) {
                return null;
            }
        }
    }
}

