/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.util.concurrent.atomic.AtomicLong;
import jdk.internal.access.JavaLangRefAccess;
import jdk.internal.access.SharedSecrets;
import jdk.internal.misc.Unsafe;
import jdk.internal.misc.VM;

class Bits {
    private static final Unsafe UNSAFE = Unsafe.getUnsafe();
    private static int PAGE_SIZE = -1;
    private static boolean UNALIGNED = UNSAFE.unalignedAccess();
    private static volatile long MAX_MEMORY = VM.maxDirectMemory();
    private static final AtomicLong RESERVED_MEMORY = new AtomicLong();
    private static final AtomicLong TOTAL_CAPACITY = new AtomicLong();
    private static final AtomicLong COUNT = new AtomicLong();
    private static volatile boolean MEMORY_LIMIT_SET;
    private static final int MAX_SLEEPS = 9;
    static final VM.BufferPool BUFFER_POOL;
    static final int JNI_COPY_TO_ARRAY_THRESHOLD = 6;
    static final int JNI_COPY_FROM_ARRAY_THRESHOLD = 6;

    private Bits() {
    }

    static short swap(short x) {
        return Short.reverseBytes(x);
    }

    static char swap(char x) {
        return Character.reverseBytes(x);
    }

    static int swap(int x) {
        return Integer.reverseBytes(x);
    }

    static long swap(long x) {
        return Long.reverseBytes(x);
    }

    static int pageSize() {
        if (PAGE_SIZE == -1) {
            PAGE_SIZE = UNSAFE.pageSize();
        }
        return PAGE_SIZE;
    }

    static long pageCount(long size) {
        return (size + (long)Bits.pageSize() - 1L) / (long)Bits.pageSize();
    }

    static boolean unaligned() {
        return UNALIGNED;
    }

    static void reserveMemory(long size, long cap) {
        if (!MEMORY_LIMIT_SET && VM.initLevel() >= 1) {
            MAX_MEMORY = VM.maxDirectMemory();
            MEMORY_LIMIT_SET = true;
        }
        if (Bits.tryReserveMemory(size, cap)) {
            return;
        }
        JavaLangRefAccess jlra = SharedSecrets.getJavaLangRefAccess();
        boolean interrupted = false;
        try {
            boolean refprocActive;
            do {
                try {
                    refprocActive = jlra.waitForReferenceProcessing();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    refprocActive = true;
                }
                if (!Bits.tryReserveMemory(size, cap)) continue;
                return;
            } while (refprocActive);
            System.gc();
            long sleepTime = 1L;
            int sleeps = 0;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static boolean tryReserveMemory(long size, long cap) {
        long totalCap;
        while (cap <= MAX_MEMORY - (totalCap = TOTAL_CAPACITY.get())) {
            if (!TOTAL_CAPACITY.compareAndSet(totalCap, totalCap + cap)) continue;
            RESERVED_MEMORY.addAndGet(size);
            COUNT.incrementAndGet();
            return true;
        }
        return false;
    }

    static void unreserveMemory(long size, long cap) {
        long cnt = COUNT.decrementAndGet();
        long reservedMem = RESERVED_MEMORY.addAndGet(-size);
        long totalCap = TOTAL_CAPACITY.addAndGet(-cap);
        assert (cnt >= 0L && reservedMem >= 0L && totalCap >= 0L);
    }

    static {
        BUFFER_POOL = new VM.BufferPool(){

            @Override
            public String getName() {
                return "direct";
            }

            @Override
            public long getCount() {
                return COUNT.get();
            }

            @Override
            public long getTotalCapacity() {
                return TOTAL_CAPACITY.get();
            }

            @Override
            public long getMemoryUsed() {
                return RESERVED_MEMORY.get();
            }
        };
    }
}

