/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.io.FileDescriptor;
import java.nio.Bits;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.DirectByteBuffer;
import java.nio.HeapByteBuffer;
import java.nio.InvalidMarkException;
import java.nio.MappedByteBuffer;
import java.nio.MappedMemoryUtils;
import jdk.internal.access.JavaNioAccess;
import jdk.internal.access.SharedSecrets;
import jdk.internal.access.foreign.MemorySegmentProxy;
import jdk.internal.access.foreign.UnmapperProxy;
import jdk.internal.misc.ScopedMemoryAccess;
import jdk.internal.misc.Unsafe;
import jdk.internal.misc.VM;
import jdk.internal.vm.annotation.ForceInline;
import jdk.internal.vm.annotation.IntrinsicCandidate;

public abstract class Buffer {
    static final Unsafe UNSAFE = Unsafe.getUnsafe();
    static final ScopedMemoryAccess SCOPED_MEMORY_ACCESS = ScopedMemoryAccess.getScopedMemoryAccess();
    static final int SPLITERATOR_CHARACTERISTICS = 16464;
    private int mark = -1;
    private int position = 0;
    private int limit;
    private int capacity;
    long address;
    final MemorySegmentProxy segment;

    Buffer(long addr, int cap, MemorySegmentProxy segment) {
        this.address = addr;
        this.capacity = cap;
        this.segment = segment;
    }

    Buffer(int mark, int pos, int lim, int cap, MemorySegmentProxy segment) {
        if (cap < 0) {
            throw Buffer.createCapacityException(cap);
        }
        this.capacity = cap;
        this.segment = segment;
        this.limit(lim);
        this.position(pos);
        if (mark >= 0) {
            if (mark > pos) {
                throw new IllegalArgumentException("mark > position: (" + mark + " > " + pos + ")");
            }
            this.mark = mark;
        }
    }

    static IllegalArgumentException createSameBufferException() {
        return new IllegalArgumentException("The source buffer is this buffer");
    }

    static IllegalArgumentException createCapacityException(int capacity) {
        assert (capacity < 0) : "capacity expected to be negative";
        return new IllegalArgumentException("capacity < 0: (" + capacity + " < 0)");
    }

    public final int capacity() {
        return this.capacity;
    }

    public final int position() {
        return this.position;
    }

    public Buffer position(int newPosition) {
        if (newPosition > this.limit | newPosition < 0) {
            throw this.createPositionException(newPosition);
        }
        if (this.mark > newPosition) {
            this.mark = -1;
        }
        this.position = newPosition;
        return this;
    }

    private IllegalArgumentException createPositionException(int newPosition) {
        String msg = null;
        if (newPosition > this.limit) {
            msg = "newPosition > limit: (" + newPosition + " > " + this.limit + ")";
        } else {
            assert (newPosition < 0) : "newPosition expected to be negative";
            msg = "newPosition < 0: (" + newPosition + " < 0)";
        }
        return new IllegalArgumentException(msg);
    }

    public final int limit() {
        return this.limit;
    }

    public Buffer limit(int newLimit) {
        if (newLimit > this.capacity | newLimit < 0) {
            throw this.createLimitException(newLimit);
        }
        this.limit = newLimit;
        if (this.position > newLimit) {
            this.position = newLimit;
        }
        if (this.mark > newLimit) {
            this.mark = -1;
        }
        return this;
    }

    private IllegalArgumentException createLimitException(int newLimit) {
        String msg = null;
        if (newLimit > this.capacity) {
            msg = "newLimit > capacity: (" + newLimit + " > " + this.capacity + ")";
        } else {
            assert (newLimit < 0) : "newLimit expected to be negative";
            msg = "newLimit < 0: (" + newLimit + " < 0)";
        }
        return new IllegalArgumentException(msg);
    }

    public Buffer mark() {
        this.mark = this.position;
        return this;
    }

    public Buffer reset() {
        int m = this.mark;
        if (m < 0) {
            throw new InvalidMarkException();
        }
        this.position = m;
        return this;
    }

    public Buffer clear() {
        this.position = 0;
        this.limit = this.capacity;
        this.mark = -1;
        return this;
    }

    public Buffer flip() {
        this.limit = this.position;
        this.position = 0;
        this.mark = -1;
        return this;
    }

    public Buffer rewind() {
        this.position = 0;
        this.mark = -1;
        return this;
    }

    public final int remaining() {
        int rem = this.limit - this.position;
        return rem > 0 ? rem : 0;
    }

    public final boolean hasRemaining() {
        return this.position < this.limit;
    }

    public abstract boolean isReadOnly();

    public abstract boolean hasArray();

    public abstract Object array();

    public abstract int arrayOffset();

    public abstract boolean isDirect();

    public abstract Buffer slice();

    public abstract Buffer slice(int var1, int var2);

    public abstract Buffer duplicate();

    abstract Object base();

    final int nextGetIndex() {
        int p = this.position;
        if (p >= this.limit) {
            throw new BufferUnderflowException();
        }
        this.position = p + 1;
        return p;
    }

    final int nextGetIndex(int nb) {
        int p = this.position;
        if (this.limit - p < nb) {
            throw new BufferUnderflowException();
        }
        this.position = p + nb;
        return p;
    }

    final int nextPutIndex() {
        int p = this.position;
        if (p >= this.limit) {
            throw new BufferOverflowException();
        }
        this.position = p + 1;
        return p;
    }

    final int nextPutIndex(int nb) {
        int p = this.position;
        if (this.limit - p < nb) {
            throw new BufferOverflowException();
        }
        this.position = p + nb;
        return p;
    }

    @IntrinsicCandidate
    final int checkIndex(int i) {
        if (i < 0 || i >= this.limit) {
            throw new IndexOutOfBoundsException();
        }
        return i;
    }

    final int checkIndex(int i, int nb) {
        if (i < 0 || nb > this.limit - i) {
            throw new IndexOutOfBoundsException();
        }
        return i;
    }

    final int markValue() {
        return this.mark;
    }

    final void discardMark() {
        this.mark = -1;
    }

    @ForceInline
    final ScopedMemoryAccess.Scope scope() {
        if (this.segment != null) {
            return this.segment.scope();
        }
        return null;
    }

    final void checkScope() {
        ScopedMemoryAccess.Scope scope = this.scope();
        if (scope != null) {
            scope.checkValidState();
        }
    }

    static {
        SharedSecrets.setJavaNioAccess(new JavaNioAccess(){

            @Override
            public VM.BufferPool getDirectBufferPool() {
                return Bits.BUFFER_POOL;
            }

            @Override
            public ByteBuffer newDirectByteBuffer(long addr, int cap, Object obj, MemorySegmentProxy segment) {
                return new DirectByteBuffer(addr, cap, obj, segment);
            }

            @Override
            public ByteBuffer newMappedByteBuffer(UnmapperProxy unmapperProxy, long address, int cap, Object obj, MemorySegmentProxy segment) {
                return new DirectByteBuffer(address, cap, obj, unmapperProxy.fileDescriptor(), unmapperProxy.isSync(), segment);
            }

            @Override
            public ByteBuffer newHeapByteBuffer(byte[] hb, int offset, int capacity, MemorySegmentProxy segment) {
                return new HeapByteBuffer(hb, -1, 0, capacity, capacity, offset, segment);
            }

            @Override
            public Object getBufferBase(ByteBuffer bb) {
                return bb.base();
            }

            @Override
            public long getBufferAddress(ByteBuffer bb) {
                return bb.address;
            }

            @Override
            public UnmapperProxy unmapper(ByteBuffer bb) {
                if (bb instanceof MappedByteBuffer) {
                    return ((MappedByteBuffer)bb).unmapper();
                }
                return null;
            }

            @Override
            public MemorySegmentProxy bufferSegment(Buffer buffer) {
                return buffer.segment;
            }

            @Override
            public ScopedMemoryAccess.Scope.Handle acquireScope(Buffer buffer, boolean async) {
                ScopedMemoryAccess.Scope scope = buffer.scope();
                if (scope == null) {
                    return null;
                }
                if (async && scope.ownerThread() != null) {
                    throw new IllegalStateException("Confined scope not supported");
                }
                return scope.acquire();
            }

            @Override
            public void force(FileDescriptor fd, long address, boolean isSync, long offset, long size) {
                MappedMemoryUtils.force(fd, address, isSync, offset, size);
            }

            @Override
            public void load(long address, boolean isSync, long size) {
                MappedMemoryUtils.load(address, isSync, size);
            }

            @Override
            public void unload(long address, boolean isSync, long size) {
                MappedMemoryUtils.unload(address, isSync, size);
            }

            @Override
            public boolean isLoaded(long address, boolean isSync, long size) {
                return MappedMemoryUtils.isLoaded(address, isSync, size);
            }

            @Override
            public void reserveMemory(long size, long cap) {
                Bits.reserveMemory(size, cap);
            }

            @Override
            public void unreserveMemory(long size, long cap) {
                Bits.unreserveMemory(size, cap);
            }

            @Override
            public int pageSize() {
                return Bits.pageSize();
            }
        });
    }
}

