/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.lang.ref.Reference;
import java.nio.Buffer;
import java.nio.BufferMismatch;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DirectByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.HeapByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ReadOnlyBufferException;
import java.nio.ShortBuffer;
import java.util.Objects;
import jdk.internal.access.foreign.MemorySegmentProxy;

public abstract class ByteBuffer
extends Buffer
implements Comparable<ByteBuffer> {
    private static final long ARRAY_BASE_OFFSET = UNSAFE.arrayBaseOffset(byte[].class);
    final byte[] hb;
    final int offset;
    boolean isReadOnly;
    boolean bigEndian = true;
    boolean nativeByteOrder = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;

    ByteBuffer(int mark, int pos, int lim, int cap, byte[] hb, int offset, MemorySegmentProxy segment) {
        super(mark, pos, lim, cap, segment);
        this.hb = hb;
        this.offset = offset;
    }

    ByteBuffer(int mark, int pos, int lim, int cap, MemorySegmentProxy segment) {
        this(mark, pos, lim, cap, null, 0, segment);
    }

    ByteBuffer(byte[] hb, long addr, int cap, MemorySegmentProxy segment) {
        super(addr, cap, segment);
        this.hb = hb;
        this.offset = 0;
    }

    @Override
    Object base() {
        return this.hb;
    }

    public static ByteBuffer allocateDirect(int capacity) {
        return new DirectByteBuffer(capacity);
    }

    public static ByteBuffer allocate(int capacity) {
        if (capacity < 0) {
            throw ByteBuffer.createCapacityException(capacity);
        }
        return new HeapByteBuffer(capacity, capacity, null);
    }

    public static ByteBuffer wrap(byte[] array, int offset, int length) {
        try {
            return new HeapByteBuffer(array, offset, length, null);
        }
        catch (IllegalArgumentException x) {
            throw new IndexOutOfBoundsException();
        }
    }

    public static ByteBuffer wrap(byte[] array) {
        return ByteBuffer.wrap(array, 0, array.length);
    }

    @Override
    public abstract ByteBuffer slice();

    @Override
    public abstract ByteBuffer slice(int var1, int var2);

    @Override
    public abstract ByteBuffer duplicate();

    public abstract ByteBuffer asReadOnlyBuffer();

    public abstract byte get();

    public abstract ByteBuffer put(byte var1);

    public abstract byte get(int var1);

    public abstract ByteBuffer put(int var1, byte var2);

    public ByteBuffer get(byte[] dst, int offset, int length) {
        Objects.checkFromIndexSize(offset, length, dst.length);
        int pos = this.position();
        if (length > this.limit() - pos) {
            throw new BufferUnderflowException();
        }
        this.getArray(pos, dst, offset, length);
        this.position(pos + length);
        return this;
    }

    public ByteBuffer get(byte[] dst) {
        return this.get(dst, 0, dst.length);
    }

    public ByteBuffer get(int index, byte[] dst, int offset, int length) {
        Objects.checkFromIndexSize(index, length, this.limit());
        Objects.checkFromIndexSize(offset, length, dst.length);
        this.getArray(index, dst, offset, length);
        return this;
    }

    public ByteBuffer get(int index, byte[] dst) {
        return this.get(index, dst, 0, dst.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuffer getArray(int index, byte[] dst, int offset, int length) {
        if ((long)length << 0 > 6L) {
            long bufAddr = this.address + ((long)index << 0);
            long dstOffset = ARRAY_BASE_OFFSET + ((long)offset << 0);
            long len = (long)length << 0;
            try {
                SCOPED_MEMORY_ACCESS.copyMemory(this.scope(), null, this.base(), bufAddr, dst, dstOffset, len);
            }
            finally {
                Reference.reachabilityFence(this);
            }
        } else {
            int end = offset + length;
            int i = offset;
            int j = index;
            while (i < end) {
                dst[i] = this.get(j);
                ++i;
                ++j;
            }
        }
        return this;
    }

    public ByteBuffer put(ByteBuffer src) {
        int rem;
        int srcLim;
        if (src == this) {
            throw ByteBuffer.createSameBufferException();
        }
        if (this.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        int srcPos = src.position();
        int srcRem = srcPos <= (srcLim = src.limit()) ? srcLim - srcPos : 0;
        int pos = this.position();
        int lim = this.limit();
        int n = rem = pos <= lim ? lim - pos : 0;
        if (srcRem > rem) {
            throw new BufferOverflowException();
        }
        this.putBuffer(pos, src, srcPos, srcRem);
        this.position(pos + srcRem);
        src.position(srcPos + srcRem);
        return this;
    }

    public ByteBuffer put(int index, ByteBuffer src, int offset, int length) {
        Objects.checkFromIndexSize(index, length, this.limit());
        Objects.checkFromIndexSize(offset, length, src.limit());
        if (this.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        this.putBuffer(index, src, offset, length);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putBuffer(int pos, ByteBuffer src, int srcPos, int n) {
        Object srcBase = src.base();
        assert (srcBase != null || src.isDirect());
        Object base = this.base();
        assert (base != null || this.isDirect());
        long srcAddr = src.address + ((long)srcPos << 0);
        long addr = this.address + ((long)pos << 0);
        long len = (long)n << 0;
        try {
            SCOPED_MEMORY_ACCESS.copyMemory(src.scope(), this.scope(), srcBase, srcAddr, base, addr, len);
        }
        finally {
            Reference.reachabilityFence(src);
            Reference.reachabilityFence(this);
        }
    }

    public ByteBuffer put(byte[] src, int offset, int length) {
        if (this.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        Objects.checkFromIndexSize(offset, length, src.length);
        int pos = this.position();
        if (length > this.limit() - pos) {
            throw new BufferOverflowException();
        }
        this.putArray(pos, src, offset, length);
        this.position(pos + length);
        return this;
    }

    public final ByteBuffer put(byte[] src) {
        return this.put(src, 0, src.length);
    }

    public ByteBuffer put(int index, byte[] src, int offset, int length) {
        if (this.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        Objects.checkFromIndexSize(index, length, this.limit());
        Objects.checkFromIndexSize(offset, length, src.length);
        this.putArray(index, src, offset, length);
        return this;
    }

    public ByteBuffer put(int index, byte[] src) {
        return this.put(index, src, 0, src.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuffer putArray(int index, byte[] src, int offset, int length) {
        if ((long)length << 0 > 6L) {
            long bufAddr = this.address + ((long)index << 0);
            long srcOffset = ARRAY_BASE_OFFSET + ((long)offset << 0);
            long len = (long)length << 0;
            try {
                SCOPED_MEMORY_ACCESS.copyMemory(null, this.scope(), src, srcOffset, this.base(), bufAddr, len);
            }
            finally {
                Reference.reachabilityFence(this);
            }
        } else {
            int end = offset + length;
            int i = offset;
            int j = index;
            while (i < end) {
                this.put(j, src[i]);
                ++i;
                ++j;
            }
        }
        return this;
    }

    @Override
    public final boolean hasArray() {
        return this.hb != null && !this.isReadOnly;
    }

    public final byte[] array() {
        if (this.hb == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        return this.hb;
    }

    @Override
    public final int arrayOffset() {
        if (this.hb == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        return this.offset;
    }

    @Override
    public ByteBuffer position(int newPosition) {
        super.position(newPosition);
        return this;
    }

    @Override
    public ByteBuffer limit(int newLimit) {
        super.limit(newLimit);
        return this;
    }

    @Override
    public ByteBuffer mark() {
        super.mark();
        return this;
    }

    @Override
    public ByteBuffer reset() {
        super.reset();
        return this;
    }

    @Override
    public ByteBuffer clear() {
        super.clear();
        return this;
    }

    @Override
    public ByteBuffer flip() {
        super.flip();
        return this;
    }

    @Override
    public ByteBuffer rewind() {
        super.rewind();
        return this;
    }

    public abstract ByteBuffer compact();

    @Override
    public abstract boolean isDirect();

    public String toString() {
        return this.getClass().getName() + "[pos=" + this.position() + " lim=" + this.limit() + " cap=" + this.capacity() + "]";
    }

    public int hashCode() {
        int h = 1;
        int p = this.position();
        for (int i = this.limit() - 1; i >= p; --i) {
            h = 31 * h + this.get(i);
        }
        return h;
    }

    public boolean equals(Object ob) {
        if (this == ob) {
            return true;
        }
        if (!(ob instanceof ByteBuffer)) {
            return false;
        }
        ByteBuffer that = (ByteBuffer)ob;
        int thisPos = this.position();
        int thisRem = this.limit() - thisPos;
        int thatPos = that.position();
        int thatRem = that.limit() - thatPos;
        if (thisRem < 0 || thisRem != thatRem) {
            return false;
        }
        return BufferMismatch.mismatch(this, thisPos, that, thatPos, thisRem) < 0;
    }

    @Override
    public int compareTo(ByteBuffer that) {
        int thisPos = this.position();
        int thisRem = this.limit() - thisPos;
        int thatPos = that.position();
        int thatRem = that.limit() - thatPos;
        int length = Math.min(thisRem, thatRem);
        if (length < 0) {
            return -1;
        }
        int i = BufferMismatch.mismatch(this, thisPos, that, thatPos, length);
        if (i >= 0) {
            return ByteBuffer.compare(this.get(thisPos + i), that.get(thatPos + i));
        }
        return thisRem - thatRem;
    }

    private static int compare(byte x, byte y) {
        return Byte.compare(x, y);
    }

    public int mismatch(ByteBuffer that) {
        int thisPos = this.position();
        int thisRem = this.limit() - thisPos;
        int thatPos = that.position();
        int thatRem = that.limit() - thatPos;
        int length = Math.min(thisRem, thatRem);
        if (length < 0) {
            return -1;
        }
        int r = BufferMismatch.mismatch(this, thisPos, that, thatPos, length);
        return r == -1 && thisRem != thatRem ? length : r;
    }

    public final ByteOrder order() {
        return this.bigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
    }

    public final ByteBuffer order(ByteOrder bo) {
        this.bigEndian = bo == ByteOrder.BIG_ENDIAN;
        this.nativeByteOrder = this.bigEndian == (ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN);
        return this;
    }

    public final int alignmentOffset(int index, int unitSize) {
        if (index < 0) {
            throw new IllegalArgumentException("Index less than zero: " + index);
        }
        if (unitSize < 1 || (unitSize & unitSize - 1) != 0) {
            throw new IllegalArgumentException("Unit size not a power of two: " + unitSize);
        }
        if (unitSize > 8 && !this.isDirect()) {
            throw new UnsupportedOperationException("Unit size unsupported for non-direct buffers: " + unitSize);
        }
        return (int)(this.address + (long)index & (long)(unitSize - 1));
    }

    public final ByteBuffer alignedSlice(int unitSize) {
        int pos = this.position();
        int lim = this.limit();
        int pos_mod = this.alignmentOffset(pos, unitSize);
        int lim_mod = this.alignmentOffset(lim, unitSize);
        int aligned_pos = pos_mod > 0 ? pos + (unitSize - pos_mod) : pos;
        int aligned_lim = lim - lim_mod;
        if (aligned_pos > lim || aligned_lim < pos) {
            aligned_pos = aligned_lim = pos;
        }
        return this.slice(aligned_pos, aligned_lim - aligned_pos);
    }

    public abstract char getChar();

    public abstract ByteBuffer putChar(char var1);

    public abstract char getChar(int var1);

    public abstract ByteBuffer putChar(int var1, char var2);

    public abstract CharBuffer asCharBuffer();

    public abstract short getShort();

    public abstract ByteBuffer putShort(short var1);

    public abstract short getShort(int var1);

    public abstract ByteBuffer putShort(int var1, short var2);

    public abstract ShortBuffer asShortBuffer();

    public abstract int getInt();

    public abstract ByteBuffer putInt(int var1);

    public abstract int getInt(int var1);

    public abstract ByteBuffer putInt(int var1, int var2);

    public abstract IntBuffer asIntBuffer();

    public abstract long getLong();

    public abstract ByteBuffer putLong(long var1);

    public abstract long getLong(int var1);

    public abstract ByteBuffer putLong(int var1, long var2);

    public abstract LongBuffer asLongBuffer();

    public abstract float getFloat();

    public abstract ByteBuffer putFloat(float var1);

    public abstract float getFloat(int var1);

    public abstract ByteBuffer putFloat(int var1, float var2);

    public abstract FloatBuffer asFloatBuffer();

    public abstract double getDouble();

    public abstract ByteBuffer putDouble(double var1);

    public abstract double getDouble(int var1);

    public abstract ByteBuffer putDouble(int var1, double var2);

    public abstract DoubleBuffer asDoubleBuffer();
}

