/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteBuffer;
import java.nio.ByteBufferAsCharBufferB;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.ReadOnlyBufferException;
import java.util.Objects;
import jdk.internal.access.foreign.MemorySegmentProxy;

class ByteBufferAsCharBufferRB
extends ByteBufferAsCharBufferB {
    ByteBufferAsCharBufferRB(ByteBuffer bb, MemorySegmentProxy segment) {
        super(bb, segment);
    }

    ByteBufferAsCharBufferRB(ByteBuffer bb, int mark, int pos, int lim, int cap, long addr, MemorySegmentProxy segment) {
        super(bb, mark, pos, lim, cap, addr, segment);
    }

    @Override
    Object base() {
        return this.bb.hb;
    }

    @Override
    public CharBuffer slice() {
        int lim;
        int pos = this.position();
        int rem = pos <= (lim = this.limit()) ? lim - pos : 0;
        long addr = this.byteOffset(pos);
        return new ByteBufferAsCharBufferRB(this.bb, -1, 0, rem, rem, addr, this.segment);
    }

    @Override
    public CharBuffer slice(int index, int length) {
        Objects.checkFromIndexSize(index, length, this.limit());
        return new ByteBufferAsCharBufferRB(this.bb, -1, 0, length, length, this.byteOffset(index), this.segment);
    }

    @Override
    public CharBuffer duplicate() {
        return new ByteBufferAsCharBufferRB(this.bb, this.markValue(), this.position(), this.limit(), this.capacity(), this.address, this.segment);
    }

    @Override
    public CharBuffer asReadOnlyBuffer() {
        return this.duplicate();
    }

    @Override
    public CharBuffer put(char x) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public CharBuffer put(int i, char x) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public CharBuffer compact() {
        throw new ReadOnlyBufferException();
    }

    @Override
    public boolean isDirect() {
        return this.bb.isDirect();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public String toString(int start, int end) {
        Objects.checkFromToIndex(start, end, this.limit());
        try {
            int len = end - start;
            char[] ca = new char[len];
            CharBuffer cb = CharBuffer.wrap(ca);
            CharBuffer db = this.duplicate();
            db.position(start);
            db.limit(end);
            cb.put(db);
            return new String(ca);
        }
        catch (StringIndexOutOfBoundsException x) {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public CharBuffer subSequence(int start, int end) {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        pos = pos <= lim ? pos : lim;
        int len = lim - pos;
        Objects.checkFromToIndex(start, end, len);
        return new ByteBufferAsCharBufferRB(this.bb, -1, pos + start, pos + end, this.capacity(), this.address, this.segment);
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.BIG_ENDIAN;
    }

    @Override
    ByteOrder charRegionOrder() {
        return this.order();
    }
}

