/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteBuffer;
import java.nio.ByteBufferAsLongBufferRB;
import java.nio.ByteOrder;
import java.nio.LongBuffer;
import java.util.Objects;
import jdk.internal.access.foreign.MemorySegmentProxy;

class ByteBufferAsLongBufferB
extends LongBuffer {
    protected final ByteBuffer bb;

    ByteBufferAsLongBufferB(ByteBuffer bb, MemorySegmentProxy segment) {
        super(-1, 0, bb.remaining() >> 3, bb.remaining() >> 3, segment);
        this.bb = bb;
        int cap = this.capacity();
        this.limit(cap);
        int pos = this.position();
        assert (pos <= cap);
        this.address = bb.address;
    }

    ByteBufferAsLongBufferB(ByteBuffer bb, int mark, int pos, int lim, int cap, long addr, MemorySegmentProxy segment) {
        super(mark, pos, lim, cap, segment);
        this.bb = bb;
        this.address = addr;
        assert (this.address >= bb.address);
    }

    @Override
    Object base() {
        return this.bb.hb;
    }

    @Override
    public LongBuffer slice() {
        int lim;
        int pos = this.position();
        int rem = pos <= (lim = this.limit()) ? lim - pos : 0;
        long addr = this.byteOffset(pos);
        return new ByteBufferAsLongBufferB(this.bb, -1, 0, rem, rem, addr, this.segment);
    }

    @Override
    public LongBuffer slice(int index, int length) {
        Objects.checkFromIndexSize(index, length, this.limit());
        return new ByteBufferAsLongBufferB(this.bb, -1, 0, length, length, this.byteOffset(index), this.segment);
    }

    @Override
    public LongBuffer duplicate() {
        return new ByteBufferAsLongBufferB(this.bb, this.markValue(), this.position(), this.limit(), this.capacity(), this.address, this.segment);
    }

    @Override
    public LongBuffer asReadOnlyBuffer() {
        return new ByteBufferAsLongBufferRB(this.bb, this.markValue(), this.position(), this.limit(), this.capacity(), this.address, this.segment);
    }

    private int ix(int i) {
        int off = (int)(this.address - this.bb.address);
        return (i << 3) + off;
    }

    protected long byteOffset(long i) {
        return (i << 3) + this.address;
    }

    @Override
    public long get() {
        long x = SCOPED_MEMORY_ACCESS.getLongUnaligned(this.scope(), this.bb.hb, this.byteOffset(this.nextGetIndex()), true);
        return x;
    }

    @Override
    public long get(int i) {
        long x = SCOPED_MEMORY_ACCESS.getLongUnaligned(this.scope(), this.bb.hb, this.byteOffset(this.checkIndex(i)), true);
        return x;
    }

    @Override
    public LongBuffer put(long x) {
        long y = x;
        SCOPED_MEMORY_ACCESS.putLongUnaligned(this.scope(), this.bb.hb, this.byteOffset(this.nextPutIndex()), y, true);
        return this;
    }

    @Override
    public LongBuffer put(int i, long x) {
        long y = x;
        SCOPED_MEMORY_ACCESS.putLongUnaligned(this.scope(), this.bb.hb, this.byteOffset(this.checkIndex(i)), y, true);
        return this;
    }

    @Override
    public LongBuffer compact() {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        ByteBuffer db = this.bb.duplicate();
        db.limit(this.ix(lim));
        db.position(this.ix(0));
        ByteBuffer sb = db.slice();
        sb.position(pos << 3);
        sb.compact();
        this.position(rem);
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    @Override
    public boolean isDirect() {
        return this.bb.isDirect();
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.BIG_ENDIAN;
    }
}

