/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.io.IOException;
import java.lang.ref.Reference;
import java.nio.Buffer;
import java.nio.BufferMismatch;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.CharBufferSpliterator;
import java.nio.HeapCharBuffer;
import java.nio.ReadOnlyBufferException;
import java.nio.StringCharBuffer;
import java.util.Objects;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import jdk.internal.access.foreign.MemorySegmentProxy;

public abstract class CharBuffer
extends Buffer
implements Comparable<CharBuffer>,
Appendable,
CharSequence,
Readable {
    private static final long ARRAY_BASE_OFFSET = UNSAFE.arrayBaseOffset(char[].class);
    final char[] hb;
    final int offset;
    boolean isReadOnly;

    CharBuffer(int mark, int pos, int lim, int cap, char[] hb, int offset, MemorySegmentProxy segment) {
        super(mark, pos, lim, cap, segment);
        this.hb = hb;
        this.offset = offset;
    }

    CharBuffer(int mark, int pos, int lim, int cap, MemorySegmentProxy segment) {
        this(mark, pos, lim, cap, null, 0, segment);
    }

    CharBuffer(char[] hb, long addr, int cap, MemorySegmentProxy segment) {
        super(addr, cap, segment);
        this.hb = hb;
        this.offset = 0;
    }

    @Override
    Object base() {
        return this.hb;
    }

    public static CharBuffer allocate(int capacity) {
        if (capacity < 0) {
            throw CharBuffer.createCapacityException(capacity);
        }
        return new HeapCharBuffer(capacity, capacity, null);
    }

    public static CharBuffer wrap(char[] array, int offset, int length) {
        try {
            return new HeapCharBuffer(array, offset, length, null);
        }
        catch (IllegalArgumentException x) {
            throw new IndexOutOfBoundsException();
        }
    }

    public static CharBuffer wrap(char[] array) {
        return CharBuffer.wrap(array, 0, array.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(CharBuffer target) throws IOException {
        int limit = this.limit();
        int pos = this.position();
        int remaining = limit - pos;
        assert (remaining >= 0);
        if (remaining <= 0) {
            return -1;
        }
        int targetRemaining = target.remaining();
        assert (targetRemaining >= 0);
        if (targetRemaining <= 0) {
            return 0;
        }
        int n = Math.min(remaining, targetRemaining);
        if (targetRemaining < remaining) {
            this.limit(pos + n);
        }
        try {
            if (n > 0) {
                target.put(this);
            }
        }
        finally {
            this.limit(limit);
        }
        return n;
    }

    public static CharBuffer wrap(CharSequence csq, int start, int end) {
        try {
            return new StringCharBuffer(csq, start, end);
        }
        catch (IllegalArgumentException x) {
            throw new IndexOutOfBoundsException();
        }
    }

    public static CharBuffer wrap(CharSequence csq) {
        return CharBuffer.wrap(csq, 0, csq.length());
    }

    @Override
    public abstract CharBuffer slice();

    @Override
    public abstract CharBuffer slice(int var1, int var2);

    @Override
    public abstract CharBuffer duplicate();

    public abstract CharBuffer asReadOnlyBuffer();

    public abstract char get();

    public abstract CharBuffer put(char var1);

    public abstract char get(int var1);

    abstract char getUnchecked(int var1);

    public abstract CharBuffer put(int var1, char var2);

    public CharBuffer get(char[] dst, int offset, int length) {
        Objects.checkFromIndexSize(offset, length, dst.length);
        int pos = this.position();
        if (length > this.limit() - pos) {
            throw new BufferUnderflowException();
        }
        this.getArray(pos, dst, offset, length);
        this.position(pos + length);
        return this;
    }

    public CharBuffer get(char[] dst) {
        return this.get(dst, 0, dst.length);
    }

    public CharBuffer get(int index, char[] dst, int offset, int length) {
        Objects.checkFromIndexSize(index, length, this.limit());
        Objects.checkFromIndexSize(offset, length, dst.length);
        this.getArray(index, dst, offset, length);
        return this;
    }

    public CharBuffer get(int index, char[] dst) {
        return this.get(index, dst, 0, dst.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CharBuffer getArray(int index, char[] dst, int offset, int length) {
        if (this.isAddressable() && (long)length << 0 > 6L) {
            long bufAddr = this.address + ((long)index << 0);
            long dstOffset = ARRAY_BASE_OFFSET + ((long)offset << 0);
            long len = (long)length << 0;
            try {
                if (this.order() != ByteOrder.nativeOrder()) {
                    SCOPED_MEMORY_ACCESS.copySwapMemory(this.scope(), null, this.base(), bufAddr, dst, dstOffset, len, 2L);
                }
                SCOPED_MEMORY_ACCESS.copyMemory(this.scope(), null, this.base(), bufAddr, dst, dstOffset, len);
            }
            finally {
                Reference.reachabilityFence(this);
            }
        } else {
            int end = offset + length;
            int i = offset;
            int j = index;
            while (i < end) {
                dst[i] = this.get(j);
                ++i;
                ++j;
            }
        }
        return this;
    }

    public CharBuffer put(CharBuffer src) {
        int rem;
        int srcLim;
        if (src == this) {
            throw CharBuffer.createSameBufferException();
        }
        if (this.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        int srcPos = src.position();
        int srcRem = srcPos <= (srcLim = src.limit()) ? srcLim - srcPos : 0;
        int pos = this.position();
        int lim = this.limit();
        int n = rem = pos <= lim ? lim - pos : 0;
        if (srcRem > rem) {
            throw new BufferOverflowException();
        }
        this.putBuffer(pos, src, srcPos, srcRem);
        this.position(pos + srcRem);
        src.position(srcPos + srcRem);
        return this;
    }

    public CharBuffer put(int index, CharBuffer src, int offset, int length) {
        Objects.checkFromIndexSize(index, length, this.limit());
        Objects.checkFromIndexSize(offset, length, src.limit());
        if (this.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        this.putBuffer(index, src, offset, length);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putBuffer(int pos, CharBuffer src, int srcPos, int n) {
        Object srcBase = src.base();
        if (src.isAddressable()) {
            Object base = this.base();
            assert (base != null || this.isDirect());
            long srcAddr = src.address + ((long)srcPos << 0);
            long addr = this.address + ((long)pos << 0);
            long len = (long)n << 0;
            try {
                if (this.order() != src.order()) {
                    SCOPED_MEMORY_ACCESS.copySwapMemory(src.scope(), this.scope(), srcBase, srcAddr, base, addr, len, 2L);
                }
                SCOPED_MEMORY_ACCESS.copyMemory(src.scope(), this.scope(), srcBase, srcAddr, base, addr, len);
            }
            finally {
                Reference.reachabilityFence(src);
                Reference.reachabilityFence(this);
            }
        } else {
            assert (StringCharBuffer.class.isInstance(src));
            int posMax = pos + n;
            int i = pos;
            int j = srcPos;
            while (i < posMax) {
                this.put(i, src.get(j));
                ++i;
                ++j;
            }
        }
    }

    public CharBuffer put(char[] src, int offset, int length) {
        if (this.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        Objects.checkFromIndexSize(offset, length, src.length);
        int pos = this.position();
        if (length > this.limit() - pos) {
            throw new BufferOverflowException();
        }
        this.putArray(pos, src, offset, length);
        this.position(pos + length);
        return this;
    }

    public final CharBuffer put(char[] src) {
        return this.put(src, 0, src.length);
    }

    public CharBuffer put(int index, char[] src, int offset, int length) {
        if (this.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        Objects.checkFromIndexSize(index, length, this.limit());
        Objects.checkFromIndexSize(offset, length, src.length);
        this.putArray(index, src, offset, length);
        return this;
    }

    public CharBuffer put(int index, char[] src) {
        return this.put(index, src, 0, src.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CharBuffer putArray(int index, char[] src, int offset, int length) {
        if (this.isAddressable() && (long)length << 0 > 6L) {
            long bufAddr = this.address + ((long)index << 0);
            long srcOffset = ARRAY_BASE_OFFSET + ((long)offset << 0);
            long len = (long)length << 0;
            try {
                if (this.order() != ByteOrder.nativeOrder()) {
                    SCOPED_MEMORY_ACCESS.copySwapMemory(null, this.scope(), src, srcOffset, this.base(), bufAddr, len, 2L);
                }
                SCOPED_MEMORY_ACCESS.copyMemory(null, this.scope(), src, srcOffset, this.base(), bufAddr, len);
            }
            finally {
                Reference.reachabilityFence(this);
            }
        } else {
            int end = offset + length;
            int i = offset;
            int j = index;
            while (i < end) {
                this.put(j, src[i]);
                ++i;
                ++j;
            }
        }
        return this;
    }

    public CharBuffer put(String src, int start, int end) {
        Objects.checkFromIndexSize(start, end - start, src.length());
        if (this.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        if (end - start > this.remaining()) {
            throw new BufferOverflowException();
        }
        for (int i = start; i < end; ++i) {
            this.put(src.charAt(i));
        }
        return this;
    }

    public final CharBuffer put(String src) {
        return this.put(src, 0, src.length());
    }

    @Override
    public final boolean hasArray() {
        return this.hb != null && !this.isReadOnly;
    }

    public final char[] array() {
        if (this.hb == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        return this.hb;
    }

    @Override
    public final int arrayOffset() {
        if (this.hb == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        return this.offset;
    }

    @Override
    public final CharBuffer position(int newPosition) {
        super.position(newPosition);
        return this;
    }

    @Override
    public final CharBuffer limit(int newLimit) {
        super.limit(newLimit);
        return this;
    }

    @Override
    public final CharBuffer mark() {
        super.mark();
        return this;
    }

    @Override
    public final CharBuffer reset() {
        super.reset();
        return this;
    }

    @Override
    public final CharBuffer clear() {
        super.clear();
        return this;
    }

    @Override
    public final CharBuffer flip() {
        super.flip();
        return this;
    }

    @Override
    public final CharBuffer rewind() {
        super.rewind();
        return this;
    }

    public abstract CharBuffer compact();

    @Override
    public abstract boolean isDirect();

    boolean isAddressable() {
        return true;
    }

    public int hashCode() {
        int h = 1;
        int p = this.position();
        for (int i = this.limit() - 1; i >= p; --i) {
            h = 31 * h + this.get(i);
        }
        return h;
    }

    public boolean equals(Object ob) {
        if (this == ob) {
            return true;
        }
        if (!(ob instanceof CharBuffer)) {
            return false;
        }
        CharBuffer that = (CharBuffer)ob;
        int thisPos = this.position();
        int thisRem = this.limit() - thisPos;
        int thatPos = that.position();
        int thatRem = that.limit() - thatPos;
        if (thisRem < 0 || thisRem != thatRem) {
            return false;
        }
        return BufferMismatch.mismatch(this, thisPos, that, thatPos, thisRem) < 0;
    }

    @Override
    public int compareTo(CharBuffer that) {
        int thisPos = this.position();
        int thisRem = this.limit() - thisPos;
        int thatPos = that.position();
        int thatRem = that.limit() - thatPos;
        int length = Math.min(thisRem, thatRem);
        if (length < 0) {
            return -1;
        }
        int i = BufferMismatch.mismatch(this, thisPos, that, thatPos, length);
        if (i >= 0) {
            return CharBuffer.compare(this.get(thisPos + i), that.get(thatPos + i));
        }
        return thisRem - thatRem;
    }

    private static int compare(char x, char y) {
        return Character.compare(x, y);
    }

    public int mismatch(CharBuffer that) {
        int thisPos = this.position();
        int thisRem = this.limit() - thisPos;
        int thatPos = that.position();
        int thatRem = that.limit() - thatPos;
        int length = Math.min(thisRem, thatRem);
        if (length < 0) {
            return -1;
        }
        int r = BufferMismatch.mismatch(this, thisPos, that, thatPos, length);
        return r == -1 && thisRem != thatRem ? length : r;
    }

    @Override
    public String toString() {
        return this.toString(this.position(), this.limit());
    }

    abstract String toString(int var1, int var2);

    @Override
    public final int length() {
        return this.remaining();
    }

    @Override
    public final boolean isEmpty() {
        return this.remaining() == 0;
    }

    @Override
    public final char charAt(int index) {
        return this.get(this.position() + this.checkIndex(index, 1));
    }

    @Override
    public abstract CharBuffer subSequence(int var1, int var2);

    @Override
    public CharBuffer append(CharSequence csq) {
        if (csq == null) {
            return this.put("null");
        }
        return this.put(csq.toString());
    }

    @Override
    public CharBuffer append(CharSequence csq, int start, int end) {
        CharSequence cs = csq == null ? "null" : csq;
        return this.put(cs.subSequence(start, end).toString());
    }

    @Override
    public CharBuffer append(char c) {
        return this.put(c);
    }

    public abstract ByteOrder order();

    abstract ByteOrder charRegionOrder();

    @Override
    public IntStream chars() {
        return StreamSupport.intStream(() -> new CharBufferSpliterator(this), 16464, false);
    }
}

