/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.io.FileDescriptor;
import java.lang.ref.Reference;
import java.nio.Bits;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteBufferAsCharBufferB;
import java.nio.ByteBufferAsCharBufferL;
import java.nio.ByteBufferAsDoubleBufferB;
import java.nio.ByteBufferAsDoubleBufferL;
import java.nio.ByteBufferAsFloatBufferB;
import java.nio.ByteBufferAsFloatBufferL;
import java.nio.ByteBufferAsIntBufferB;
import java.nio.ByteBufferAsIntBufferL;
import java.nio.ByteBufferAsLongBufferB;
import java.nio.ByteBufferAsLongBufferL;
import java.nio.ByteBufferAsShortBufferB;
import java.nio.ByteBufferAsShortBufferL;
import java.nio.CharBuffer;
import java.nio.DirectByteBufferR;
import java.nio.DirectCharBufferS;
import java.nio.DirectCharBufferU;
import java.nio.DirectDoubleBufferS;
import java.nio.DirectDoubleBufferU;
import java.nio.DirectFloatBufferS;
import java.nio.DirectFloatBufferU;
import java.nio.DirectIntBufferS;
import java.nio.DirectIntBufferU;
import java.nio.DirectLongBufferS;
import java.nio.DirectLongBufferU;
import java.nio.DirectShortBufferS;
import java.nio.DirectShortBufferU;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.MappedByteBuffer;
import java.nio.ShortBuffer;
import java.util.Objects;
import jdk.internal.access.foreign.MemorySegmentProxy;
import jdk.internal.misc.ScopedMemoryAccess;
import jdk.internal.misc.VM;
import jdk.internal.ref.Cleaner;
import sun.nio.ch.DirectBuffer;

class DirectByteBuffer
extends MappedByteBuffer
implements DirectBuffer {
    private static final long ARRAY_BASE_OFFSET = UNSAFE.arrayBaseOffset(byte[].class);
    protected static final boolean UNALIGNED = Bits.unaligned();
    private final Object att;
    private final Cleaner cleaner;

    @Override
    public Object attachment() {
        return this.att;
    }

    @Override
    public Cleaner cleaner() {
        return this.cleaner;
    }

    DirectByteBuffer(int cap) {
        super(-1, 0, cap, cap, null);
        boolean pa = VM.isDirectMemoryPageAligned();
        int ps = Bits.pageSize();
        long size = Math.max(1L, (long)cap + (long)(pa ? ps : 0));
        Bits.reserveMemory(size, cap);
        long base = 0L;
        try {
            base = UNSAFE.allocateMemory(size);
        }
        catch (OutOfMemoryError x) {
            Bits.unreserveMemory(size, cap);
            throw x;
        }
        UNSAFE.setMemory(base, size, (byte)0);
        this.address = pa && base % (long)ps != 0L ? base + (long)ps - (base & (long)(ps - 1)) : base;
        this.cleaner = Cleaner.create(this, new Deallocator(base, size, cap));
        this.att = null;
    }

    DirectByteBuffer(long addr, int cap, Object ob, MemorySegmentProxy segment) {
        super(-1, 0, cap, cap, segment);
        this.address = addr;
        this.cleaner = null;
        this.att = ob;
    }

    DirectByteBuffer(long addr, int cap, Object ob, FileDescriptor fd, boolean isSync, MemorySegmentProxy segment) {
        super(-1, 0, cap, cap, fd, isSync, segment);
        this.address = addr;
        this.cleaner = null;
        this.att = ob;
    }

    private DirectByteBuffer(long addr, int cap) {
        super(-1, 0, cap, cap, null);
        this.address = addr;
        this.cleaner = null;
        this.att = null;
    }

    protected DirectByteBuffer(int cap, long addr, FileDescriptor fd, Runnable unmapper, boolean isSync, MemorySegmentProxy segment) {
        super(-1, 0, cap, cap, fd, isSync, segment);
        this.address = addr;
        this.cleaner = Cleaner.create(this, unmapper);
        this.att = null;
    }

    DirectByteBuffer(DirectBuffer db, int mark, int pos, int lim, int cap, int off, FileDescriptor fd, boolean isSync, MemorySegmentProxy segment) {
        super(mark, pos, lim, cap, fd, isSync, segment);
        this.address = ((Buffer)((Object)db)).address + (long)off;
        this.cleaner = null;
        Object attachment = db.attachment();
        this.att = attachment == null ? db : attachment;
    }

    @Override
    Object base() {
        return null;
    }

    @Override
    public MappedByteBuffer slice() {
        int lim;
        int pos = this.position();
        int rem = pos <= (lim = this.limit()) ? lim - pos : 0;
        int off = pos << 0;
        assert (off >= 0);
        return new DirectByteBuffer(this, -1, 0, rem, rem, off, this.fileDescriptor(), this.isSync(), this.segment);
    }

    @Override
    public MappedByteBuffer slice(int index, int length) {
        Objects.checkFromIndexSize(index, length, this.limit());
        return new DirectByteBuffer(this, -1, 0, length, length, index << 0, this.fileDescriptor(), this.isSync(), this.segment);
    }

    @Override
    public MappedByteBuffer duplicate() {
        return new DirectByteBuffer(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0, this.fileDescriptor(), this.isSync(), this.segment);
    }

    @Override
    public ByteBuffer asReadOnlyBuffer() {
        return new DirectByteBufferR(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0, this.fileDescriptor(), this.isSync(), this.segment);
    }

    @Override
    public long address() {
        ScopedMemoryAccess.Scope scope = this.scope();
        if (scope != null) {
            if (scope.ownerThread() == null) {
                throw new UnsupportedOperationException("ByteBuffer derived from shared segments not supported");
            }
            try {
                scope.checkValidState();
            }
            catch (ScopedMemoryAccess.Scope.ScopedAccessError e) {
                throw new IllegalStateException("This segment is already closed");
            }
        }
        return this.address;
    }

    private long ix(int i) {
        return this.address + ((long)i << 0);
    }

    @Override
    public byte get() {
        try {
            byte by = SCOPED_MEMORY_ACCESS.getByte(this.scope(), null, this.ix(this.nextGetIndex()));
            return by;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    @Override
    public byte get(int i) {
        try {
            byte by = SCOPED_MEMORY_ACCESS.getByte(this.scope(), null, this.ix(this.checkIndex(i)));
            return by;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    @Override
    public ByteBuffer put(byte x) {
        try {
            SCOPED_MEMORY_ACCESS.putByte(this.scope(), null, this.ix(this.nextPutIndex()), x);
        }
        finally {
            Reference.reachabilityFence(this);
        }
        return this;
    }

    @Override
    public ByteBuffer put(int i, byte x) {
        try {
            SCOPED_MEMORY_ACCESS.putByte(this.scope(), null, this.ix(this.checkIndex(i)), x);
        }
        finally {
            Reference.reachabilityFence(this);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MappedByteBuffer compact() {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        try {
            SCOPED_MEMORY_ACCESS.copyMemory(this.scope(), null, null, this.ix(pos), null, this.ix(0), (long)rem << 0);
        }
        finally {
            Reference.reachabilityFence(this);
        }
        this.position(rem);
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private char getChar(long a) {
        try {
            char x;
            char c = x = SCOPED_MEMORY_ACCESS.getCharUnaligned(this.scope(), null, a, this.bigEndian);
            return c;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    @Override
    public char getChar() {
        try {
            char c = this.getChar(this.ix(this.nextGetIndex(1)));
            return c;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    @Override
    public char getChar(int i) {
        try {
            char c = this.getChar(this.ix(this.checkIndex(i, 1)));
            return c;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuffer putChar(long a, char x) {
        try {
            char y = x;
            SCOPED_MEMORY_ACCESS.putCharUnaligned(this.scope(), null, a, y, this.bigEndian);
        }
        finally {
            Reference.reachabilityFence(this);
        }
        return this;
    }

    @Override
    public ByteBuffer putChar(char x) {
        this.putChar(this.ix(this.nextPutIndex(1)), x);
        return this;
    }

    @Override
    public ByteBuffer putChar(int i, char x) {
        this.putChar(this.ix(this.checkIndex(i, 1)), x);
        return this;
    }

    @Override
    public CharBuffer asCharBuffer() {
        int off = this.position();
        int lim = this.limit();
        assert (off <= lim);
        int rem = off <= lim ? lim - off : 0;
        int size = rem >> 0;
        if (!UNALIGNED && (this.address + (long)off) % 1L != 0L) {
            return this.bigEndian ? new ByteBufferAsCharBufferB(this, -1, 0, size, size, this.address + (long)off, this.segment) : new ByteBufferAsCharBufferL(this, -1, 0, size, size, this.address + (long)off, this.segment);
        }
        return this.nativeByteOrder ? new DirectCharBufferU(this, -1, 0, size, size, off, this.segment) : new DirectCharBufferS(this, -1, 0, size, size, off, this.segment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private short getShort(long a) {
        try {
            short x;
            short s = x = SCOPED_MEMORY_ACCESS.getShortUnaligned(this.scope(), null, a, this.bigEndian);
            return s;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    @Override
    public short getShort() {
        try {
            short s = this.getShort(this.ix(this.nextGetIndex(2)));
            return s;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    @Override
    public short getShort(int i) {
        try {
            short s = this.getShort(this.ix(this.checkIndex(i, 2)));
            return s;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuffer putShort(long a, short x) {
        try {
            short y = x;
            SCOPED_MEMORY_ACCESS.putShortUnaligned(this.scope(), null, a, y, this.bigEndian);
        }
        finally {
            Reference.reachabilityFence(this);
        }
        return this;
    }

    @Override
    public ByteBuffer putShort(short x) {
        this.putShort(this.ix(this.nextPutIndex(2)), x);
        return this;
    }

    @Override
    public ByteBuffer putShort(int i, short x) {
        this.putShort(this.ix(this.checkIndex(i, 2)), x);
        return this;
    }

    @Override
    public ShortBuffer asShortBuffer() {
        int off = this.position();
        int lim = this.limit();
        assert (off <= lim);
        int rem = off <= lim ? lim - off : 0;
        int size = rem >> 1;
        if (!UNALIGNED && (this.address + (long)off) % 2L != 0L) {
            return this.bigEndian ? new ByteBufferAsShortBufferB(this, -1, 0, size, size, this.address + (long)off, this.segment) : new ByteBufferAsShortBufferL(this, -1, 0, size, size, this.address + (long)off, this.segment);
        }
        return this.nativeByteOrder ? new DirectShortBufferU(this, -1, 0, size, size, off, this.segment) : new DirectShortBufferS(this, -1, 0, size, size, off, this.segment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getInt(long a) {
        try {
            int x;
            int n = x = SCOPED_MEMORY_ACCESS.getIntUnaligned(this.scope(), null, a, this.bigEndian);
            return n;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    @Override
    public int getInt() {
        try {
            int n = this.getInt(this.ix(this.nextGetIndex(4)));
            return n;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    @Override
    public int getInt(int i) {
        try {
            int n = this.getInt(this.ix(this.checkIndex(i, 4)));
            return n;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuffer putInt(long a, int x) {
        try {
            int y = x;
            SCOPED_MEMORY_ACCESS.putIntUnaligned(this.scope(), null, a, y, this.bigEndian);
        }
        finally {
            Reference.reachabilityFence(this);
        }
        return this;
    }

    @Override
    public ByteBuffer putInt(int x) {
        this.putInt(this.ix(this.nextPutIndex(4)), x);
        return this;
    }

    @Override
    public ByteBuffer putInt(int i, int x) {
        this.putInt(this.ix(this.checkIndex(i, 4)), x);
        return this;
    }

    @Override
    public IntBuffer asIntBuffer() {
        int off = this.position();
        int lim = this.limit();
        assert (off <= lim);
        int rem = off <= lim ? lim - off : 0;
        int size = rem >> 2;
        if (!UNALIGNED && (this.address + (long)off) % 4L != 0L) {
            return this.bigEndian ? new ByteBufferAsIntBufferB(this, -1, 0, size, size, this.address + (long)off, this.segment) : new ByteBufferAsIntBufferL(this, -1, 0, size, size, this.address + (long)off, this.segment);
        }
        return this.nativeByteOrder ? new DirectIntBufferU(this, -1, 0, size, size, off, this.segment) : new DirectIntBufferS(this, -1, 0, size, size, off, this.segment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getLong(long a) {
        try {
            long x;
            long l = x = SCOPED_MEMORY_ACCESS.getLongUnaligned(this.scope(), null, a, this.bigEndian);
            return l;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    @Override
    public long getLong() {
        try {
            long l = this.getLong(this.ix(this.nextGetIndex(8)));
            return l;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLong(int i) {
        try {
            long l = this.getLong(this.ix(this.checkIndex(i, 8)));
            return l;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuffer putLong(long a, long x) {
        try {
            long y = x;
            SCOPED_MEMORY_ACCESS.putLongUnaligned(this.scope(), null, a, y, this.bigEndian);
        }
        finally {
            Reference.reachabilityFence(this);
        }
        return this;
    }

    @Override
    public ByteBuffer putLong(long x) {
        this.putLong(this.ix(this.nextPutIndex(8)), x);
        return this;
    }

    @Override
    public ByteBuffer putLong(int i, long x) {
        this.putLong(this.ix(this.checkIndex(i, 8)), x);
        return this;
    }

    @Override
    public LongBuffer asLongBuffer() {
        int off = this.position();
        int lim = this.limit();
        assert (off <= lim);
        int rem = off <= lim ? lim - off : 0;
        int size = rem >> 3;
        if (!UNALIGNED && (this.address + (long)off) % 8L != 0L) {
            return this.bigEndian ? new ByteBufferAsLongBufferB(this, -1, 0, size, size, this.address + (long)off, this.segment) : new ByteBufferAsLongBufferL(this, -1, 0, size, size, this.address + (long)off, this.segment);
        }
        return this.nativeByteOrder ? new DirectLongBufferU(this, -1, 0, size, size, off, this.segment) : new DirectLongBufferS(this, -1, 0, size, size, off, this.segment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private float getFloat(long a) {
        try {
            int x = SCOPED_MEMORY_ACCESS.getIntUnaligned(this.scope(), null, a, this.bigEndian);
            float f = Float.intBitsToFloat(x);
            return f;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    @Override
    public float getFloat() {
        try {
            float f = this.getFloat(this.ix(this.nextGetIndex(4)));
            return f;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    @Override
    public float getFloat(int i) {
        try {
            float f = this.getFloat(this.ix(this.checkIndex(i, 4)));
            return f;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuffer putFloat(long a, float x) {
        try {
            int y = Float.floatToRawIntBits(x);
            SCOPED_MEMORY_ACCESS.putIntUnaligned(this.scope(), null, a, y, this.bigEndian);
        }
        finally {
            Reference.reachabilityFence(this);
        }
        return this;
    }

    @Override
    public ByteBuffer putFloat(float x) {
        this.putFloat(this.ix(this.nextPutIndex(4)), x);
        return this;
    }

    @Override
    public ByteBuffer putFloat(int i, float x) {
        this.putFloat(this.ix(this.checkIndex(i, 4)), x);
        return this;
    }

    @Override
    public FloatBuffer asFloatBuffer() {
        int off = this.position();
        int lim = this.limit();
        assert (off <= lim);
        int rem = off <= lim ? lim - off : 0;
        int size = rem >> 2;
        if (!UNALIGNED && (this.address + (long)off) % 4L != 0L) {
            return this.bigEndian ? new ByteBufferAsFloatBufferB(this, -1, 0, size, size, this.address + (long)off, this.segment) : new ByteBufferAsFloatBufferL(this, -1, 0, size, size, this.address + (long)off, this.segment);
        }
        return this.nativeByteOrder ? new DirectFloatBufferU(this, -1, 0, size, size, off, this.segment) : new DirectFloatBufferS(this, -1, 0, size, size, off, this.segment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double getDouble(long a) {
        try {
            long x = SCOPED_MEMORY_ACCESS.getLongUnaligned(this.scope(), null, a, this.bigEndian);
            double d = Double.longBitsToDouble(x);
            return d;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    @Override
    public double getDouble() {
        try {
            double d = this.getDouble(this.ix(this.nextGetIndex(8)));
            return d;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getDouble(int i) {
        try {
            double d = this.getDouble(this.ix(this.checkIndex(i, 8)));
            return d;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuffer putDouble(long a, double x) {
        try {
            long y = Double.doubleToRawLongBits(x);
            SCOPED_MEMORY_ACCESS.putLongUnaligned(this.scope(), null, a, y, this.bigEndian);
        }
        finally {
            Reference.reachabilityFence(this);
        }
        return this;
    }

    @Override
    public ByteBuffer putDouble(double x) {
        this.putDouble(this.ix(this.nextPutIndex(8)), x);
        return this;
    }

    @Override
    public ByteBuffer putDouble(int i, double x) {
        this.putDouble(this.ix(this.checkIndex(i, 8)), x);
        return this;
    }

    @Override
    public DoubleBuffer asDoubleBuffer() {
        int off = this.position();
        int lim = this.limit();
        assert (off <= lim);
        int rem = off <= lim ? lim - off : 0;
        int size = rem >> 3;
        if (!UNALIGNED && (this.address + (long)off) % 8L != 0L) {
            return this.bigEndian ? new ByteBufferAsDoubleBufferB(this, -1, 0, size, size, this.address + (long)off, this.segment) : new ByteBufferAsDoubleBufferL(this, -1, 0, size, size, this.address + (long)off, this.segment);
        }
        return this.nativeByteOrder ? new DirectDoubleBufferU(this, -1, 0, size, size, off, this.segment) : new DirectDoubleBufferS(this, -1, 0, size, size, off, this.segment);
    }

    private static class Deallocator
    implements Runnable {
        private long address;
        private long size;
        private int capacity;

        private Deallocator(long address, long size, int capacity) {
            assert (address != 0L);
            this.address = address;
            this.size = size;
            this.capacity = capacity;
        }

        @Override
        public void run() {
            if (this.address == 0L) {
                return;
            }
            Buffer.UNSAFE.freeMemory(this.address);
            this.address = 0L;
            Bits.unreserveMemory(this.size, this.capacity);
        }
    }
}

