/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DirectCharBufferU;
import java.nio.ReadOnlyBufferException;
import java.util.Objects;
import jdk.internal.access.foreign.MemorySegmentProxy;
import sun.nio.ch.DirectBuffer;

class DirectCharBufferRU
extends DirectCharBufferU
implements DirectBuffer {
    DirectCharBufferRU(DirectBuffer db, int mark, int pos, int lim, int cap, int off, MemorySegmentProxy segment) {
        super(db, mark, pos, lim, cap, off, segment);
        this.isReadOnly = true;
    }

    @Override
    Object base() {
        return null;
    }

    @Override
    public CharBuffer slice() {
        int lim;
        int pos = this.position();
        int rem = pos <= (lim = this.limit()) ? lim - pos : 0;
        int off = pos << 0;
        assert (off >= 0);
        return new DirectCharBufferRU(this, -1, 0, rem, rem, off, this.segment);
    }

    @Override
    public CharBuffer slice(int index, int length) {
        Objects.checkFromIndexSize(index, length, this.limit());
        return new DirectCharBufferRU(this, -1, 0, length, length, index << 0, this.segment);
    }

    @Override
    public CharBuffer duplicate() {
        return new DirectCharBufferRU(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0, this.segment);
    }

    @Override
    public CharBuffer asReadOnlyBuffer() {
        return this.duplicate();
    }

    @Override
    public CharBuffer put(char x) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public CharBuffer put(int i, char x) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public CharBuffer compact() {
        throw new ReadOnlyBufferException();
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public String toString(int start, int end) {
        Objects.checkFromToIndex(start, end, this.limit());
        try {
            int len = end - start;
            char[] ca = new char[len];
            CharBuffer cb = CharBuffer.wrap(ca);
            CharBuffer db = this.duplicate();
            db.position(start);
            db.limit(end);
            cb.put(db);
            return new String(ca);
        }
        catch (StringIndexOutOfBoundsException x) {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public CharBuffer subSequence(int start, int end) {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        pos = pos <= lim ? pos : lim;
        int len = lim - pos;
        Objects.checkFromToIndex(start, end, len);
        return new DirectCharBufferRU(this, -1, pos + start, pos + end, this.capacity(), this.offset, this.segment);
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.nativeOrder() != ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }

    @Override
    ByteOrder charRegionOrder() {
        return this.order();
    }
}

