/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.lang.ref.Reference;
import java.nio.Bits;
import java.nio.Buffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DirectCharBufferRS;
import java.util.Objects;
import jdk.internal.access.foreign.MemorySegmentProxy;
import jdk.internal.misc.ScopedMemoryAccess;
import jdk.internal.ref.Cleaner;
import sun.nio.ch.DirectBuffer;

class DirectCharBufferS
extends CharBuffer
implements DirectBuffer {
    private static final long ARRAY_BASE_OFFSET = UNSAFE.arrayBaseOffset(char[].class);
    protected static final boolean UNALIGNED = Bits.unaligned();
    private final Object att;

    @Override
    public Object attachment() {
        return this.att;
    }

    @Override
    public Cleaner cleaner() {
        return null;
    }

    DirectCharBufferS(DirectBuffer db, int mark, int pos, int lim, int cap, int off, MemorySegmentProxy segment) {
        super(mark, pos, lim, cap, segment);
        this.address = ((Buffer)((Object)db)).address + (long)off;
        Object attachment = db.attachment();
        this.att = attachment == null ? db : attachment;
    }

    @Override
    Object base() {
        return null;
    }

    @Override
    public CharBuffer slice() {
        int lim;
        int pos = this.position();
        int rem = pos <= (lim = this.limit()) ? lim - pos : 0;
        int off = pos << 0;
        assert (off >= 0);
        return new DirectCharBufferS(this, -1, 0, rem, rem, off, this.segment);
    }

    @Override
    public CharBuffer slice(int index, int length) {
        Objects.checkFromIndexSize(index, length, this.limit());
        return new DirectCharBufferS(this, -1, 0, length, length, index << 0, this.segment);
    }

    @Override
    public CharBuffer duplicate() {
        return new DirectCharBufferS(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0, this.segment);
    }

    @Override
    public CharBuffer asReadOnlyBuffer() {
        return new DirectCharBufferRS(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0, this.segment);
    }

    @Override
    public long address() {
        ScopedMemoryAccess.Scope scope = this.scope();
        if (scope != null) {
            if (scope.ownerThread() == null) {
                throw new UnsupportedOperationException("ByteBuffer derived from shared segments not supported");
            }
            try {
                scope.checkValidState();
            }
            catch (ScopedMemoryAccess.Scope.ScopedAccessError e) {
                throw new IllegalStateException("This segment is already closed");
            }
        }
        return this.address;
    }

    private long ix(int i) {
        return this.address + ((long)i << 0);
    }

    @Override
    public char get() {
        try {
            char c = SCOPED_MEMORY_ACCESS.getChar(this.scope(), null, this.ix(this.nextGetIndex()));
            return c;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    @Override
    public char get(int i) {
        try {
            char c = SCOPED_MEMORY_ACCESS.getChar(this.scope(), null, this.ix(this.checkIndex(i)));
            return c;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    @Override
    char getUnchecked(int i) {
        try {
            char c = SCOPED_MEMORY_ACCESS.getChar(null, null, this.ix(i));
            return c;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    @Override
    public CharBuffer put(char x) {
        try {
            SCOPED_MEMORY_ACCESS.putChar(this.scope(), null, this.ix(this.nextPutIndex()), x);
        }
        finally {
            Reference.reachabilityFence(this);
        }
        return this;
    }

    @Override
    public CharBuffer put(int i, char x) {
        try {
            SCOPED_MEMORY_ACCESS.putChar(this.scope(), null, this.ix(this.checkIndex(i)), x);
        }
        finally {
            Reference.reachabilityFence(this);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CharBuffer compact() {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        try {
            SCOPED_MEMORY_ACCESS.copyMemory(this.scope(), null, null, this.ix(pos), null, this.ix(0), (long)rem << 0);
        }
        finally {
            Reference.reachabilityFence(this);
        }
        this.position(rem);
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public String toString(int start, int end) {
        Objects.checkFromToIndex(start, end, this.limit());
        try {
            int len = end - start;
            char[] ca = new char[len];
            CharBuffer cb = CharBuffer.wrap(ca);
            CharBuffer db = this.duplicate();
            db.position(start);
            db.limit(end);
            cb.put(db);
            return new String(ca);
        }
        catch (StringIndexOutOfBoundsException x) {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public CharBuffer subSequence(int start, int end) {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        pos = pos <= lim ? pos : lim;
        int len = lim - pos;
        Objects.checkFromToIndex(start, end, len);
        return new DirectCharBufferS(this, -1, pos + start, pos + end, this.capacity(), this.offset, this.segment);
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }

    @Override
    ByteOrder charRegionOrder() {
        return this.order();
    }
}

