/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteOrder;
import java.nio.DirectIntBufferS;
import java.nio.IntBuffer;
import java.nio.ReadOnlyBufferException;
import java.util.Objects;
import jdk.internal.access.foreign.MemorySegmentProxy;
import sun.nio.ch.DirectBuffer;

class DirectIntBufferRS
extends DirectIntBufferS
implements DirectBuffer {
    DirectIntBufferRS(DirectBuffer db, int mark, int pos, int lim, int cap, int off, MemorySegmentProxy segment) {
        super(db, mark, pos, lim, cap, off, segment);
        this.isReadOnly = true;
    }

    @Override
    Object base() {
        return null;
    }

    @Override
    public IntBuffer slice() {
        int lim;
        int pos = this.position();
        int rem = pos <= (lim = this.limit()) ? lim - pos : 0;
        int off = pos << 2;
        assert (off >= 0);
        return new DirectIntBufferRS(this, -1, 0, rem, rem, off, this.segment);
    }

    @Override
    public IntBuffer slice(int index, int length) {
        Objects.checkFromIndexSize(index, length, this.limit());
        return new DirectIntBufferRS(this, -1, 0, length, length, index << 2, this.segment);
    }

    @Override
    public IntBuffer duplicate() {
        return new DirectIntBufferRS(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0, this.segment);
    }

    @Override
    public IntBuffer asReadOnlyBuffer() {
        return this.duplicate();
    }

    @Override
    public IntBuffer put(int x) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public IntBuffer put(int i, int x) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public IntBuffer compact() {
        throw new ReadOnlyBufferException();
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }
}

