/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.lang.ref.Reference;
import java.nio.Bits;
import java.nio.Buffer;
import java.nio.ByteOrder;
import java.nio.DirectIntBufferRS;
import java.nio.IntBuffer;
import java.util.Objects;
import jdk.internal.access.foreign.MemorySegmentProxy;
import jdk.internal.misc.ScopedMemoryAccess;
import jdk.internal.ref.Cleaner;
import sun.nio.ch.DirectBuffer;

class DirectIntBufferS
extends IntBuffer
implements DirectBuffer {
    private static final long ARRAY_BASE_OFFSET = UNSAFE.arrayBaseOffset(int[].class);
    protected static final boolean UNALIGNED = Bits.unaligned();
    private final Object att;

    @Override
    public Object attachment() {
        return this.att;
    }

    @Override
    public Cleaner cleaner() {
        return null;
    }

    DirectIntBufferS(DirectBuffer db, int mark, int pos, int lim, int cap, int off, MemorySegmentProxy segment) {
        super(mark, pos, lim, cap, segment);
        this.address = ((Buffer)((Object)db)).address + (long)off;
        Object attachment = db.attachment();
        this.att = attachment == null ? db : attachment;
    }

    @Override
    Object base() {
        return null;
    }

    @Override
    public IntBuffer slice() {
        int lim;
        int pos = this.position();
        int rem = pos <= (lim = this.limit()) ? lim - pos : 0;
        int off = pos << 2;
        assert (off >= 0);
        return new DirectIntBufferS(this, -1, 0, rem, rem, off, this.segment);
    }

    @Override
    public IntBuffer slice(int index, int length) {
        Objects.checkFromIndexSize(index, length, this.limit());
        return new DirectIntBufferS(this, -1, 0, length, length, index << 2, this.segment);
    }

    @Override
    public IntBuffer duplicate() {
        return new DirectIntBufferS(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0, this.segment);
    }

    @Override
    public IntBuffer asReadOnlyBuffer() {
        return new DirectIntBufferRS(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0, this.segment);
    }

    @Override
    public long address() {
        ScopedMemoryAccess.Scope scope = this.scope();
        if (scope != null) {
            if (scope.ownerThread() == null) {
                throw new UnsupportedOperationException("ByteBuffer derived from shared segments not supported");
            }
            try {
                scope.checkValidState();
            }
            catch (ScopedMemoryAccess.Scope.ScopedAccessError e) {
                throw new IllegalStateException("This segment is already closed");
            }
        }
        return this.address;
    }

    private long ix(int i) {
        return this.address + ((long)i << 2);
    }

    @Override
    public int get() {
        try {
            int n = SCOPED_MEMORY_ACCESS.getInt(this.scope(), null, this.ix(this.nextGetIndex()));
            return n;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    @Override
    public int get(int i) {
        try {
            int n = SCOPED_MEMORY_ACCESS.getInt(this.scope(), null, this.ix(this.checkIndex(i)));
            return n;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    @Override
    public IntBuffer put(int x) {
        try {
            SCOPED_MEMORY_ACCESS.putInt(this.scope(), null, this.ix(this.nextPutIndex()), x);
        }
        finally {
            Reference.reachabilityFence(this);
        }
        return this;
    }

    @Override
    public IntBuffer put(int i, int x) {
        try {
            SCOPED_MEMORY_ACCESS.putInt(this.scope(), null, this.ix(this.checkIndex(i)), x);
        }
        finally {
            Reference.reachabilityFence(this);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IntBuffer compact() {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        try {
            SCOPED_MEMORY_ACCESS.copyMemory(this.scope(), null, null, this.ix(pos), null, this.ix(0), (long)rem << 2);
        }
        finally {
            Reference.reachabilityFence(this);
        }
        this.position(rem);
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }
}

