/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.lang.ref.Reference;
import java.nio.Bits;
import java.nio.Buffer;
import java.nio.ByteOrder;
import java.nio.DirectLongBufferRU;
import java.nio.LongBuffer;
import java.util.Objects;
import jdk.internal.access.foreign.MemorySegmentProxy;
import jdk.internal.misc.ScopedMemoryAccess;
import jdk.internal.ref.Cleaner;
import sun.nio.ch.DirectBuffer;

class DirectLongBufferU
extends LongBuffer
implements DirectBuffer {
    private static final long ARRAY_BASE_OFFSET = UNSAFE.arrayBaseOffset(long[].class);
    protected static final boolean UNALIGNED = Bits.unaligned();
    private final Object att;

    @Override
    public Object attachment() {
        return this.att;
    }

    @Override
    public Cleaner cleaner() {
        return null;
    }

    DirectLongBufferU(DirectBuffer db, int mark, int pos, int lim, int cap, int off, MemorySegmentProxy segment) {
        super(mark, pos, lim, cap, segment);
        this.address = ((Buffer)((Object)db)).address + (long)off;
        Object attachment = db.attachment();
        this.att = attachment == null ? db : attachment;
    }

    @Override
    Object base() {
        return null;
    }

    @Override
    public LongBuffer slice() {
        int lim;
        int pos = this.position();
        int rem = pos <= (lim = this.limit()) ? lim - pos : 0;
        int off = pos << 3;
        assert (off >= 0);
        return new DirectLongBufferU(this, -1, 0, rem, rem, off, this.segment);
    }

    @Override
    public LongBuffer slice(int index, int length) {
        Objects.checkFromIndexSize(index, length, this.limit());
        return new DirectLongBufferU(this, -1, 0, length, length, index << 3, this.segment);
    }

    @Override
    public LongBuffer duplicate() {
        return new DirectLongBufferU(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0, this.segment);
    }

    @Override
    public LongBuffer asReadOnlyBuffer() {
        return new DirectLongBufferRU(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0, this.segment);
    }

    @Override
    public long address() {
        ScopedMemoryAccess.Scope scope = this.scope();
        if (scope != null) {
            if (scope.ownerThread() == null) {
                throw new UnsupportedOperationException("ByteBuffer derived from shared segments not supported");
            }
            try {
                scope.checkValidState();
            }
            catch (ScopedMemoryAccess.Scope.ScopedAccessError e) {
                throw new IllegalStateException("This segment is already closed");
            }
        }
        return this.address;
    }

    private long ix(int i) {
        return this.address + ((long)i << 3);
    }

    @Override
    public long get() {
        try {
            long l = SCOPED_MEMORY_ACCESS.getLong(this.scope(), null, this.ix(this.nextGetIndex()));
            return l;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long get(int i) {
        try {
            long l = SCOPED_MEMORY_ACCESS.getLong(this.scope(), null, this.ix(this.checkIndex(i)));
            return l;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    @Override
    public LongBuffer put(long x) {
        try {
            SCOPED_MEMORY_ACCESS.putLong(this.scope(), null, this.ix(this.nextPutIndex()), x);
        }
        finally {
            Reference.reachabilityFence(this);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LongBuffer put(int i, long x) {
        try {
            SCOPED_MEMORY_ACCESS.putLong(this.scope(), null, this.ix(this.checkIndex(i)), x);
        }
        finally {
            Reference.reachabilityFence(this);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LongBuffer compact() {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        try {
            SCOPED_MEMORY_ACCESS.copyMemory(this.scope(), null, null, this.ix(pos), null, this.ix(0), (long)rem << 3);
        }
        finally {
            Reference.reachabilityFence(this);
        }
        this.position(rem);
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.nativeOrder() != ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }
}

