/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteOrder;
import java.nio.DirectShortBufferU;
import java.nio.ReadOnlyBufferException;
import java.nio.ShortBuffer;
import java.util.Objects;
import jdk.internal.access.foreign.MemorySegmentProxy;
import sun.nio.ch.DirectBuffer;

class DirectShortBufferRU
extends DirectShortBufferU
implements DirectBuffer {
    DirectShortBufferRU(DirectBuffer db, int mark, int pos, int lim, int cap, int off, MemorySegmentProxy segment) {
        super(db, mark, pos, lim, cap, off, segment);
        this.isReadOnly = true;
    }

    @Override
    Object base() {
        return null;
    }

    @Override
    public ShortBuffer slice() {
        int lim;
        int pos = this.position();
        int rem = pos <= (lim = this.limit()) ? lim - pos : 0;
        int off = pos << 1;
        assert (off >= 0);
        return new DirectShortBufferRU(this, -1, 0, rem, rem, off, this.segment);
    }

    @Override
    public ShortBuffer slice(int index, int length) {
        Objects.checkFromIndexSize(index, length, this.limit());
        return new DirectShortBufferRU(this, -1, 0, length, length, index << 1, this.segment);
    }

    @Override
    public ShortBuffer duplicate() {
        return new DirectShortBufferRU(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0, this.segment);
    }

    @Override
    public ShortBuffer asReadOnlyBuffer() {
        return this.duplicate();
    }

    @Override
    public ShortBuffer put(short x) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ShortBuffer put(int i, short x) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ShortBuffer compact() {
        throw new ReadOnlyBufferException();
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.nativeOrder() != ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }
}

