/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteBufferAsCharBufferB;
import java.nio.ByteBufferAsCharBufferL;
import java.nio.ByteBufferAsDoubleBufferB;
import java.nio.ByteBufferAsDoubleBufferL;
import java.nio.ByteBufferAsFloatBufferB;
import java.nio.ByteBufferAsFloatBufferL;
import java.nio.ByteBufferAsIntBufferB;
import java.nio.ByteBufferAsIntBufferL;
import java.nio.ByteBufferAsLongBufferB;
import java.nio.ByteBufferAsLongBufferL;
import java.nio.ByteBufferAsShortBufferB;
import java.nio.ByteBufferAsShortBufferL;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.HeapByteBufferR;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.Objects;
import jdk.internal.access.foreign.MemorySegmentProxy;

class HeapByteBuffer
extends ByteBuffer {
    private static final long ARRAY_BASE_OFFSET = UNSAFE.arrayBaseOffset(byte[].class);
    private static final long ARRAY_INDEX_SCALE = UNSAFE.arrayIndexScale(byte[].class);

    HeapByteBuffer(int cap, int lim, MemorySegmentProxy segment) {
        super(-1, 0, lim, cap, new byte[cap], 0, segment);
        this.address = ARRAY_BASE_OFFSET;
    }

    HeapByteBuffer(byte[] buf, int off, int len, MemorySegmentProxy segment) {
        super(-1, off, off + len, buf.length, buf, 0, segment);
        this.address = ARRAY_BASE_OFFSET;
    }

    protected HeapByteBuffer(byte[] buf, int mark, int pos, int lim, int cap, int off, MemorySegmentProxy segment) {
        super(mark, pos, lim, cap, buf, off, segment);
        this.address = ARRAY_BASE_OFFSET + (long)off * ARRAY_INDEX_SCALE;
    }

    @Override
    public ByteBuffer slice() {
        int lim;
        int pos = this.position();
        int rem = pos <= (lim = this.limit()) ? lim - pos : 0;
        return new HeapByteBuffer(this.hb, -1, 0, rem, rem, pos + this.offset, this.segment);
    }

    @Override
    public ByteBuffer slice(int index, int length) {
        Objects.checkFromIndexSize(index, length, this.limit());
        return new HeapByteBuffer(this.hb, -1, 0, length, length, index + this.offset, this.segment);
    }

    @Override
    public ByteBuffer duplicate() {
        return new HeapByteBuffer(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset, this.segment);
    }

    @Override
    public ByteBuffer asReadOnlyBuffer() {
        return new HeapByteBufferR(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset, this.segment);
    }

    protected int ix(int i) {
        return i + this.offset;
    }

    private long byteOffset(long i) {
        return this.address + i;
    }

    @Override
    public byte get() {
        return this.hb[this.ix(this.nextGetIndex())];
    }

    @Override
    public byte get(int i) {
        return this.hb[this.ix(this.checkIndex(i))];
    }

    @Override
    public ByteBuffer get(byte[] dst, int offset, int length) {
        this.checkScope();
        Objects.checkFromIndexSize(offset, length, dst.length);
        int pos = this.position();
        if (length > this.limit() - pos) {
            throw new BufferUnderflowException();
        }
        System.arraycopy(this.hb, this.ix(pos), dst, offset, length);
        this.position(pos + length);
        return this;
    }

    @Override
    public ByteBuffer get(int index, byte[] dst, int offset, int length) {
        this.checkScope();
        Objects.checkFromIndexSize(index, length, this.limit());
        Objects.checkFromIndexSize(offset, length, dst.length);
        System.arraycopy(this.hb, this.ix(index), dst, offset, length);
        return this;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ByteBuffer put(byte x) {
        this.hb[this.ix((int)this.nextPutIndex())] = x;
        return this;
    }

    @Override
    public ByteBuffer put(int i, byte x) {
        this.hb[this.ix((int)this.checkIndex((int)i))] = x;
        return this;
    }

    @Override
    public ByteBuffer put(byte[] src, int offset, int length) {
        this.checkScope();
        Objects.checkFromIndexSize(offset, length, src.length);
        int pos = this.position();
        if (length > this.limit() - pos) {
            throw new BufferOverflowException();
        }
        System.arraycopy(src, offset, this.hb, this.ix(pos), length);
        this.position(pos + length);
        return this;
    }

    @Override
    public ByteBuffer put(ByteBuffer src) {
        this.checkScope();
        super.put(src);
        return this;
    }

    @Override
    public ByteBuffer put(int index, ByteBuffer src, int offset, int length) {
        this.checkScope();
        super.put(index, src, offset, length);
        return this;
    }

    @Override
    public ByteBuffer put(int index, byte[] src, int offset, int length) {
        this.checkScope();
        Objects.checkFromIndexSize(index, length, this.limit());
        Objects.checkFromIndexSize(offset, length, src.length);
        System.arraycopy(src, offset, this.hb, this.ix(index), length);
        return this;
    }

    @Override
    public ByteBuffer compact() {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        System.arraycopy(this.hb, this.ix(pos), this.hb, this.ix(0), rem);
        this.position(rem);
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    byte _get(int i) {
        return this.hb[i];
    }

    void _put(int i, byte b) {
        this.hb[i] = b;
    }

    @Override
    public char getChar() {
        return SCOPED_MEMORY_ACCESS.getCharUnaligned(this.scope(), this.hb, this.byteOffset(this.nextGetIndex(2)), this.bigEndian);
    }

    @Override
    public char getChar(int i) {
        return SCOPED_MEMORY_ACCESS.getCharUnaligned(this.scope(), this.hb, this.byteOffset(this.checkIndex(i, 2)), this.bigEndian);
    }

    @Override
    public ByteBuffer putChar(char x) {
        SCOPED_MEMORY_ACCESS.putCharUnaligned(this.scope(), this.hb, this.byteOffset(this.nextPutIndex(2)), x, this.bigEndian);
        return this;
    }

    @Override
    public ByteBuffer putChar(int i, char x) {
        SCOPED_MEMORY_ACCESS.putCharUnaligned(this.scope(), this.hb, this.byteOffset(this.checkIndex(i, 2)), x, this.bigEndian);
        return this;
    }

    @Override
    public CharBuffer asCharBuffer() {
        int pos = this.position();
        int size = this.limit() - pos >> 1;
        long addr = this.address + (long)pos;
        return this.bigEndian ? new ByteBufferAsCharBufferB(this, -1, 0, size, size, addr, this.segment) : new ByteBufferAsCharBufferL(this, -1, 0, size, size, addr, this.segment);
    }

    @Override
    public short getShort() {
        return SCOPED_MEMORY_ACCESS.getShortUnaligned(this.scope(), this.hb, this.byteOffset(this.nextGetIndex(2)), this.bigEndian);
    }

    @Override
    public short getShort(int i) {
        return SCOPED_MEMORY_ACCESS.getShortUnaligned(this.scope(), this.hb, this.byteOffset(this.checkIndex(i, 2)), this.bigEndian);
    }

    @Override
    public ByteBuffer putShort(short x) {
        SCOPED_MEMORY_ACCESS.putShortUnaligned(this.scope(), this.hb, this.byteOffset(this.nextPutIndex(2)), x, this.bigEndian);
        return this;
    }

    @Override
    public ByteBuffer putShort(int i, short x) {
        SCOPED_MEMORY_ACCESS.putShortUnaligned(this.scope(), this.hb, this.byteOffset(this.checkIndex(i, 2)), x, this.bigEndian);
        return this;
    }

    @Override
    public ShortBuffer asShortBuffer() {
        int pos = this.position();
        int size = this.limit() - pos >> 1;
        long addr = this.address + (long)pos;
        return this.bigEndian ? new ByteBufferAsShortBufferB(this, -1, 0, size, size, addr, this.segment) : new ByteBufferAsShortBufferL(this, -1, 0, size, size, addr, this.segment);
    }

    @Override
    public int getInt() {
        return SCOPED_MEMORY_ACCESS.getIntUnaligned(this.scope(), this.hb, this.byteOffset(this.nextGetIndex(4)), this.bigEndian);
    }

    @Override
    public int getInt(int i) {
        return SCOPED_MEMORY_ACCESS.getIntUnaligned(this.scope(), this.hb, this.byteOffset(this.checkIndex(i, 4)), this.bigEndian);
    }

    @Override
    public ByteBuffer putInt(int x) {
        SCOPED_MEMORY_ACCESS.putIntUnaligned(this.scope(), this.hb, this.byteOffset(this.nextPutIndex(4)), x, this.bigEndian);
        return this;
    }

    @Override
    public ByteBuffer putInt(int i, int x) {
        SCOPED_MEMORY_ACCESS.putIntUnaligned(this.scope(), this.hb, this.byteOffset(this.checkIndex(i, 4)), x, this.bigEndian);
        return this;
    }

    @Override
    public IntBuffer asIntBuffer() {
        int pos = this.position();
        int size = this.limit() - pos >> 2;
        long addr = this.address + (long)pos;
        return this.bigEndian ? new ByteBufferAsIntBufferB(this, -1, 0, size, size, addr, this.segment) : new ByteBufferAsIntBufferL(this, -1, 0, size, size, addr, this.segment);
    }

    @Override
    public long getLong() {
        return SCOPED_MEMORY_ACCESS.getLongUnaligned(this.scope(), this.hb, this.byteOffset(this.nextGetIndex(8)), this.bigEndian);
    }

    @Override
    public long getLong(int i) {
        return SCOPED_MEMORY_ACCESS.getLongUnaligned(this.scope(), this.hb, this.byteOffset(this.checkIndex(i, 8)), this.bigEndian);
    }

    @Override
    public ByteBuffer putLong(long x) {
        SCOPED_MEMORY_ACCESS.putLongUnaligned(this.scope(), this.hb, this.byteOffset(this.nextPutIndex(8)), x, this.bigEndian);
        return this;
    }

    @Override
    public ByteBuffer putLong(int i, long x) {
        SCOPED_MEMORY_ACCESS.putLongUnaligned(this.scope(), this.hb, this.byteOffset(this.checkIndex(i, 8)), x, this.bigEndian);
        return this;
    }

    @Override
    public LongBuffer asLongBuffer() {
        int pos = this.position();
        int size = this.limit() - pos >> 3;
        long addr = this.address + (long)pos;
        return this.bigEndian ? new ByteBufferAsLongBufferB(this, -1, 0, size, size, addr, this.segment) : new ByteBufferAsLongBufferL(this, -1, 0, size, size, addr, this.segment);
    }

    @Override
    public float getFloat() {
        int x = SCOPED_MEMORY_ACCESS.getIntUnaligned(this.scope(), this.hb, this.byteOffset(this.nextGetIndex(4)), this.bigEndian);
        return Float.intBitsToFloat(x);
    }

    @Override
    public float getFloat(int i) {
        int x = SCOPED_MEMORY_ACCESS.getIntUnaligned(this.scope(), this.hb, this.byteOffset(this.checkIndex(i, 4)), this.bigEndian);
        return Float.intBitsToFloat(x);
    }

    @Override
    public ByteBuffer putFloat(float x) {
        int y = Float.floatToRawIntBits(x);
        SCOPED_MEMORY_ACCESS.putIntUnaligned(this.scope(), this.hb, this.byteOffset(this.nextPutIndex(4)), y, this.bigEndian);
        return this;
    }

    @Override
    public ByteBuffer putFloat(int i, float x) {
        int y = Float.floatToRawIntBits(x);
        SCOPED_MEMORY_ACCESS.putIntUnaligned(this.scope(), this.hb, this.byteOffset(this.checkIndex(i, 4)), y, this.bigEndian);
        return this;
    }

    @Override
    public FloatBuffer asFloatBuffer() {
        int pos = this.position();
        int size = this.limit() - pos >> 2;
        long addr = this.address + (long)pos;
        return this.bigEndian ? new ByteBufferAsFloatBufferB(this, -1, 0, size, size, addr, this.segment) : new ByteBufferAsFloatBufferL(this, -1, 0, size, size, addr, this.segment);
    }

    @Override
    public double getDouble() {
        long x = SCOPED_MEMORY_ACCESS.getLongUnaligned(this.scope(), this.hb, this.byteOffset(this.nextGetIndex(8)), this.bigEndian);
        return Double.longBitsToDouble(x);
    }

    @Override
    public double getDouble(int i) {
        long x = SCOPED_MEMORY_ACCESS.getLongUnaligned(this.scope(), this.hb, this.byteOffset(this.checkIndex(i, 8)), this.bigEndian);
        return Double.longBitsToDouble(x);
    }

    @Override
    public ByteBuffer putDouble(double x) {
        long y = Double.doubleToRawLongBits(x);
        SCOPED_MEMORY_ACCESS.putLongUnaligned(this.scope(), this.hb, this.byteOffset(this.nextPutIndex(8)), y, this.bigEndian);
        return this;
    }

    @Override
    public ByteBuffer putDouble(int i, double x) {
        long y = Double.doubleToRawLongBits(x);
        SCOPED_MEMORY_ACCESS.putLongUnaligned(this.scope(), this.hb, this.byteOffset(this.checkIndex(i, 8)), y, this.bigEndian);
        return this;
    }

    @Override
    public DoubleBuffer asDoubleBuffer() {
        int pos = this.position();
        int size = this.limit() - pos >> 3;
        long addr = this.address + (long)pos;
        return this.bigEndian ? new ByteBufferAsDoubleBufferB(this, -1, 0, size, size, addr, this.segment) : new ByteBufferAsDoubleBufferL(this, -1, 0, size, size, addr, this.segment);
    }
}

