/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteBuffer;
import java.nio.ByteBufferAsCharBufferRB;
import java.nio.ByteBufferAsCharBufferRL;
import java.nio.ByteBufferAsDoubleBufferRB;
import java.nio.ByteBufferAsDoubleBufferRL;
import java.nio.ByteBufferAsFloatBufferRB;
import java.nio.ByteBufferAsFloatBufferRL;
import java.nio.ByteBufferAsIntBufferRB;
import java.nio.ByteBufferAsIntBufferRL;
import java.nio.ByteBufferAsLongBufferRB;
import java.nio.ByteBufferAsLongBufferRL;
import java.nio.ByteBufferAsShortBufferRB;
import java.nio.ByteBufferAsShortBufferRL;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.HeapByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ReadOnlyBufferException;
import java.nio.ShortBuffer;
import java.util.Objects;
import jdk.internal.access.foreign.MemorySegmentProxy;

class HeapByteBufferR
extends HeapByteBuffer {
    private static final long ARRAY_BASE_OFFSET = UNSAFE.arrayBaseOffset(byte[].class);
    private static final long ARRAY_INDEX_SCALE = UNSAFE.arrayIndexScale(byte[].class);

    HeapByteBufferR(int cap, int lim, MemorySegmentProxy segment) {
        super(cap, lim, segment);
        this.isReadOnly = true;
    }

    HeapByteBufferR(byte[] buf, int off, int len, MemorySegmentProxy segment) {
        super(buf, off, len, segment);
        this.isReadOnly = true;
    }

    protected HeapByteBufferR(byte[] buf, int mark, int pos, int lim, int cap, int off, MemorySegmentProxy segment) {
        super(buf, mark, pos, lim, cap, off, segment);
        this.isReadOnly = true;
    }

    @Override
    public ByteBuffer slice() {
        int lim;
        int pos = this.position();
        int rem = pos <= (lim = this.limit()) ? lim - pos : 0;
        return new HeapByteBufferR(this.hb, -1, 0, rem, rem, pos + this.offset, this.segment);
    }

    @Override
    public ByteBuffer slice(int index, int length) {
        Objects.checkFromIndexSize(index, length, this.limit());
        return new HeapByteBufferR(this.hb, -1, 0, length, length, index + this.offset, this.segment);
    }

    @Override
    public ByteBuffer duplicate() {
        return new HeapByteBufferR(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset, this.segment);
    }

    @Override
    public ByteBuffer asReadOnlyBuffer() {
        return this.duplicate();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public ByteBuffer put(byte x) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuffer put(int i, byte x) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuffer put(byte[] src, int offset, int length) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuffer put(ByteBuffer src) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuffer put(int index, ByteBuffer src, int offset, int length) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuffer put(int index, byte[] src, int offset, int length) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuffer compact() {
        throw new ReadOnlyBufferException();
    }

    @Override
    byte _get(int i) {
        return this.hb[i];
    }

    @Override
    void _put(int i, byte b) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuffer putChar(char x) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuffer putChar(int i, char x) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public CharBuffer asCharBuffer() {
        int pos = this.position();
        int size = this.limit() - pos >> 1;
        long addr = this.address + (long)pos;
        return this.bigEndian ? new ByteBufferAsCharBufferRB(this, -1, 0, size, size, addr, this.segment) : new ByteBufferAsCharBufferRL(this, -1, 0, size, size, addr, this.segment);
    }

    @Override
    public ByteBuffer putShort(short x) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuffer putShort(int i, short x) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ShortBuffer asShortBuffer() {
        int pos = this.position();
        int size = this.limit() - pos >> 1;
        long addr = this.address + (long)pos;
        return this.bigEndian ? new ByteBufferAsShortBufferRB(this, -1, 0, size, size, addr, this.segment) : new ByteBufferAsShortBufferRL(this, -1, 0, size, size, addr, this.segment);
    }

    @Override
    public ByteBuffer putInt(int x) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuffer putInt(int i, int x) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public IntBuffer asIntBuffer() {
        int pos = this.position();
        int size = this.limit() - pos >> 2;
        long addr = this.address + (long)pos;
        return this.bigEndian ? new ByteBufferAsIntBufferRB(this, -1, 0, size, size, addr, this.segment) : new ByteBufferAsIntBufferRL(this, -1, 0, size, size, addr, this.segment);
    }

    @Override
    public ByteBuffer putLong(long x) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuffer putLong(int i, long x) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public LongBuffer asLongBuffer() {
        int pos = this.position();
        int size = this.limit() - pos >> 3;
        long addr = this.address + (long)pos;
        return this.bigEndian ? new ByteBufferAsLongBufferRB(this, -1, 0, size, size, addr, this.segment) : new ByteBufferAsLongBufferRL(this, -1, 0, size, size, addr, this.segment);
    }

    @Override
    public ByteBuffer putFloat(float x) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuffer putFloat(int i, float x) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public FloatBuffer asFloatBuffer() {
        int pos = this.position();
        int size = this.limit() - pos >> 2;
        long addr = this.address + (long)pos;
        return this.bigEndian ? new ByteBufferAsFloatBufferRB(this, -1, 0, size, size, addr, this.segment) : new ByteBufferAsFloatBufferRL(this, -1, 0, size, size, addr, this.segment);
    }

    @Override
    public ByteBuffer putDouble(double x) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuffer putDouble(int i, double x) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public DoubleBuffer asDoubleBuffer() {
        int pos = this.position();
        int size = this.limit() - pos >> 3;
        long addr = this.address + (long)pos;
        return this.bigEndian ? new ByteBufferAsDoubleBufferRB(this, -1, 0, size, size, addr, this.segment) : new ByteBufferAsDoubleBufferRL(this, -1, 0, size, size, addr, this.segment);
    }
}

