/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.HeapCharBufferR;
import java.util.Objects;
import jdk.internal.access.foreign.MemorySegmentProxy;

class HeapCharBuffer
extends CharBuffer {
    private static final long ARRAY_BASE_OFFSET = UNSAFE.arrayBaseOffset(char[].class);
    private static final long ARRAY_INDEX_SCALE = UNSAFE.arrayIndexScale(char[].class);

    HeapCharBuffer(int cap, int lim, MemorySegmentProxy segment) {
        super(-1, 0, lim, cap, new char[cap], 0, segment);
        this.address = ARRAY_BASE_OFFSET;
    }

    HeapCharBuffer(char[] buf, int off, int len, MemorySegmentProxy segment) {
        super(-1, off, off + len, buf.length, buf, 0, segment);
        this.address = ARRAY_BASE_OFFSET;
    }

    protected HeapCharBuffer(char[] buf, int mark, int pos, int lim, int cap, int off, MemorySegmentProxy segment) {
        super(mark, pos, lim, cap, buf, off, segment);
        this.address = ARRAY_BASE_OFFSET + (long)off * ARRAY_INDEX_SCALE;
    }

    @Override
    public CharBuffer slice() {
        int lim;
        int pos = this.position();
        int rem = pos <= (lim = this.limit()) ? lim - pos : 0;
        return new HeapCharBuffer(this.hb, -1, 0, rem, rem, pos + this.offset, this.segment);
    }

    @Override
    public CharBuffer slice(int index, int length) {
        Objects.checkFromIndexSize(index, length, this.limit());
        return new HeapCharBuffer(this.hb, -1, 0, length, length, index + this.offset, this.segment);
    }

    @Override
    public CharBuffer duplicate() {
        return new HeapCharBuffer(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset, this.segment);
    }

    @Override
    public CharBuffer asReadOnlyBuffer() {
        return new HeapCharBufferR(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset, this.segment);
    }

    protected int ix(int i) {
        return i + this.offset;
    }

    @Override
    public char get() {
        return this.hb[this.ix(this.nextGetIndex())];
    }

    @Override
    public char get(int i) {
        return this.hb[this.ix(this.checkIndex(i))];
    }

    @Override
    char getUnchecked(int i) {
        return this.hb[this.ix(i)];
    }

    @Override
    public CharBuffer get(char[] dst, int offset, int length) {
        this.checkScope();
        Objects.checkFromIndexSize(offset, length, dst.length);
        int pos = this.position();
        if (length > this.limit() - pos) {
            throw new BufferUnderflowException();
        }
        System.arraycopy(this.hb, this.ix(pos), dst, offset, length);
        this.position(pos + length);
        return this;
    }

    @Override
    public CharBuffer get(int index, char[] dst, int offset, int length) {
        this.checkScope();
        Objects.checkFromIndexSize(index, length, this.limit());
        Objects.checkFromIndexSize(offset, length, dst.length);
        System.arraycopy(this.hb, this.ix(index), dst, offset, length);
        return this;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public CharBuffer put(char x) {
        this.hb[this.ix((int)this.nextPutIndex())] = x;
        return this;
    }

    @Override
    public CharBuffer put(int i, char x) {
        this.hb[this.ix((int)this.checkIndex((int)i))] = x;
        return this;
    }

    @Override
    public CharBuffer put(char[] src, int offset, int length) {
        this.checkScope();
        Objects.checkFromIndexSize(offset, length, src.length);
        int pos = this.position();
        if (length > this.limit() - pos) {
            throw new BufferOverflowException();
        }
        System.arraycopy(src, offset, this.hb, this.ix(pos), length);
        this.position(pos + length);
        return this;
    }

    @Override
    public CharBuffer put(CharBuffer src) {
        this.checkScope();
        super.put(src);
        return this;
    }

    @Override
    public CharBuffer put(int index, CharBuffer src, int offset, int length) {
        this.checkScope();
        super.put(index, src, offset, length);
        return this;
    }

    @Override
    public CharBuffer put(int index, char[] src, int offset, int length) {
        this.checkScope();
        Objects.checkFromIndexSize(index, length, this.limit());
        Objects.checkFromIndexSize(offset, length, src.length);
        System.arraycopy(src, offset, this.hb, this.ix(index), length);
        return this;
    }

    @Override
    public CharBuffer put(String src, int start, int end) {
        int rem;
        this.checkScope();
        int length = end - start;
        Objects.checkFromIndexSize(start, length, src.length());
        int pos = this.position();
        int lim = this.limit();
        int n = rem = pos <= lim ? lim - pos : 0;
        if (length > rem) {
            throw new BufferOverflowException();
        }
        src.getChars(start, end, this.hb, this.ix(pos));
        this.position(pos + length);
        return this;
    }

    @Override
    public CharBuffer compact() {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        System.arraycopy(this.hb, this.ix(pos), this.hb, this.ix(0), rem);
        this.position(rem);
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    @Override
    String toString(int start, int end) {
        try {
            return new String(this.hb, start + this.offset, end - start);
        }
        catch (StringIndexOutOfBoundsException x) {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public CharBuffer subSequence(int start, int end) {
        int pos = this.position();
        Objects.checkFromToIndex(start, end, this.limit() - pos);
        return new HeapCharBuffer(this.hb, -1, pos + start, pos + end, this.capacity(), this.offset, this.segment);
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.nativeOrder();
    }

    @Override
    ByteOrder charRegionOrder() {
        return this.order();
    }
}

