/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.HeapCharBuffer;
import java.nio.ReadOnlyBufferException;
import java.util.Objects;
import jdk.internal.access.foreign.MemorySegmentProxy;

class HeapCharBufferR
extends HeapCharBuffer {
    private static final long ARRAY_BASE_OFFSET = UNSAFE.arrayBaseOffset(char[].class);
    private static final long ARRAY_INDEX_SCALE = UNSAFE.arrayIndexScale(char[].class);

    HeapCharBufferR(int cap, int lim, MemorySegmentProxy segment) {
        super(cap, lim, segment);
        this.isReadOnly = true;
    }

    HeapCharBufferR(char[] buf, int off, int len, MemorySegmentProxy segment) {
        super(buf, off, len, segment);
        this.isReadOnly = true;
    }

    protected HeapCharBufferR(char[] buf, int mark, int pos, int lim, int cap, int off, MemorySegmentProxy segment) {
        super(buf, mark, pos, lim, cap, off, segment);
        this.isReadOnly = true;
    }

    @Override
    public CharBuffer slice() {
        int lim;
        int pos = this.position();
        int rem = pos <= (lim = this.limit()) ? lim - pos : 0;
        return new HeapCharBufferR(this.hb, -1, 0, rem, rem, pos + this.offset, this.segment);
    }

    @Override
    public CharBuffer slice(int index, int length) {
        Objects.checkFromIndexSize(index, length, this.limit());
        return new HeapCharBufferR(this.hb, -1, 0, length, length, index + this.offset, this.segment);
    }

    @Override
    public CharBuffer duplicate() {
        return new HeapCharBufferR(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset, this.segment);
    }

    @Override
    public CharBuffer asReadOnlyBuffer() {
        return this.duplicate();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public CharBuffer put(char x) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public CharBuffer put(int i, char x) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public CharBuffer put(char[] src, int offset, int length) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public CharBuffer put(CharBuffer src) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public CharBuffer put(int index, CharBuffer src, int offset, int length) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public CharBuffer put(int index, char[] src, int offset, int length) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public CharBuffer put(String src, int start, int end) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public CharBuffer compact() {
        throw new ReadOnlyBufferException();
    }

    @Override
    String toString(int start, int end) {
        try {
            return new String(this.hb, start + this.offset, end - start);
        }
        catch (StringIndexOutOfBoundsException x) {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public CharBuffer subSequence(int start, int end) {
        int pos = this.position();
        Objects.checkFromToIndex(start, end, this.limit() - pos);
        return new HeapCharBufferR(this.hb, -1, pos + start, pos + end, this.capacity(), this.offset, this.segment);
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.nativeOrder();
    }

    @Override
    ByteOrder charRegionOrder() {
        return this.order();
    }
}

