/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.HeapDoubleBuffer;
import java.nio.ReadOnlyBufferException;
import java.util.Objects;
import jdk.internal.access.foreign.MemorySegmentProxy;

class HeapDoubleBufferR
extends HeapDoubleBuffer {
    private static final long ARRAY_BASE_OFFSET = UNSAFE.arrayBaseOffset(double[].class);
    private static final long ARRAY_INDEX_SCALE = UNSAFE.arrayIndexScale(double[].class);

    HeapDoubleBufferR(int cap, int lim, MemorySegmentProxy segment) {
        super(cap, lim, segment);
        this.isReadOnly = true;
    }

    HeapDoubleBufferR(double[] buf, int off, int len, MemorySegmentProxy segment) {
        super(buf, off, len, segment);
        this.isReadOnly = true;
    }

    protected HeapDoubleBufferR(double[] buf, int mark, int pos, int lim, int cap, int off, MemorySegmentProxy segment) {
        super(buf, mark, pos, lim, cap, off, segment);
        this.isReadOnly = true;
    }

    @Override
    public DoubleBuffer slice() {
        int lim;
        int pos = this.position();
        int rem = pos <= (lim = this.limit()) ? lim - pos : 0;
        return new HeapDoubleBufferR(this.hb, -1, 0, rem, rem, pos + this.offset, this.segment);
    }

    @Override
    public DoubleBuffer slice(int index, int length) {
        Objects.checkFromIndexSize(index, length, this.limit());
        return new HeapDoubleBufferR(this.hb, -1, 0, length, length, index + this.offset, this.segment);
    }

    @Override
    public DoubleBuffer duplicate() {
        return new HeapDoubleBufferR(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset, this.segment);
    }

    @Override
    public DoubleBuffer asReadOnlyBuffer() {
        return this.duplicate();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public DoubleBuffer put(double x) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public DoubleBuffer put(int i, double x) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public DoubleBuffer put(double[] src, int offset, int length) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public DoubleBuffer put(DoubleBuffer src) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public DoubleBuffer put(int index, DoubleBuffer src, int offset, int length) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public DoubleBuffer put(int index, double[] src, int offset, int length) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public DoubleBuffer compact() {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.nativeOrder();
    }
}

