/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.HeapFloatBufferR;
import java.util.Objects;
import jdk.internal.access.foreign.MemorySegmentProxy;

class HeapFloatBuffer
extends FloatBuffer {
    private static final long ARRAY_BASE_OFFSET = UNSAFE.arrayBaseOffset(float[].class);
    private static final long ARRAY_INDEX_SCALE = UNSAFE.arrayIndexScale(float[].class);

    HeapFloatBuffer(int cap, int lim, MemorySegmentProxy segment) {
        super(-1, 0, lim, cap, new float[cap], 0, segment);
        this.address = ARRAY_BASE_OFFSET;
    }

    HeapFloatBuffer(float[] buf, int off, int len, MemorySegmentProxy segment) {
        super(-1, off, off + len, buf.length, buf, 0, segment);
        this.address = ARRAY_BASE_OFFSET;
    }

    protected HeapFloatBuffer(float[] buf, int mark, int pos, int lim, int cap, int off, MemorySegmentProxy segment) {
        super(mark, pos, lim, cap, buf, off, segment);
        this.address = ARRAY_BASE_OFFSET + (long)off * ARRAY_INDEX_SCALE;
    }

    @Override
    public FloatBuffer slice() {
        int lim;
        int pos = this.position();
        int rem = pos <= (lim = this.limit()) ? lim - pos : 0;
        return new HeapFloatBuffer(this.hb, -1, 0, rem, rem, pos + this.offset, this.segment);
    }

    @Override
    public FloatBuffer slice(int index, int length) {
        Objects.checkFromIndexSize(index, length, this.limit());
        return new HeapFloatBuffer(this.hb, -1, 0, length, length, index + this.offset, this.segment);
    }

    @Override
    public FloatBuffer duplicate() {
        return new HeapFloatBuffer(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset, this.segment);
    }

    @Override
    public FloatBuffer asReadOnlyBuffer() {
        return new HeapFloatBufferR(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset, this.segment);
    }

    protected int ix(int i) {
        return i + this.offset;
    }

    @Override
    public float get() {
        return this.hb[this.ix(this.nextGetIndex())];
    }

    @Override
    public float get(int i) {
        return this.hb[this.ix(this.checkIndex(i))];
    }

    @Override
    public FloatBuffer get(float[] dst, int offset, int length) {
        this.checkScope();
        Objects.checkFromIndexSize(offset, length, dst.length);
        int pos = this.position();
        if (length > this.limit() - pos) {
            throw new BufferUnderflowException();
        }
        System.arraycopy(this.hb, this.ix(pos), dst, offset, length);
        this.position(pos + length);
        return this;
    }

    @Override
    public FloatBuffer get(int index, float[] dst, int offset, int length) {
        this.checkScope();
        Objects.checkFromIndexSize(index, length, this.limit());
        Objects.checkFromIndexSize(offset, length, dst.length);
        System.arraycopy(this.hb, this.ix(index), dst, offset, length);
        return this;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public FloatBuffer put(float x) {
        this.hb[this.ix((int)this.nextPutIndex())] = x;
        return this;
    }

    @Override
    public FloatBuffer put(int i, float x) {
        this.hb[this.ix((int)this.checkIndex((int)i))] = x;
        return this;
    }

    @Override
    public FloatBuffer put(float[] src, int offset, int length) {
        this.checkScope();
        Objects.checkFromIndexSize(offset, length, src.length);
        int pos = this.position();
        if (length > this.limit() - pos) {
            throw new BufferOverflowException();
        }
        System.arraycopy(src, offset, this.hb, this.ix(pos), length);
        this.position(pos + length);
        return this;
    }

    @Override
    public FloatBuffer put(FloatBuffer src) {
        this.checkScope();
        super.put(src);
        return this;
    }

    @Override
    public FloatBuffer put(int index, FloatBuffer src, int offset, int length) {
        this.checkScope();
        super.put(index, src, offset, length);
        return this;
    }

    @Override
    public FloatBuffer put(int index, float[] src, int offset, int length) {
        this.checkScope();
        Objects.checkFromIndexSize(index, length, this.limit());
        Objects.checkFromIndexSize(offset, length, src.length);
        System.arraycopy(src, offset, this.hb, this.ix(index), length);
        return this;
    }

    @Override
    public FloatBuffer compact() {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        System.arraycopy(this.hb, this.ix(pos), this.hb, this.ix(0), rem);
        this.position(rem);
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.nativeOrder();
    }
}

