/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.HeapFloatBuffer;
import java.nio.ReadOnlyBufferException;
import java.util.Objects;
import jdk.internal.access.foreign.MemorySegmentProxy;

class HeapFloatBufferR
extends HeapFloatBuffer {
    private static final long ARRAY_BASE_OFFSET = UNSAFE.arrayBaseOffset(float[].class);
    private static final long ARRAY_INDEX_SCALE = UNSAFE.arrayIndexScale(float[].class);

    HeapFloatBufferR(int cap, int lim, MemorySegmentProxy segment) {
        super(cap, lim, segment);
        this.isReadOnly = true;
    }

    HeapFloatBufferR(float[] buf, int off, int len, MemorySegmentProxy segment) {
        super(buf, off, len, segment);
        this.isReadOnly = true;
    }

    protected HeapFloatBufferR(float[] buf, int mark, int pos, int lim, int cap, int off, MemorySegmentProxy segment) {
        super(buf, mark, pos, lim, cap, off, segment);
        this.isReadOnly = true;
    }

    @Override
    public FloatBuffer slice() {
        int lim;
        int pos = this.position();
        int rem = pos <= (lim = this.limit()) ? lim - pos : 0;
        return new HeapFloatBufferR(this.hb, -1, 0, rem, rem, pos + this.offset, this.segment);
    }

    @Override
    public FloatBuffer slice(int index, int length) {
        Objects.checkFromIndexSize(index, length, this.limit());
        return new HeapFloatBufferR(this.hb, -1, 0, length, length, index + this.offset, this.segment);
    }

    @Override
    public FloatBuffer duplicate() {
        return new HeapFloatBufferR(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset, this.segment);
    }

    @Override
    public FloatBuffer asReadOnlyBuffer() {
        return this.duplicate();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public FloatBuffer put(float x) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public FloatBuffer put(int i, float x) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public FloatBuffer put(float[] src, int offset, int length) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public FloatBuffer put(FloatBuffer src) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public FloatBuffer put(int index, FloatBuffer src, int offset, int length) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public FloatBuffer put(int index, float[] src, int offset, int length) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public FloatBuffer compact() {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.nativeOrder();
    }
}

