/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteOrder;
import java.nio.HeapIntBuffer;
import java.nio.IntBuffer;
import java.nio.ReadOnlyBufferException;
import java.util.Objects;
import jdk.internal.access.foreign.MemorySegmentProxy;

class HeapIntBufferR
extends HeapIntBuffer {
    private static final long ARRAY_BASE_OFFSET = UNSAFE.arrayBaseOffset(int[].class);
    private static final long ARRAY_INDEX_SCALE = UNSAFE.arrayIndexScale(int[].class);

    HeapIntBufferR(int cap, int lim, MemorySegmentProxy segment) {
        super(cap, lim, segment);
        this.isReadOnly = true;
    }

    HeapIntBufferR(int[] buf, int off, int len, MemorySegmentProxy segment) {
        super(buf, off, len, segment);
        this.isReadOnly = true;
    }

    protected HeapIntBufferR(int[] buf, int mark, int pos, int lim, int cap, int off, MemorySegmentProxy segment) {
        super(buf, mark, pos, lim, cap, off, segment);
        this.isReadOnly = true;
    }

    @Override
    public IntBuffer slice() {
        int lim;
        int pos = this.position();
        int rem = pos <= (lim = this.limit()) ? lim - pos : 0;
        return new HeapIntBufferR(this.hb, -1, 0, rem, rem, pos + this.offset, this.segment);
    }

    @Override
    public IntBuffer slice(int index, int length) {
        Objects.checkFromIndexSize(index, length, this.limit());
        return new HeapIntBufferR(this.hb, -1, 0, length, length, index + this.offset, this.segment);
    }

    @Override
    public IntBuffer duplicate() {
        return new HeapIntBufferR(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset, this.segment);
    }

    @Override
    public IntBuffer asReadOnlyBuffer() {
        return this.duplicate();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public IntBuffer put(int x) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public IntBuffer put(int i, int x) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public IntBuffer put(int[] src, int offset, int length) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public IntBuffer put(IntBuffer src) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public IntBuffer put(int index, IntBuffer src, int offset, int length) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public IntBuffer put(int index, int[] src, int offset, int length) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public IntBuffer compact() {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.nativeOrder();
    }
}

