/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.HeapLongBufferR;
import java.nio.LongBuffer;
import java.util.Objects;
import jdk.internal.access.foreign.MemorySegmentProxy;

class HeapLongBuffer
extends LongBuffer {
    private static final long ARRAY_BASE_OFFSET = UNSAFE.arrayBaseOffset(long[].class);
    private static final long ARRAY_INDEX_SCALE = UNSAFE.arrayIndexScale(long[].class);

    HeapLongBuffer(int cap, int lim, MemorySegmentProxy segment) {
        super(-1, 0, lim, cap, new long[cap], 0, segment);
        this.address = ARRAY_BASE_OFFSET;
    }

    HeapLongBuffer(long[] buf, int off, int len, MemorySegmentProxy segment) {
        super(-1, off, off + len, buf.length, buf, 0, segment);
        this.address = ARRAY_BASE_OFFSET;
    }

    protected HeapLongBuffer(long[] buf, int mark, int pos, int lim, int cap, int off, MemorySegmentProxy segment) {
        super(mark, pos, lim, cap, buf, off, segment);
        this.address = ARRAY_BASE_OFFSET + (long)off * ARRAY_INDEX_SCALE;
    }

    @Override
    public LongBuffer slice() {
        int lim;
        int pos = this.position();
        int rem = pos <= (lim = this.limit()) ? lim - pos : 0;
        return new HeapLongBuffer(this.hb, -1, 0, rem, rem, pos + this.offset, this.segment);
    }

    @Override
    public LongBuffer slice(int index, int length) {
        Objects.checkFromIndexSize(index, length, this.limit());
        return new HeapLongBuffer(this.hb, -1, 0, length, length, index + this.offset, this.segment);
    }

    @Override
    public LongBuffer duplicate() {
        return new HeapLongBuffer(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset, this.segment);
    }

    @Override
    public LongBuffer asReadOnlyBuffer() {
        return new HeapLongBufferR(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset, this.segment);
    }

    protected int ix(int i) {
        return i + this.offset;
    }

    @Override
    public long get() {
        return this.hb[this.ix(this.nextGetIndex())];
    }

    @Override
    public long get(int i) {
        return this.hb[this.ix(this.checkIndex(i))];
    }

    @Override
    public LongBuffer get(long[] dst, int offset, int length) {
        this.checkScope();
        Objects.checkFromIndexSize(offset, length, dst.length);
        int pos = this.position();
        if (length > this.limit() - pos) {
            throw new BufferUnderflowException();
        }
        System.arraycopy(this.hb, this.ix(pos), dst, offset, length);
        this.position(pos + length);
        return this;
    }

    @Override
    public LongBuffer get(int index, long[] dst, int offset, int length) {
        this.checkScope();
        Objects.checkFromIndexSize(index, length, this.limit());
        Objects.checkFromIndexSize(offset, length, dst.length);
        System.arraycopy(this.hb, this.ix(index), dst, offset, length);
        return this;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public LongBuffer put(long x) {
        this.hb[this.ix((int)this.nextPutIndex())] = x;
        return this;
    }

    @Override
    public LongBuffer put(int i, long x) {
        this.hb[this.ix((int)this.checkIndex((int)i))] = x;
        return this;
    }

    @Override
    public LongBuffer put(long[] src, int offset, int length) {
        this.checkScope();
        Objects.checkFromIndexSize(offset, length, src.length);
        int pos = this.position();
        if (length > this.limit() - pos) {
            throw new BufferOverflowException();
        }
        System.arraycopy(src, offset, this.hb, this.ix(pos), length);
        this.position(pos + length);
        return this;
    }

    @Override
    public LongBuffer put(LongBuffer src) {
        this.checkScope();
        super.put(src);
        return this;
    }

    @Override
    public LongBuffer put(int index, LongBuffer src, int offset, int length) {
        this.checkScope();
        super.put(index, src, offset, length);
        return this;
    }

    @Override
    public LongBuffer put(int index, long[] src, int offset, int length) {
        this.checkScope();
        Objects.checkFromIndexSize(index, length, this.limit());
        Objects.checkFromIndexSize(offset, length, src.length);
        System.arraycopy(src, offset, this.hb, this.ix(index), length);
        return this;
    }

    @Override
    public LongBuffer compact() {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        System.arraycopy(this.hb, this.ix(pos), this.hb, this.ix(0), rem);
        this.position(rem);
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.nativeOrder();
    }
}

