/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteOrder;
import java.nio.HeapLongBuffer;
import java.nio.LongBuffer;
import java.nio.ReadOnlyBufferException;
import java.util.Objects;
import jdk.internal.access.foreign.MemorySegmentProxy;

class HeapLongBufferR
extends HeapLongBuffer {
    private static final long ARRAY_BASE_OFFSET = UNSAFE.arrayBaseOffset(long[].class);
    private static final long ARRAY_INDEX_SCALE = UNSAFE.arrayIndexScale(long[].class);

    HeapLongBufferR(int cap, int lim, MemorySegmentProxy segment) {
        super(cap, lim, segment);
        this.isReadOnly = true;
    }

    HeapLongBufferR(long[] buf, int off, int len, MemorySegmentProxy segment) {
        super(buf, off, len, segment);
        this.isReadOnly = true;
    }

    protected HeapLongBufferR(long[] buf, int mark, int pos, int lim, int cap, int off, MemorySegmentProxy segment) {
        super(buf, mark, pos, lim, cap, off, segment);
        this.isReadOnly = true;
    }

    @Override
    public LongBuffer slice() {
        int lim;
        int pos = this.position();
        int rem = pos <= (lim = this.limit()) ? lim - pos : 0;
        return new HeapLongBufferR(this.hb, -1, 0, rem, rem, pos + this.offset, this.segment);
    }

    @Override
    public LongBuffer slice(int index, int length) {
        Objects.checkFromIndexSize(index, length, this.limit());
        return new HeapLongBufferR(this.hb, -1, 0, length, length, index + this.offset, this.segment);
    }

    @Override
    public LongBuffer duplicate() {
        return new HeapLongBufferR(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset, this.segment);
    }

    @Override
    public LongBuffer asReadOnlyBuffer() {
        return this.duplicate();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public LongBuffer put(long x) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public LongBuffer put(int i, long x) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public LongBuffer put(long[] src, int offset, int length) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public LongBuffer put(LongBuffer src) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public LongBuffer put(int index, LongBuffer src, int offset, int length) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public LongBuffer put(int index, long[] src, int offset, int length) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public LongBuffer compact() {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.nativeOrder();
    }
}

