/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.HeapShortBufferR;
import java.nio.ShortBuffer;
import java.util.Objects;
import jdk.internal.access.foreign.MemorySegmentProxy;

class HeapShortBuffer
extends ShortBuffer {
    private static final long ARRAY_BASE_OFFSET = UNSAFE.arrayBaseOffset(short[].class);
    private static final long ARRAY_INDEX_SCALE = UNSAFE.arrayIndexScale(short[].class);

    HeapShortBuffer(int cap, int lim, MemorySegmentProxy segment) {
        super(-1, 0, lim, cap, new short[cap], 0, segment);
        this.address = ARRAY_BASE_OFFSET;
    }

    HeapShortBuffer(short[] buf, int off, int len, MemorySegmentProxy segment) {
        super(-1, off, off + len, buf.length, buf, 0, segment);
        this.address = ARRAY_BASE_OFFSET;
    }

    protected HeapShortBuffer(short[] buf, int mark, int pos, int lim, int cap, int off, MemorySegmentProxy segment) {
        super(mark, pos, lim, cap, buf, off, segment);
        this.address = ARRAY_BASE_OFFSET + (long)off * ARRAY_INDEX_SCALE;
    }

    @Override
    public ShortBuffer slice() {
        int lim;
        int pos = this.position();
        int rem = pos <= (lim = this.limit()) ? lim - pos : 0;
        return new HeapShortBuffer(this.hb, -1, 0, rem, rem, pos + this.offset, this.segment);
    }

    @Override
    public ShortBuffer slice(int index, int length) {
        Objects.checkFromIndexSize(index, length, this.limit());
        return new HeapShortBuffer(this.hb, -1, 0, length, length, index + this.offset, this.segment);
    }

    @Override
    public ShortBuffer duplicate() {
        return new HeapShortBuffer(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset, this.segment);
    }

    @Override
    public ShortBuffer asReadOnlyBuffer() {
        return new HeapShortBufferR(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset, this.segment);
    }

    protected int ix(int i) {
        return i + this.offset;
    }

    @Override
    public short get() {
        return this.hb[this.ix(this.nextGetIndex())];
    }

    @Override
    public short get(int i) {
        return this.hb[this.ix(this.checkIndex(i))];
    }

    @Override
    public ShortBuffer get(short[] dst, int offset, int length) {
        this.checkScope();
        Objects.checkFromIndexSize(offset, length, dst.length);
        int pos = this.position();
        if (length > this.limit() - pos) {
            throw new BufferUnderflowException();
        }
        System.arraycopy(this.hb, this.ix(pos), dst, offset, length);
        this.position(pos + length);
        return this;
    }

    @Override
    public ShortBuffer get(int index, short[] dst, int offset, int length) {
        this.checkScope();
        Objects.checkFromIndexSize(index, length, this.limit());
        Objects.checkFromIndexSize(offset, length, dst.length);
        System.arraycopy(this.hb, this.ix(index), dst, offset, length);
        return this;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ShortBuffer put(short x) {
        this.hb[this.ix((int)this.nextPutIndex())] = x;
        return this;
    }

    @Override
    public ShortBuffer put(int i, short x) {
        this.hb[this.ix((int)this.checkIndex((int)i))] = x;
        return this;
    }

    @Override
    public ShortBuffer put(short[] src, int offset, int length) {
        this.checkScope();
        Objects.checkFromIndexSize(offset, length, src.length);
        int pos = this.position();
        if (length > this.limit() - pos) {
            throw new BufferOverflowException();
        }
        System.arraycopy(src, offset, this.hb, this.ix(pos), length);
        this.position(pos + length);
        return this;
    }

    @Override
    public ShortBuffer put(ShortBuffer src) {
        this.checkScope();
        super.put(src);
        return this;
    }

    @Override
    public ShortBuffer put(int index, ShortBuffer src, int offset, int length) {
        this.checkScope();
        super.put(index, src, offset, length);
        return this;
    }

    @Override
    public ShortBuffer put(int index, short[] src, int offset, int length) {
        this.checkScope();
        Objects.checkFromIndexSize(index, length, this.limit());
        Objects.checkFromIndexSize(offset, length, src.length);
        System.arraycopy(src, offset, this.hb, this.ix(index), length);
        return this;
    }

    @Override
    public ShortBuffer compact() {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        System.arraycopy(this.hb, this.ix(pos), this.hb, this.ix(0), rem);
        this.position(rem);
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.nativeOrder();
    }
}

