/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteOrder;
import java.nio.HeapShortBuffer;
import java.nio.ReadOnlyBufferException;
import java.nio.ShortBuffer;
import java.util.Objects;
import jdk.internal.access.foreign.MemorySegmentProxy;

class HeapShortBufferR
extends HeapShortBuffer {
    private static final long ARRAY_BASE_OFFSET = UNSAFE.arrayBaseOffset(short[].class);
    private static final long ARRAY_INDEX_SCALE = UNSAFE.arrayIndexScale(short[].class);

    HeapShortBufferR(int cap, int lim, MemorySegmentProxy segment) {
        super(cap, lim, segment);
        this.isReadOnly = true;
    }

    HeapShortBufferR(short[] buf, int off, int len, MemorySegmentProxy segment) {
        super(buf, off, len, segment);
        this.isReadOnly = true;
    }

    protected HeapShortBufferR(short[] buf, int mark, int pos, int lim, int cap, int off, MemorySegmentProxy segment) {
        super(buf, mark, pos, lim, cap, off, segment);
        this.isReadOnly = true;
    }

    @Override
    public ShortBuffer slice() {
        int lim;
        int pos = this.position();
        int rem = pos <= (lim = this.limit()) ? lim - pos : 0;
        return new HeapShortBufferR(this.hb, -1, 0, rem, rem, pos + this.offset, this.segment);
    }

    @Override
    public ShortBuffer slice(int index, int length) {
        Objects.checkFromIndexSize(index, length, this.limit());
        return new HeapShortBufferR(this.hb, -1, 0, length, length, index + this.offset, this.segment);
    }

    @Override
    public ShortBuffer duplicate() {
        return new HeapShortBufferR(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset, this.segment);
    }

    @Override
    public ShortBuffer asReadOnlyBuffer() {
        return this.duplicate();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public ShortBuffer put(short x) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ShortBuffer put(int i, short x) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ShortBuffer put(short[] src, int offset, int length) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ShortBuffer put(ShortBuffer src) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ShortBuffer put(int index, ShortBuffer src, int offset, int length) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ShortBuffer put(int index, short[] src, int offset, int length) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ShortBuffer compact() {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.nativeOrder();
    }
}

