/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.lang.ref.Reference;
import java.nio.Buffer;
import java.nio.BufferMismatch;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.HeapIntBuffer;
import java.nio.ReadOnlyBufferException;
import java.util.Objects;
import jdk.internal.access.foreign.MemorySegmentProxy;

public abstract class IntBuffer
extends Buffer
implements Comparable<IntBuffer> {
    private static final long ARRAY_BASE_OFFSET = UNSAFE.arrayBaseOffset(int[].class);
    final int[] hb;
    final int offset;
    boolean isReadOnly;

    IntBuffer(int mark, int pos, int lim, int cap, int[] hb, int offset, MemorySegmentProxy segment) {
        super(mark, pos, lim, cap, segment);
        this.hb = hb;
        this.offset = offset;
    }

    IntBuffer(int mark, int pos, int lim, int cap, MemorySegmentProxy segment) {
        this(mark, pos, lim, cap, null, 0, segment);
    }

    IntBuffer(int[] hb, long addr, int cap, MemorySegmentProxy segment) {
        super(addr, cap, segment);
        this.hb = hb;
        this.offset = 0;
    }

    @Override
    Object base() {
        return this.hb;
    }

    public static IntBuffer allocate(int capacity) {
        if (capacity < 0) {
            throw IntBuffer.createCapacityException(capacity);
        }
        return new HeapIntBuffer(capacity, capacity, null);
    }

    public static IntBuffer wrap(int[] array, int offset, int length) {
        try {
            return new HeapIntBuffer(array, offset, length, null);
        }
        catch (IllegalArgumentException x) {
            throw new IndexOutOfBoundsException();
        }
    }

    public static IntBuffer wrap(int[] array) {
        return IntBuffer.wrap(array, 0, array.length);
    }

    @Override
    public abstract IntBuffer slice();

    @Override
    public abstract IntBuffer slice(int var1, int var2);

    @Override
    public abstract IntBuffer duplicate();

    public abstract IntBuffer asReadOnlyBuffer();

    public abstract int get();

    public abstract IntBuffer put(int var1);

    public abstract int get(int var1);

    public abstract IntBuffer put(int var1, int var2);

    public IntBuffer get(int[] dst, int offset, int length) {
        Objects.checkFromIndexSize(offset, length, dst.length);
        int pos = this.position();
        if (length > this.limit() - pos) {
            throw new BufferUnderflowException();
        }
        this.getArray(pos, dst, offset, length);
        this.position(pos + length);
        return this;
    }

    public IntBuffer get(int[] dst) {
        return this.get(dst, 0, dst.length);
    }

    public IntBuffer get(int index, int[] dst, int offset, int length) {
        Objects.checkFromIndexSize(index, length, this.limit());
        Objects.checkFromIndexSize(offset, length, dst.length);
        this.getArray(index, dst, offset, length);
        return this;
    }

    public IntBuffer get(int index, int[] dst) {
        return this.get(index, dst, 0, dst.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IntBuffer getArray(int index, int[] dst, int offset, int length) {
        if ((long)length << 2 > 6L) {
            long bufAddr = this.address + ((long)index << 2);
            long dstOffset = ARRAY_BASE_OFFSET + ((long)offset << 2);
            long len = (long)length << 2;
            try {
                if (this.order() != ByteOrder.nativeOrder()) {
                    SCOPED_MEMORY_ACCESS.copySwapMemory(this.scope(), null, this.base(), bufAddr, dst, dstOffset, len, 4L);
                }
                SCOPED_MEMORY_ACCESS.copyMemory(this.scope(), null, this.base(), bufAddr, dst, dstOffset, len);
            }
            finally {
                Reference.reachabilityFence(this);
            }
        } else {
            int end = offset + length;
            int i = offset;
            int j = index;
            while (i < end) {
                dst[i] = this.get(j);
                ++i;
                ++j;
            }
        }
        return this;
    }

    public IntBuffer put(IntBuffer src) {
        int rem;
        int srcLim;
        if (src == this) {
            throw IntBuffer.createSameBufferException();
        }
        if (this.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        int srcPos = src.position();
        int srcRem = srcPos <= (srcLim = src.limit()) ? srcLim - srcPos : 0;
        int pos = this.position();
        int lim = this.limit();
        int n = rem = pos <= lim ? lim - pos : 0;
        if (srcRem > rem) {
            throw new BufferOverflowException();
        }
        this.putBuffer(pos, src, srcPos, srcRem);
        this.position(pos + srcRem);
        src.position(srcPos + srcRem);
        return this;
    }

    public IntBuffer put(int index, IntBuffer src, int offset, int length) {
        Objects.checkFromIndexSize(index, length, this.limit());
        Objects.checkFromIndexSize(offset, length, src.limit());
        if (this.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        this.putBuffer(index, src, offset, length);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putBuffer(int pos, IntBuffer src, int srcPos, int n) {
        Object srcBase = src.base();
        assert (srcBase != null || src.isDirect());
        Object base = this.base();
        assert (base != null || this.isDirect());
        long srcAddr = src.address + ((long)srcPos << 2);
        long addr = this.address + ((long)pos << 2);
        long len = (long)n << 2;
        try {
            if (this.order() != src.order()) {
                SCOPED_MEMORY_ACCESS.copySwapMemory(src.scope(), this.scope(), srcBase, srcAddr, base, addr, len, 4L);
            } else {
                SCOPED_MEMORY_ACCESS.copyMemory(src.scope(), this.scope(), srcBase, srcAddr, base, addr, len);
            }
        }
        finally {
            Reference.reachabilityFence(src);
            Reference.reachabilityFence(this);
        }
    }

    public IntBuffer put(int[] src, int offset, int length) {
        if (this.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        Objects.checkFromIndexSize(offset, length, src.length);
        int pos = this.position();
        if (length > this.limit() - pos) {
            throw new BufferOverflowException();
        }
        this.putArray(pos, src, offset, length);
        this.position(pos + length);
        return this;
    }

    public final IntBuffer put(int[] src) {
        return this.put(src, 0, src.length);
    }

    public IntBuffer put(int index, int[] src, int offset, int length) {
        if (this.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        Objects.checkFromIndexSize(index, length, this.limit());
        Objects.checkFromIndexSize(offset, length, src.length);
        this.putArray(index, src, offset, length);
        return this;
    }

    public IntBuffer put(int index, int[] src) {
        return this.put(index, src, 0, src.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IntBuffer putArray(int index, int[] src, int offset, int length) {
        if ((long)length << 2 > 6L) {
            long bufAddr = this.address + ((long)index << 2);
            long srcOffset = ARRAY_BASE_OFFSET + ((long)offset << 2);
            long len = (long)length << 2;
            try {
                if (this.order() != ByteOrder.nativeOrder()) {
                    SCOPED_MEMORY_ACCESS.copySwapMemory(null, this.scope(), src, srcOffset, this.base(), bufAddr, len, 4L);
                }
                SCOPED_MEMORY_ACCESS.copyMemory(null, this.scope(), src, srcOffset, this.base(), bufAddr, len);
            }
            finally {
                Reference.reachabilityFence(this);
            }
        } else {
            int end = offset + length;
            int i = offset;
            int j = index;
            while (i < end) {
                this.put(j, src[i]);
                ++i;
                ++j;
            }
        }
        return this;
    }

    @Override
    public final boolean hasArray() {
        return this.hb != null && !this.isReadOnly;
    }

    public final int[] array() {
        if (this.hb == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        return this.hb;
    }

    @Override
    public final int arrayOffset() {
        if (this.hb == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        return this.offset;
    }

    @Override
    public final IntBuffer position(int newPosition) {
        super.position(newPosition);
        return this;
    }

    @Override
    public final IntBuffer limit(int newLimit) {
        super.limit(newLimit);
        return this;
    }

    @Override
    public final IntBuffer mark() {
        super.mark();
        return this;
    }

    @Override
    public final IntBuffer reset() {
        super.reset();
        return this;
    }

    @Override
    public final IntBuffer clear() {
        super.clear();
        return this;
    }

    @Override
    public final IntBuffer flip() {
        super.flip();
        return this;
    }

    @Override
    public final IntBuffer rewind() {
        super.rewind();
        return this;
    }

    public abstract IntBuffer compact();

    @Override
    public abstract boolean isDirect();

    public String toString() {
        return this.getClass().getName() + "[pos=" + this.position() + " lim=" + this.limit() + " cap=" + this.capacity() + "]";
    }

    public int hashCode() {
        int h = 1;
        int p = this.position();
        for (int i = this.limit() - 1; i >= p; --i) {
            h = 31 * h + this.get(i);
        }
        return h;
    }

    public boolean equals(Object ob) {
        if (this == ob) {
            return true;
        }
        if (!(ob instanceof IntBuffer)) {
            return false;
        }
        IntBuffer that = (IntBuffer)ob;
        int thisPos = this.position();
        int thisRem = this.limit() - thisPos;
        int thatPos = that.position();
        int thatRem = that.limit() - thatPos;
        if (thisRem < 0 || thisRem != thatRem) {
            return false;
        }
        return BufferMismatch.mismatch(this, thisPos, that, thatPos, thisRem) < 0;
    }

    @Override
    public int compareTo(IntBuffer that) {
        int thisPos = this.position();
        int thisRem = this.limit() - thisPos;
        int thatPos = that.position();
        int thatRem = that.limit() - thatPos;
        int length = Math.min(thisRem, thatRem);
        if (length < 0) {
            return -1;
        }
        int i = BufferMismatch.mismatch(this, thisPos, that, thatPos, length);
        if (i >= 0) {
            return IntBuffer.compare(this.get(thisPos + i), that.get(thatPos + i));
        }
        return thisRem - thatRem;
    }

    private static int compare(int x, int y) {
        return Integer.compare(x, y);
    }

    public int mismatch(IntBuffer that) {
        int thisPos = this.position();
        int thisRem = this.limit() - thisPos;
        int thatPos = that.position();
        int thatRem = that.limit() - thatPos;
        int length = Math.min(thisRem, thatRem);
        if (length < 0) {
            return -1;
        }
        int r = BufferMismatch.mismatch(this, thisPos, that, thatPos, length);
        return r == -1 && thisRem != thatRem ? length : r;
    }

    public abstract ByteOrder order();
}

