/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.io.FileDescriptor;
import java.lang.ref.Reference;
import java.nio.ByteBuffer;
import java.util.Objects;
import jdk.internal.access.foreign.MemorySegmentProxy;
import jdk.internal.access.foreign.UnmapperProxy;
import jdk.internal.misc.ScopedMemoryAccess;
import jdk.internal.misc.Unsafe;

public abstract class MappedByteBuffer
extends ByteBuffer {
    private final FileDescriptor fd;
    private final boolean isSync;
    static final ScopedMemoryAccess SCOPED_MEMORY_ACCESS = ScopedMemoryAccess.getScopedMemoryAccess();

    MappedByteBuffer(int mark, int pos, int lim, int cap, FileDescriptor fd, boolean isSync, MemorySegmentProxy segment) {
        super(mark, pos, lim, cap, segment);
        this.fd = fd;
        this.isSync = isSync;
    }

    MappedByteBuffer(int mark, int pos, int lim, int cap, boolean isSync, MemorySegmentProxy segment) {
        super(mark, pos, lim, cap, segment);
        this.fd = null;
        this.isSync = isSync;
    }

    MappedByteBuffer(int mark, int pos, int lim, int cap, MemorySegmentProxy segment) {
        super(mark, pos, lim, cap, segment);
        this.fd = null;
        this.isSync = false;
    }

    UnmapperProxy unmapper() {
        return this.fd != null ? new UnmapperProxy(){

            @Override
            public long address() {
                return MappedByteBuffer.this.address;
            }

            @Override
            public FileDescriptor fileDescriptor() {
                return MappedByteBuffer.this.fd;
            }

            @Override
            public boolean isSync() {
                return MappedByteBuffer.this.isSync;
            }

            @Override
            public void unmap() {
                Unsafe.getUnsafe().invokeCleaner(MappedByteBuffer.this);
            }
        } : null;
    }

    final boolean isSync() {
        return this.isSync;
    }

    final FileDescriptor fileDescriptor() {
        return this.fd;
    }

    public final boolean isLoaded() {
        if (this.fd == null) {
            return true;
        }
        return SCOPED_MEMORY_ACCESS.isLoaded(this.scope(), this.address, this.isSync, this.capacity());
    }

    public final MappedByteBuffer load() {
        if (this.fd == null) {
            return this;
        }
        try {
            SCOPED_MEMORY_ACCESS.load(this.scope(), this.address, this.isSync, this.capacity());
        }
        finally {
            Reference.reachabilityFence(this);
        }
        return this;
    }

    public final MappedByteBuffer force() {
        if (this.fd == null) {
            return this;
        }
        int capacity = this.capacity();
        if (this.isSync || this.address != 0L && capacity != 0) {
            return this.force(0, capacity);
        }
        return this;
    }

    public final MappedByteBuffer force(int index, int length) {
        if (this.fd == null) {
            return this;
        }
        int capacity = this.capacity();
        if (this.address != 0L && capacity != 0) {
            Objects.checkFromIndexSize(index, length, capacity);
            SCOPED_MEMORY_ACCESS.force(this.scope(), this.fd, this.address, this.isSync, index, length);
        }
        return this;
    }

    @Override
    public final MappedByteBuffer position(int newPosition) {
        super.position(newPosition);
        return this;
    }

    @Override
    public final MappedByteBuffer limit(int newLimit) {
        super.limit(newLimit);
        return this;
    }

    @Override
    public final MappedByteBuffer mark() {
        super.mark();
        return this;
    }

    @Override
    public final MappedByteBuffer reset() {
        super.reset();
        return this;
    }

    @Override
    public final MappedByteBuffer clear() {
        super.clear();
        return this;
    }

    @Override
    public final MappedByteBuffer flip() {
        super.flip();
        return this;
    }

    @Override
    public final MappedByteBuffer rewind() {
        super.rewind();
        return this;
    }

    @Override
    public abstract MappedByteBuffer slice();

    @Override
    public abstract MappedByteBuffer slice(int var1, int var2);

    @Override
    public abstract MappedByteBuffer duplicate();

    @Override
    public abstract MappedByteBuffer compact();
}

