/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.io.FileDescriptor;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.Bits;
import jdk.internal.misc.Unsafe;

class MappedMemoryUtils {
    private static byte unused;

    MappedMemoryUtils() {
    }

    static boolean isLoaded(long address, boolean isSync, long size) {
        if (isSync) {
            return true;
        }
        if (address == 0L || size == 0L) {
            return true;
        }
        long offset = MappedMemoryUtils.mappingOffset(address);
        long length = MappedMemoryUtils.mappingLength(offset, size);
        return MappedMemoryUtils.isLoaded0(MappedMemoryUtils.mappingAddress(address, offset), length, Bits.pageCount(length));
    }

    static void load(long address, boolean isSync, long size) {
        if (isSync) {
            return;
        }
        if (address == 0L || size == 0L) {
            return;
        }
        long offset = MappedMemoryUtils.mappingOffset(address);
        long length = MappedMemoryUtils.mappingLength(offset, size);
        MappedMemoryUtils.load0(MappedMemoryUtils.mappingAddress(address, offset), length);
        Unsafe unsafe = Unsafe.getUnsafe();
        int ps = Bits.pageSize();
        long count = Bits.pageCount(length);
        long a = MappedMemoryUtils.mappingAddress(address, offset);
        byte x = 0;
        for (long i = 0L; i < count; ++i) {
            x = (byte)(x ^ unsafe.getByte(a));
            a += (long)ps;
        }
        if (unused != 0) {
            unused = x;
        }
    }

    static void unload(long address, boolean isSync, long size) {
        if (isSync) {
            return;
        }
        if (address == 0L || size == 0L) {
            return;
        }
        long offset = MappedMemoryUtils.mappingOffset(address);
        long length = MappedMemoryUtils.mappingLength(offset, size);
        MappedMemoryUtils.unload0(MappedMemoryUtils.mappingAddress(address, offset), length);
    }

    static void force(FileDescriptor fd, long address, boolean isSync, long index, long length) {
        if (isSync) {
            Unsafe.getUnsafe().writebackMemory(address + index, length);
        } else {
            long offset = MappedMemoryUtils.mappingOffset(address, index);
            try {
                MappedMemoryUtils.force0(fd, MappedMemoryUtils.mappingAddress(address, offset, index), MappedMemoryUtils.mappingLength(offset, length));
            }
            catch (IOException cause) {
                throw new UncheckedIOException(cause);
            }
        }
    }

    private static native boolean isLoaded0(long var0, long var2, long var4);

    private static native void load0(long var0, long var2);

    private static native void unload0(long var0, long var2);

    private static native void force0(FileDescriptor var0, long var1, long var3) throws IOException;

    private static long mappingOffset(long address) {
        return MappedMemoryUtils.mappingOffset(address, 0L);
    }

    private static long mappingOffset(long address, long index) {
        int ps = Bits.pageSize();
        long indexAddress = address + index;
        long baseAddress = MappedMemoryUtils.alignDown(indexAddress, ps);
        return indexAddress - baseAddress;
    }

    private static long mappingAddress(long address, long mappingOffset) {
        return MappedMemoryUtils.mappingAddress(address, mappingOffset, 0L);
    }

    private static long mappingAddress(long address, long mappingOffset, long index) {
        long indexAddress = address + index;
        return indexAddress - mappingOffset;
    }

    private static long mappingLength(long mappingOffset, long length) {
        return length + mappingOffset;
    }

    private static long alignDown(long address, int pageSize) {
        return address & (long)(~(pageSize - 1));
    }
}

