/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferMismatch;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.ReadOnlyBufferException;
import java.util.Objects;

class StringCharBuffer
extends CharBuffer {
    CharSequence str;

    StringCharBuffer(CharSequence s, int start, int end) {
        super(-1, start, end, s.length(), null);
        int n = s.length();
        Objects.checkFromToIndex(start, end, n);
        this.str = s;
        this.isReadOnly = true;
    }

    @Override
    public CharBuffer slice() {
        int lim;
        int pos = this.position();
        int rem = pos <= (lim = this.limit()) ? lim - pos : 0;
        return new StringCharBuffer(this.str, -1, 0, rem, rem, this.offset + pos);
    }

    @Override
    public CharBuffer slice(int index, int length) {
        Objects.checkFromIndexSize(index, length, this.limit());
        return new StringCharBuffer(this.str, -1, 0, length, length, this.offset + index);
    }

    private StringCharBuffer(CharSequence s, int mark, int pos, int limit, int cap, int offset) {
        super(mark, pos, limit, cap, null, offset, null);
        this.str = s;
        this.isReadOnly = true;
    }

    @Override
    public CharBuffer duplicate() {
        return new StringCharBuffer(this.str, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    @Override
    public CharBuffer asReadOnlyBuffer() {
        return this.duplicate();
    }

    @Override
    public final char get() {
        return this.str.charAt(this.nextGetIndex() + this.offset);
    }

    @Override
    public final char get(int index) {
        return this.str.charAt(this.checkIndex(index) + this.offset);
    }

    @Override
    char getUnchecked(int index) {
        return this.str.charAt(index + this.offset);
    }

    @Override
    public final CharBuffer put(char c) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public final CharBuffer put(int index, char c) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public final CharBuffer compact() {
        throw new ReadOnlyBufferException();
    }

    @Override
    public final boolean isReadOnly() {
        return true;
    }

    @Override
    final String toString(int start, int end) {
        return this.str.subSequence(start + this.offset, end + this.offset).toString();
    }

    @Override
    public final CharBuffer subSequence(int start, int end) {
        try {
            int pos = this.position();
            return new StringCharBuffer(this.str, -1, pos + this.checkIndex(start, pos), pos + this.checkIndex(end, pos), this.capacity(), this.offset);
        }
        catch (IllegalArgumentException x) {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.nativeOrder();
    }

    @Override
    ByteOrder charRegionOrder() {
        return null;
    }

    @Override
    boolean isAddressable() {
        return false;
    }

    @Override
    public boolean equals(Object ob) {
        if (this == ob) {
            return true;
        }
        if (!(ob instanceof CharBuffer)) {
            return false;
        }
        CharBuffer that = (CharBuffer)ob;
        int thisPos = this.position();
        int thisRem = this.limit() - thisPos;
        int thatPos = that.position();
        int thatRem = that.limit() - thatPos;
        if (thisRem < 0 || thisRem != thatRem) {
            return false;
        }
        return BufferMismatch.mismatch(this, thisPos, that, thatPos, thisRem) < 0;
    }

    @Override
    public int compareTo(CharBuffer that) {
        int thisPos = this.position();
        int thisRem = this.limit() - thisPos;
        int thatPos = that.position();
        int thatRem = that.limit() - thatPos;
        int length = Math.min(thisRem, thatRem);
        if (length < 0) {
            return -1;
        }
        int i = BufferMismatch.mismatch(this, thisPos, that, thatPos, length);
        if (i >= 0) {
            return Character.compare(this.get(thisPos + i), that.get(thatPos + i));
        }
        return thisRem - thatRem;
    }
}

