/*
 * Decompiled with CFR 0.152.
 */
package java.nio.file;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.ProviderNotFoundException;
import java.nio.file.spi.FileSystemProvider;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.ServiceLoader;
import jdk.internal.misc.VM;
import sun.nio.fs.DefaultFileSystemProvider;

public final class FileSystems {
    private FileSystems() {
    }

    public static FileSystem getDefault() {
        if (VM.isModuleSystemInited()) {
            return DefaultFileSystemHolder.defaultFileSystem;
        }
        return DefaultFileSystemProvider.theFileSystem();
    }

    public static FileSystem getFileSystem(URI uri) {
        String scheme = uri.getScheme();
        if (scheme == null) {
            throw new IllegalArgumentException(uri.toString());
        }
        for (FileSystemProvider provider : FileSystemProvider.installedProviders()) {
            if (!scheme.equalsIgnoreCase(provider.getScheme())) continue;
            return provider.getFileSystem(uri);
        }
        throw new ProviderNotFoundException("Provider \"" + scheme + "\" not found");
    }

    public static FileSystem newFileSystem(URI uri, Map<String, ?> env) throws IOException {
        return FileSystems.newFileSystem(uri, env, null);
    }

    public static FileSystem newFileSystem(URI uri, Map<String, ?> env, ClassLoader loader) throws IOException {
        String scheme = uri.getScheme();
        for (FileSystemProvider provider : FileSystemProvider.installedProviders()) {
            if (!scheme.equalsIgnoreCase(provider.getScheme())) continue;
            try {
                return provider.newFileSystem(uri, env);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
        }
        if (loader != null) {
            ServiceLoader<FileSystemProvider> sl = ServiceLoader.load(FileSystemProvider.class, loader);
            for (FileSystemProvider provider : sl) {
                if (!scheme.equalsIgnoreCase(provider.getScheme())) continue;
                try {
                    return provider.newFileSystem(uri, env);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                }
            }
        }
        throw new ProviderNotFoundException("Provider \"" + scheme + "\" not found");
    }

    public static FileSystem newFileSystem(Path path, ClassLoader loader) throws IOException {
        return FileSystems.newFileSystem(path, Map.of(), loader);
    }

    public static FileSystem newFileSystem(Path path, Map<String, ?> env) throws IOException {
        return FileSystems.newFileSystem(path, env, null);
    }

    public static FileSystem newFileSystem(Path path) throws IOException {
        return FileSystems.newFileSystem(path, Map.of(), null);
    }

    public static FileSystem newFileSystem(Path path, Map<String, ?> env, ClassLoader loader) throws IOException {
        if (path == null) {
            throw new NullPointerException();
        }
        for (FileSystemProvider provider : FileSystemProvider.installedProviders()) {
            try {
                return provider.newFileSystem(path, env);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
        }
        if (loader != null) {
            ServiceLoader<FileSystemProvider> sl = ServiceLoader.load(FileSystemProvider.class, loader);
            for (FileSystemProvider provider : sl) {
                try {
                    return provider.newFileSystem(path, env);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                }
            }
        }
        throw new ProviderNotFoundException("Provider not found");
    }

    private static class DefaultFileSystemHolder {
        static final FileSystem defaultFileSystem = DefaultFileSystemHolder.defaultFileSystem();

        private DefaultFileSystemHolder() {
        }

        private static FileSystem defaultFileSystem() {
            FileSystemProvider provider = AccessController.doPrivileged(new PrivilegedAction<FileSystemProvider>(){

                @Override
                public FileSystemProvider run() {
                    return DefaultFileSystemHolder.getDefaultProvider();
                }
            });
            return provider.getFileSystem(URI.create("file:///"));
        }

        private static FileSystemProvider getDefaultProvider() {
            FileSystemProvider provider = DefaultFileSystemProvider.instance();
            String prop = "java.nio.file.spi.DefaultFileSystemProvider";
            String propValue = System.getProperty(prop);
            if (propValue != null) {
                for (String cn : propValue.split(",")) {
                    try {
                        Class<?> c = Class.forName(cn, true, ClassLoader.getSystemClassLoader());
                        Constructor<?> ctor = c.getDeclaredConstructor(FileSystemProvider.class);
                        provider = (FileSystemProvider)ctor.newInstance(provider);
                        if (provider.getScheme().equals("file")) continue;
                        throw new Error("Default provider must use scheme 'file'");
                    }
                    catch (Exception x) {
                        throw new Error(x);
                    }
                }
            }
            return provider;
        }
    }
}

