/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.concurrent.ConcurrentHashMap;

final class BasicPermissionCollection
extends PermissionCollection
implements Serializable {
    private static final long serialVersionUID = 739301742472979399L;
    private transient ConcurrentHashMap<String, Permission> perms = new ConcurrentHashMap(11);
    private boolean all_allowed = false;
    private Class<?> permClass;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("permissions", Hashtable.class), new ObjectStreamField("all_allowed", Boolean.TYPE), new ObjectStreamField("permClass", Class.class)};

    public BasicPermissionCollection(Class<?> clazz) {
        this.permClass = clazz;
    }

    @Override
    public void add(Permission permission) {
        if (!(permission instanceof BasicPermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        BasicPermission basicPermission = (BasicPermission)permission;
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        if (this.permClass == null) {
            this.permClass = basicPermission.getClass();
        } else if (basicPermission.getClass() != this.permClass) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        String canonName = basicPermission.getCanonicalName();
        this.perms.put(canonName, permission);
        if (!this.all_allowed && canonName.equals("*")) {
            this.all_allowed = true;
        }
    }

    @Override
    public boolean implies(Permission permission) {
        int last;
        if (!(permission instanceof BasicPermission)) {
            return false;
        }
        BasicPermission basicPermission = (BasicPermission)permission;
        if (basicPermission.getClass() != this.permClass) {
            return false;
        }
        if (this.all_allowed) {
            return true;
        }
        String path = basicPermission.getCanonicalName();
        Permission x = this.perms.get(path);
        if (x != null) {
            return x.implies(permission);
        }
        int offset = path.length() - 1;
        while ((last = path.lastIndexOf(46, offset)) != -1) {
            x = this.perms.get(path = path.substring(0, last + 1) + "*");
            if (x != null) {
                return x.implies(permission);
            }
            offset = last - 1;
        }
        return false;
    }

    @Override
    public Enumeration<Permission> elements() {
        return this.perms.elements();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        Hashtable<String, Permission> permissions = new Hashtable<String, Permission>(this.perms.size() * 2);
        permissions.putAll(this.perms);
        ObjectOutputStream.PutField pfields = out.putFields();
        pfields.put("all_allowed", this.all_allowed);
        pfields.put("permissions", permissions);
        pfields.put("permClass", this.permClass);
        out.writeFields();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Enumeration e;
        ObjectInputStream.GetField gfields = in.readFields();
        Hashtable permissions = (Hashtable)gfields.get("permissions", null);
        this.perms = new ConcurrentHashMap(permissions.size() * 2);
        this.perms.putAll(permissions);
        this.all_allowed = gfields.get("all_allowed", false);
        this.permClass = (Class)gfields.get("permClass", null);
        if (this.permClass == null && (e = permissions.elements()).hasMoreElements()) {
            Permission p = (Permission)e.nextElement();
            this.permClass = p.getClass();
        }
    }
}

