/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.security.AllPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.PermissionsEnumerator;
import java.security.PermissionsHash;
import java.security.UnresolvedPermission;
import java.security.UnresolvedPermissionCollection;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class Permissions
extends PermissionCollection
implements Serializable {
    private transient ConcurrentHashMap<Class<?>, PermissionCollection> permsMap = new ConcurrentHashMap(11);
    private transient boolean hasUnresolved = false;
    PermissionCollection allPermission = null;
    private static final long serialVersionUID = 4858622370623524688L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("perms", Hashtable.class), new ObjectStreamField("allPermission", PermissionCollection.class)};

    @Override
    public void add(Permission permission) {
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly Permissions object");
        }
        PermissionCollection pc = this.getPermissionCollection(permission, true);
        pc.add(permission);
        if (permission instanceof AllPermission) {
            this.allPermission = pc;
        }
        if (permission instanceof UnresolvedPermission) {
            this.hasUnresolved = true;
        }
    }

    @Override
    public boolean implies(Permission permission) {
        if (this.allPermission != null) {
            return true;
        }
        PermissionCollection pc = this.getPermissionCollection(permission, false);
        if (pc != null) {
            return pc.implies(permission);
        }
        return false;
    }

    @Override
    public Enumeration<Permission> elements() {
        return new PermissionsEnumerator(this.permsMap.values().iterator());
    }

    private PermissionCollection getPermissionCollection(Permission p, boolean createEmpty) {
        PermissionCollection pc = this.permsMap.get(p.getClass());
        if (!this.hasUnresolved && !createEmpty || pc != null) {
            return pc;
        }
        return this.createPermissionCollection(p, createEmpty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PermissionCollection createPermissionCollection(Permission p, boolean createEmpty) {
        ConcurrentHashMap<Class<?>, PermissionCollection> concurrentHashMap = this.permsMap;
        synchronized (concurrentHashMap) {
            PermissionCollection oldPc;
            Class<?> c = p.getClass();
            PermissionCollection pc = this.permsMap.get(c);
            if (pc != null) {
                return pc;
            }
            PermissionCollection permissionCollection = pc = this.hasUnresolved ? this.getUnresolvedPermissions(p) : null;
            if (pc == null && createEmpty && (pc = p.newPermissionCollection()) == null) {
                pc = new PermissionsHash();
            }
            if (pc != null && (oldPc = this.permsMap.putIfAbsent(c, pc)) != null) {
                pc = oldPc;
            }
            return pc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PermissionCollection getUnresolvedPermissions(Permission p) {
        UnresolvedPermissionCollection uc = (UnresolvedPermissionCollection)this.permsMap.get(UnresolvedPermission.class);
        if (uc == null) {
            return null;
        }
        List<UnresolvedPermission> unresolvedPerms = uc.getUnresolvedPermissions(p);
        if (unresolvedPerms == null) {
            return null;
        }
        Certificate[] certs = null;
        Object[] signers = p.getClass().getSigners();
        int n = 0;
        if (signers != null) {
            int j;
            for (j = 0; j < signers.length; ++j) {
                if (!(signers[j] instanceof Certificate)) continue;
                ++n;
            }
            certs = new Certificate[n];
            n = 0;
            for (j = 0; j < signers.length; ++j) {
                if (!(signers[j] instanceof Certificate)) continue;
                certs[n++] = (Certificate)signers[j];
            }
        }
        PermissionCollection pc = null;
        List<UnresolvedPermission> list = unresolvedPerms;
        synchronized (list) {
            int len = unresolvedPerms.size();
            for (int i = 0; i < len; ++i) {
                UnresolvedPermission up = unresolvedPerms.get(i);
                Permission perm = up.resolve(p, certs);
                if (perm == null) continue;
                if (pc == null && (pc = p.newPermissionCollection()) == null) {
                    pc = new PermissionsHash();
                }
                pc.add(perm);
            }
        }
        return pc;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        Hashtable perms = new Hashtable(this.permsMap.size() * 2);
        perms.putAll(this.permsMap);
        ObjectOutputStream.PutField pfields = out.putFields();
        pfields.put("allPermission", this.allPermission);
        pfields.put("perms", perms);
        out.writeFields();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField gfields = in.readFields();
        this.allPermission = (PermissionCollection)gfields.get("allPermission", null);
        Hashtable perms = (Hashtable)gfields.get("perms", null);
        this.permsMap = new ConcurrentHashMap(perms.size() * 2);
        this.permsMap.putAll(perms);
        for (Map.Entry e : perms.entrySet()) {
            Class k = (Class)e.getKey();
            PermissionCollection v = (PermissionCollection)e.getValue();
            Enumeration<Permission> en = v.elements();
            while (en.hasMoreElements()) {
                Permission p = en.nextElement();
                if (k.equals(p.getClass())) continue;
                throw new InvalidObjectException("Permission with class " + k + " incorrectly mapped to PermissionCollection containing Permission with " + p.getClass());
            }
        }
        UnresolvedPermissionCollection uc = (UnresolvedPermissionCollection)this.permsMap.get(UnresolvedPermission.class);
        this.hasUnresolved = uc != null && uc.elements().hasMoreElements();
    }
}

