/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

final class PermissionsHash
extends PermissionCollection
implements Serializable {
    private transient ConcurrentHashMap<Permission, Permission> permsMap = new ConcurrentHashMap(11);
    private static final long serialVersionUID = -8491988220802933440L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("perms", Hashtable.class)};

    PermissionsHash() {
    }

    @Override
    public void add(Permission permission) {
        this.permsMap.put(permission, permission);
    }

    @Override
    public boolean implies(Permission permission) {
        Permission p = this.permsMap.get(permission);
        if (p == null) {
            for (Permission p_ : this.permsMap.values()) {
                if (!p_.implies(permission)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public Enumeration<Permission> elements() {
        return this.permsMap.elements();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        Hashtable<Permission, Permission> perms = new Hashtable<Permission, Permission>(this.permsMap.size() * 2);
        perms.putAll(this.permsMap);
        ObjectOutputStream.PutField pfields = out.putFields();
        pfields.put("perms", perms);
        out.writeFields();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField gfields = in.readFields();
        Hashtable perms = (Hashtable)gfields.get("perms", null);
        this.permsMap = new ConcurrentHashMap(perms.size() * 2);
        this.permsMap.putAll(perms);
        for (Map.Entry e : perms.entrySet()) {
            Permission v;
            Permission k = (Permission)e.getKey();
            if (k == (v = (Permission)e.getValue())) continue;
            throw new InvalidObjectException("Permission (" + k + ") incorrectly mapped to Permission (" + v + ")");
        }
    }
}

