/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import jdk.internal.access.JavaSecurityAccess;
import jdk.internal.access.SharedSecrets;
import sun.security.action.GetPropertyAction;
import sun.security.provider.PolicyFile;
import sun.security.util.Debug;
import sun.security.util.FilePermCompat;
import sun.security.util.SecurityConstants;

public class ProtectionDomain {
    private static final boolean filePermCompatInPD = "true".equals(GetPropertyAction.privilegedGetProperty("jdk.security.filePermCompat"));
    private CodeSource codesource;
    private ClassLoader classloader;
    private Principal[] principals;
    private PermissionCollection permissions;
    private boolean hasAllPerm = false;
    private final boolean staticPermissions;
    final Key key = new Key();

    public ProtectionDomain(CodeSource codesource, PermissionCollection permissions) {
        this.codesource = codesource;
        if (permissions != null) {
            this.permissions = permissions;
            this.permissions.setReadOnly();
            if (permissions instanceof Permissions && ((Permissions)permissions).allPermission != null) {
                this.hasAllPerm = true;
            }
        }
        this.classloader = null;
        this.principals = new Principal[0];
        this.staticPermissions = true;
    }

    public ProtectionDomain(CodeSource codesource, PermissionCollection permissions, ClassLoader classloader, Principal[] principals) {
        this.codesource = codesource;
        if (permissions != null) {
            this.permissions = permissions;
            this.permissions.setReadOnly();
            if (permissions instanceof Permissions && ((Permissions)permissions).allPermission != null) {
                this.hasAllPerm = true;
            }
        }
        this.classloader = classloader;
        this.principals = principals != null ? (Principal[])principals.clone() : new Principal[]{};
        this.staticPermissions = false;
    }

    public final CodeSource getCodeSource() {
        return this.codesource;
    }

    public final ClassLoader getClassLoader() {
        return this.classloader;
    }

    public final Principal[] getPrincipals() {
        return (Principal[])this.principals.clone();
    }

    public final PermissionCollection getPermissions() {
        return this.permissions;
    }

    public final boolean staticPermissionsOnly() {
        return this.staticPermissions;
    }

    public boolean implies(Permission perm) {
        if (this.hasAllPerm) {
            return true;
        }
        if (!this.staticPermissions && Policy.getPolicyNoCheck().implies(this, perm)) {
            return true;
        }
        if (this.permissions != null) {
            return this.permissions.implies(perm);
        }
        return false;
    }

    boolean impliesWithAltFilePerm(Permission perm) {
        if (!filePermCompatInPD || !FilePermCompat.compat || this.getClass() != ProtectionDomain.class) {
            return this.implies(perm);
        }
        if (this.hasAllPerm) {
            return true;
        }
        Permission p2 = null;
        boolean p2Calculated = false;
        if (!this.staticPermissions) {
            Policy policy = Policy.getPolicyNoCheck();
            if (policy instanceof PolicyFile) {
                return policy.implies(this, perm);
            }
            if (policy.implies(this, perm)) {
                return true;
            }
            p2 = FilePermCompat.newPermUsingAltPath(perm);
            p2Calculated = true;
            if (p2 != null && policy.implies(this, p2)) {
                return true;
            }
        }
        if (this.permissions != null) {
            if (this.permissions.implies(perm)) {
                return true;
            }
            if (!p2Calculated) {
                p2 = FilePermCompat.newPermUsingAltPath(perm);
            }
            if (p2 != null) {
                return this.permissions.implies(p2);
            }
        }
        return false;
    }

    public String toString() {
        String pals = "<no principals>";
        if (this.principals != null && this.principals.length > 0) {
            StringBuilder palBuf = new StringBuilder("(principals ");
            for (int i = 0; i < this.principals.length; ++i) {
                palBuf.append(this.principals[i].getClass().getName() + " \"" + this.principals[i].getName() + "\"");
                if (i < this.principals.length - 1) {
                    palBuf.append(",\n");
                    continue;
                }
                palBuf.append(")\n");
            }
            pals = palBuf.toString();
        }
        PermissionCollection pc = Policy.isSet() && ProtectionDomain.seeAllp() ? this.mergePermissions() : this.getPermissions();
        return "ProtectionDomain  " + this.codesource + "\n " + this.classloader + "\n " + pals + "\n " + pc + "\n";
    }

    private static boolean seeAllp() {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return true;
        }
        if (DebugHolder.debug != null) {
            if (sm.getClass().getClassLoader() == null && Policy.getPolicyNoCheck().getClass().getClassLoader() == null) {
                return true;
            }
        } else {
            try {
                sm.checkPermission(SecurityConstants.GET_POLICY_PERMISSION);
                return true;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PermissionCollection mergePermissions() {
        Enumeration<Permission> e;
        PermissionCollection permissionCollection;
        if (this.staticPermissions) {
            return this.permissions;
        }
        PermissionCollection perms = AccessController.doPrivileged(new PrivilegedAction<PermissionCollection>(){

            @Override
            public PermissionCollection run() {
                Policy p = Policy.getPolicyNoCheck();
                return p.getPermissions(ProtectionDomain.this);
            }
        });
        Permissions mergedPerms = new Permissions();
        int swag = 32;
        int vcap = 8;
        ArrayList<Permission> pdVector = new ArrayList<Permission>(vcap);
        ArrayList<Permission> plVector = new ArrayList<Permission>(swag);
        if (this.permissions != null) {
            permissionCollection = this.permissions;
            synchronized (permissionCollection) {
                e = this.permissions.elements();
                while (e.hasMoreElements()) {
                    pdVector.add(e.nextElement());
                }
            }
        }
        if (perms != null) {
            permissionCollection = perms;
            synchronized (permissionCollection) {
                e = perms.elements();
                while (e.hasMoreElements()) {
                    plVector.add(e.nextElement());
                    ++vcap;
                }
            }
        }
        if (perms != null && this.permissions != null) {
            permissionCollection = this.permissions;
            synchronized (permissionCollection) {
                e = this.permissions.elements();
                block11: while (e.hasMoreElements()) {
                    Permission pdp = e.nextElement();
                    Class<?> pdpClass = pdp.getClass();
                    String pdpActions = pdp.getActions();
                    String pdpName = pdp.getName();
                    for (int i = 0; i < plVector.size(); ++i) {
                        Permission pp = (Permission)plVector.get(i);
                        if (!pdpClass.isInstance(pp) || !pdpName.equals(pp.getName()) || !Objects.equals(pdpActions, pp.getActions())) continue;
                        plVector.remove(i);
                        continue block11;
                    }
                }
            }
        }
        if (perms != null) {
            for (int i = plVector.size() - 1; i >= 0; --i) {
                mergedPerms.add((Permission)plVector.get(i));
            }
        }
        if (this.permissions != null) {
            for (int i = pdVector.size() - 1; i >= 0; --i) {
                mergedPerms.add((Permission)pdVector.get(i));
            }
        }
        return mergedPerms;
    }

    static {
        SharedSecrets.setJavaSecurityAccess(new JavaSecurityAccessImpl());
    }

    static final class Key {
        Key() {
        }
    }

    private static class DebugHolder {
        private static final Debug debug = Debug.getInstance("domain");

        private DebugHolder() {
        }
    }

    private static class JavaSecurityAccessImpl
    implements JavaSecurityAccess {
        private JavaSecurityAccessImpl() {
        }

        @Override
        public <T> T doIntersectionPrivilege(PrivilegedAction<T> action, AccessControlContext stack, AccessControlContext context) {
            if (action == null) {
                throw new NullPointerException();
            }
            return AccessController.doPrivileged(action, JavaSecurityAccessImpl.getCombinedACC(context, stack));
        }

        @Override
        public <T> T doIntersectionPrivilege(PrivilegedAction<T> action, AccessControlContext context) {
            return this.doIntersectionPrivilege(action, AccessController.getContext(), context);
        }

        @Override
        public ProtectionDomain[] getProtectDomains(AccessControlContext context) {
            return context.getContext();
        }

        private static AccessControlContext getCombinedACC(AccessControlContext context, AccessControlContext stack) {
            AccessControlContext acc = new AccessControlContext(context, stack.getCombiner(), true);
            return new AccessControlContext(stack.getContext(), acc).optimize();
        }

        @Override
        public JavaSecurityAccess.ProtectionDomainCache getProtectionDomainCache() {
            return new JavaSecurityAccess.ProtectionDomainCache(){
                private final Map<Key, PermissionCollection> map = Collections.synchronizedMap(new WeakHashMap());

                @Override
                public void put(ProtectionDomain pd, PermissionCollection pc) {
                    this.map.put(pd == null ? null : pd.key, pc);
                }

                @Override
                public PermissionCollection get(ProtectionDomain pd) {
                    return pd == null ? this.map.get(null) : this.map.get(pd.key);
                }
            };
        }
    }
}

