/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.nio.ByteBuffer;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.ProtectionDomain;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import sun.security.util.Debug;

public class SecureClassLoader
extends ClassLoader {
    private final Map<CodeSourceKey, ProtectionDomain> pdcache = new ConcurrentHashMap<CodeSourceKey, ProtectionDomain>(11);

    protected SecureClassLoader(ClassLoader parent) {
        super(parent);
    }

    protected SecureClassLoader() {
    }

    protected SecureClassLoader(String name, ClassLoader parent) {
        super(name, parent);
    }

    protected final Class<?> defineClass(String name, byte[] b, int off, int len, CodeSource cs) {
        return this.defineClass(name, b, off, len, this.getProtectionDomain(cs));
    }

    protected final Class<?> defineClass(String name, ByteBuffer b, CodeSource cs) {
        return this.defineClass(name, b, this.getProtectionDomain(cs));
    }

    protected PermissionCollection getPermissions(CodeSource codesource) {
        return new Permissions();
    }

    private ProtectionDomain getProtectionDomain(final CodeSource cs) {
        if (cs == null) {
            return null;
        }
        CodeSourceKey key = new CodeSourceKey(cs);
        return this.pdcache.computeIfAbsent(key, new Function<CodeSourceKey, ProtectionDomain>(){

            @Override
            public ProtectionDomain apply(CodeSourceKey key) {
                PermissionCollection perms = SecureClassLoader.this.getPermissions(cs);
                ProtectionDomain pd = new ProtectionDomain(cs, perms, SecureClassLoader.this, null);
                if (DebugHolder.debug != null) {
                    DebugHolder.debug.println(" getPermissions " + pd);
                    DebugHolder.debug.println("");
                }
                return pd;
            }
        });
    }

    private void resetArchivedStates() {
        this.pdcache.clear();
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }

    private static class CodeSourceKey {
        private final CodeSource cs;

        CodeSourceKey(CodeSource cs) {
            this.cs = cs;
        }

        public int hashCode() {
            String locationNoFrag = this.cs.getLocationNoFragString();
            return locationNoFrag != null ? locationNoFrag.hashCode() : 0;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof CodeSourceKey)) return false;
            CodeSourceKey other = (CodeSourceKey)obj;
            if (!Objects.equals(this.cs.getLocationNoFragString(), other.cs.getLocationNoFragString())) return false;
            if (!this.cs.matchCerts(other.cs, true)) return false;
            return true;
        }
    }

    private static class DebugHolder {
        private static final Debug debug = Debug.getInstance("scl");

        private DebugHolder() {
        }
    }
}

