/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.UnresolvedPermissionCollection;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Hashtable;
import sun.security.util.Debug;
import sun.security.util.IOUtils;

public final class UnresolvedPermission
extends Permission
implements Serializable {
    private static final long serialVersionUID = -4821973115467008846L;
    private static final Debug debug = Debug.getInstance("policy,access", "UnresolvedPermission");
    private String type;
    private String name;
    private String actions;
    private transient Certificate[] certs;
    private static final Class<?>[] PARAMS0 = new Class[0];
    private static final Class<?>[] PARAMS1 = new Class[]{String.class};
    private static final Class<?>[] PARAMS2 = new Class[]{String.class, String.class};

    public UnresolvedPermission(String type, String name, String actions, Certificate[] certs) {
        super(type);
        if (type == null) {
            throw new NullPointerException("type can't be null");
        }
        this.type = type;
        this.name = name;
        this.actions = actions;
        if (certs != null) {
            int i;
            for (i = 0; i < certs.length; ++i) {
                if (certs[i] instanceof X509Certificate) continue;
                this.certs = (Certificate[])certs.clone();
                break;
            }
            if (this.certs == null) {
                int count = 0;
                for (i = 0; i < certs.length; ++i) {
                    ++count;
                    while (i + 1 < certs.length && ((X509Certificate)certs[i]).getIssuerX500Principal().equals(((X509Certificate)certs[i + 1]).getSubjectX500Principal())) {
                        ++i;
                    }
                }
                if (count == certs.length) {
                    this.certs = (Certificate[])certs.clone();
                }
                if (this.certs == null) {
                    ArrayList<Certificate> signerCerts = new ArrayList<Certificate>();
                    for (i = 0; i < certs.length; ++i) {
                        signerCerts.add(certs[i]);
                        while (i + 1 < certs.length && ((X509Certificate)certs[i]).getIssuerX500Principal().equals(((X509Certificate)certs[i + 1]).getSubjectX500Principal())) {
                            ++i;
                        }
                    }
                    this.certs = new Certificate[signerCerts.size()];
                    signerCerts.toArray(this.certs);
                }
            }
        }
    }

    Permission resolve(Permission p, Certificate[] certs) {
        if (this.certs != null) {
            if (certs == null) {
                return null;
            }
            for (int i = 0; i < this.certs.length; ++i) {
                boolean match = false;
                for (int j = 0; j < certs.length; ++j) {
                    if (!this.certs[i].equals(certs[j])) continue;
                    match = true;
                    break;
                }
                if (match) continue;
                return null;
            }
        }
        try {
            Class<?> pc = p.getClass();
            if (this.name == null && this.actions == null) {
                try {
                    Constructor<?> c = pc.getConstructor(PARAMS0);
                    return (Permission)c.newInstance(new Object[0]);
                }
                catch (NoSuchMethodException ne) {
                    try {
                        Constructor<?> c = pc.getConstructor(PARAMS1);
                        return (Permission)c.newInstance(this.name);
                    }
                    catch (NoSuchMethodException ne1) {
                        Constructor<?> c = pc.getConstructor(PARAMS2);
                        return (Permission)c.newInstance(this.name, this.actions);
                    }
                }
            }
            if (this.name != null && this.actions == null) {
                try {
                    Constructor<?> c = pc.getConstructor(PARAMS1);
                    return (Permission)c.newInstance(this.name);
                }
                catch (NoSuchMethodException ne) {
                    Constructor<?> c = pc.getConstructor(PARAMS2);
                    return (Permission)c.newInstance(this.name, this.actions);
                }
            }
            Constructor<?> c = pc.getConstructor(PARAMS2);
            return (Permission)c.newInstance(this.name, this.actions);
        }
        catch (NoSuchMethodException nsme) {
            if (debug != null) {
                debug.println("NoSuchMethodException:\n  could not find proper constructor for " + this.type);
                nsme.printStackTrace();
            }
            return null;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.println("unable to instantiate " + this.name);
                e.printStackTrace();
            }
            return null;
        }
    }

    @Override
    public boolean implies(Permission p) {
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        int j;
        boolean match;
        int i;
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof UnresolvedPermission)) {
            return false;
        }
        UnresolvedPermission that = (UnresolvedPermission)obj;
        if (!this.type.equals(that.type)) {
            return false;
        }
        if (this.name == null ? that.name != null : !this.name.equals(that.name)) {
            return false;
        }
        if (this.actions == null ? that.actions != null : !this.actions.equals(that.actions)) {
            return false;
        }
        if (this.certs == null && that.certs != null || this.certs != null && that.certs == null || this.certs != null && that.certs != null && this.certs.length != that.certs.length) {
            return false;
        }
        for (i = 0; this.certs != null && i < this.certs.length; ++i) {
            match = false;
            for (j = 0; j < that.certs.length; ++j) {
                if (!this.certs[i].equals(that.certs[j])) continue;
                match = true;
                break;
            }
            if (match) continue;
            return false;
        }
        for (i = 0; that.certs != null && i < that.certs.length; ++i) {
            match = false;
            for (j = 0; j < this.certs.length; ++j) {
                if (!that.certs[i].equals(this.certs[j])) continue;
                match = true;
                break;
            }
            if (match) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hash = this.type.hashCode();
        if (this.name != null) {
            hash ^= this.name.hashCode();
        }
        if (this.actions != null) {
            hash ^= this.actions.hashCode();
        }
        return hash;
    }

    @Override
    public String getActions() {
        return "";
    }

    public String getUnresolvedType() {
        return this.type;
    }

    public String getUnresolvedName() {
        return this.name;
    }

    public String getUnresolvedActions() {
        return this.actions;
    }

    public Certificate[] getUnresolvedCerts() {
        return this.certs == null ? null : (Certificate[])this.certs.clone();
    }

    @Override
    public String toString() {
        return "(unresolved " + this.type + " " + this.name + " " + this.actions + ")";
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return new UnresolvedPermissionCollection();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        if (this.certs == null || this.certs.length == 0) {
            oos.writeInt(0);
        } else {
            oos.writeInt(this.certs.length);
            for (int i = 0; i < this.certs.length; ++i) {
                Certificate cert = this.certs[i];
                try {
                    oos.writeUTF(cert.getType());
                    byte[] encoded = cert.getEncoded();
                    oos.writeInt(encoded.length);
                    oos.write(encoded);
                    continue;
                }
                catch (CertificateEncodingException cee) {
                    throw new IOException(cee.getMessage());
                }
            }
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        Hashtable<String, CertificateFactory> cfs = null;
        ArrayList<Certificate> certList = null;
        ois.defaultReadObject();
        if (this.type == null) {
            throw new NullPointerException("type can't be null");
        }
        int size = ois.readInt();
        if (size > 0) {
            cfs = new Hashtable<String, CertificateFactory>(3);
            certList = new ArrayList<Certificate>(size > 20 ? 20 : size);
        } else if (size < 0) {
            throw new IOException("size cannot be negative");
        }
        for (int i = 0; i < size; ++i) {
            CertificateFactory cf;
            String certType = ois.readUTF();
            if (cfs.containsKey(certType)) {
                cf = (CertificateFactory)cfs.get(certType);
            } else {
                try {
                    cf = CertificateFactory.getInstance(certType);
                }
                catch (CertificateException ce) {
                    throw new ClassNotFoundException("Certificate factory for " + certType + " not found");
                }
                cfs.put(certType, cf);
            }
            byte[] encoded = IOUtils.readExactlyNBytes(ois, ois.readInt());
            ByteArrayInputStream bais = new ByteArrayInputStream(encoded);
            try {
                certList.add(cf.generateCertificate(bais));
            }
            catch (CertificateException ce) {
                throw new IOException(ce.getMessage());
            }
            bais.close();
        }
        if (certList != null) {
            this.certs = certList.toArray(new Certificate[size]);
        }
    }
}

