/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.UnresolvedPermission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiFunction;

final class UnresolvedPermissionCollection
extends PermissionCollection
implements Serializable {
    private transient ConcurrentHashMap<String, List<UnresolvedPermission>> perms = new ConcurrentHashMap(11);
    private static final long serialVersionUID = -7176153071733132400L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("permissions", Hashtable.class)};

    @Override
    public void add(Permission permission) {
        if (!(permission instanceof UnresolvedPermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        final UnresolvedPermission unresolvedPermission = (UnresolvedPermission)permission;
        this.perms.compute(unresolvedPermission.getName(), new BiFunction<String, List<UnresolvedPermission>, List<UnresolvedPermission>>(){

            @Override
            public List<UnresolvedPermission> apply(String key, List<UnresolvedPermission> oldValue) {
                if (oldValue == null) {
                    CopyOnWriteArrayList<UnresolvedPermission> v = new CopyOnWriteArrayList<UnresolvedPermission>();
                    v.add(unresolvedPermission);
                    return v;
                }
                oldValue.add(unresolvedPermission);
                return oldValue;
            }
        });
    }

    List<UnresolvedPermission> getUnresolvedPermissions(Permission p) {
        return this.perms.get(p.getClass().getName());
    }

    @Override
    public boolean implies(Permission permission) {
        return false;
    }

    @Override
    public Enumeration<Permission> elements() {
        ArrayList<UnresolvedPermission> results = new ArrayList<UnresolvedPermission>();
        for (List<UnresolvedPermission> l : this.perms.values()) {
            results.addAll(l);
        }
        return Collections.enumeration(results);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        Hashtable<String, Vector<UnresolvedPermission>> permissions = new Hashtable<String, Vector<UnresolvedPermission>>(this.perms.size() * 2);
        Set<Map.Entry<String, List<UnresolvedPermission>>> set = this.perms.entrySet();
        for (Map.Entry<String, List<UnresolvedPermission>> e : set) {
            List<UnresolvedPermission> list = e.getValue();
            Vector<UnresolvedPermission> vec = new Vector<UnresolvedPermission>(list);
            permissions.put(e.getKey(), vec);
        }
        ObjectOutputStream.PutField pfields = out.putFields();
        pfields.put("permissions", permissions);
        out.writeFields();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField gfields = in.readFields();
        Hashtable permissions = (Hashtable)gfields.get("permissions", null);
        this.perms = new ConcurrentHashMap(permissions.size() * 2);
        Set set = permissions.entrySet();
        for (Map.Entry e : set) {
            Vector vec = (Vector)e.getValue();
            CopyOnWriteArrayList list = new CopyOnWriteArrayList(vec);
            this.perms.put((String)e.getKey(), list);
        }
    }
}

