/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.Provider;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.Arrays;
import java.util.Date;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import sun.security.util.SignatureUtil;
import sun.security.x509.X509CRLImpl;

public abstract class X509CRL
extends CRL
implements X509Extension {
    private transient X500Principal issuerPrincipal;

    protected X509CRL() {
        super("X.509");
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof X509CRL)) {
            return false;
        }
        try {
            byte[] thisCRL = X509CRLImpl.getEncodedInternal(this);
            byte[] otherCRL = X509CRLImpl.getEncodedInternal((X509CRL)other);
            return Arrays.equals(thisCRL, otherCRL);
        }
        catch (CRLException e) {
            return false;
        }
    }

    public int hashCode() {
        int retval = 0;
        try {
            byte[] crlData = X509CRLImpl.getEncodedInternal(this);
            for (int i = 1; i < crlData.length; ++i) {
                retval += crlData[i] * i;
            }
            return retval;
        }
        catch (CRLException e) {
            return retval;
        }
    }

    public abstract byte[] getEncoded() throws CRLException;

    public abstract void verify(PublicKey var1) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException;

    public abstract void verify(PublicKey var1, String var2) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException;

    public void verify(PublicKey key, Provider sigProvider) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        String sigAlgName = this.getSigAlgName();
        Signature sig = sigProvider == null ? Signature.getInstance(sigAlgName) : Signature.getInstance(sigAlgName, sigProvider);
        try {
            byte[] paramBytes = this.getSigAlgParams();
            SignatureUtil.initVerifyWithParam(sig, key, SignatureUtil.getParamSpec(sigAlgName, paramBytes));
        }
        catch (ProviderException e) {
            throw new CRLException(e.getMessage(), e.getCause());
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new CRLException(e);
        }
        byte[] tbsCRL = this.getTBSCertList();
        sig.update(tbsCRL, 0, tbsCRL.length);
        if (!sig.verify(this.getSignature())) {
            throw new SignatureException("Signature does not match.");
        }
    }

    public abstract int getVersion();

    @Deprecated(since="16")
    public abstract Principal getIssuerDN();

    public X500Principal getIssuerX500Principal() {
        if (this.issuerPrincipal == null) {
            this.issuerPrincipal = X509CRLImpl.getIssuerX500Principal(this);
        }
        return this.issuerPrincipal;
    }

    public abstract Date getThisUpdate();

    public abstract Date getNextUpdate();

    public abstract X509CRLEntry getRevokedCertificate(BigInteger var1);

    public X509CRLEntry getRevokedCertificate(X509Certificate certificate) {
        X500Principal crlIssuer;
        X500Principal certIssuer = certificate.getIssuerX500Principal();
        if (!certIssuer.equals(crlIssuer = this.getIssuerX500Principal())) {
            return null;
        }
        return this.getRevokedCertificate(certificate.getSerialNumber());
    }

    public abstract Set<? extends X509CRLEntry> getRevokedCertificates();

    public abstract byte[] getTBSCertList() throws CRLException;

    public abstract byte[] getSignature();

    public abstract String getSigAlgName();

    public abstract String getSigAlgOID();

    public abstract byte[] getSigAlgParams();
}

