/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.AttributedCharacterIterator;
import java.text.CharacterIteratorFieldDelegate;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.DigitList;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class CompactNumberFormat
extends NumberFormat {
    private static final long serialVersionUID = 7128367218649234678L;
    private String[] compactPatterns;
    private transient List<Patterns> positivePrefixPatterns;
    private transient List<Patterns> negativePrefixPatterns;
    private transient List<Patterns> positiveSuffixPatterns;
    private transient List<Patterns> negativeSuffixPatterns;
    private transient List<Number> divisors;
    private transient List<Patterns> placeHolderPatterns;
    private DecimalFormatSymbols symbols;
    private final String decimalPattern;
    private transient DecimalFormat decimalFormat;
    private transient DecimalFormat defaultDecimalFormat;
    private byte groupingSize = 0;
    private boolean parseBigDecimal = false;
    private RoundingMode roundingMode = RoundingMode.HALF_EVEN;
    private String pluralRules = "";
    private transient Map<String, String> rulesMap;
    private static final String SPECIAL_PATTERN = "0";
    private static final int RANGE_MULTIPLIER = 10;
    private static final Pattern PLURALS = Pattern.compile("^\\{(?<plurals>.*)}$");
    private static final Pattern COUNT_PATTERN = Pattern.compile("(zero|one|two|few|many|other):((' '|[^ ])+)[ ]*");
    private static final String EXPR = "([niftvwe])\\s*(([/%])\\s*(\\d+))*";
    private static final String RELATION = "(!?=)";
    private static final String VALUE_RANGE = "((\\d+)\\.\\.(\\d+)|\\d+)";
    private static final String CONDITION = "([niftvwe])\\s*(([/%])\\s*(\\d+))*\\s*(!?=)\\s*((\\d+)\\.\\.(\\d+)|\\d+)\\s*(,\\s*((\\d+)\\.\\.(\\d+)|\\d+))*";
    private static final Pattern PLURALRULES_PATTERN = Pattern.compile("(zero|one|two|few|many):\\s*([niftvwe])\\s*(([/%])\\s*(\\d+))*\\s*(!?=)\\s*((\\d+)\\.\\.(\\d+)|\\d+)\\s*(,\\s*((\\d+)\\.\\.(\\d+)|\\d+))*(\\s*(and|or)\\s*([niftvwe])\\s*(([/%])\\s*(\\d+))*\\s*(!?=)\\s*((\\d+)\\.\\.(\\d+)|\\d+)\\s*(,\\s*((\\d+)\\.\\.(\\d+)|\\d+))*)*");
    private final transient DigitList digitList = new DigitList();
    private static final int STATUS_INFINITE = 0;
    private static final int STATUS_POSITIVE = 1;
    private static final int STATUS_LENGTH = 2;
    private static final char ZERO_DIGIT = '0';
    private static final char DIGIT = '#';
    private static final char DECIMAL_SEPARATOR = '.';
    private static final char GROUPING_SEPARATOR = ',';
    private static final char MINUS_SIGN = '-';
    private static final char PERCENT = '%';
    private static final char PER_MILLE = '\u2030';
    private static final char SEPARATOR = ';';
    private static final char CURRENCY_SIGN = '\u00a4';
    private static final char QUOTE = '\'';
    private transient List<Patterns> positivePrefixes;
    private transient List<Patterns> negativePrefixes;
    private transient List<Patterns> positiveSuffixes;
    private transient List<Patterns> negativeSuffixes;
    private static final Pattern DIGITS = Pattern.compile("\\p{Nd}+");
    private static final String NAMED_EXPR = "(?<op>[niftvwe])\\s*((?<div>[/%])\\s*(?<val>\\d+))*";
    private static final String NAMED_RELATION = "(?<rel>!?=)";
    private static final String NAMED_VALUE_RANGE = "(?<start>\\d+)\\.\\.(?<end>\\d+)|(?<value>\\d+)";
    private static final Pattern EXPR_PATTERN = Pattern.compile("(?<op>[niftvwe])\\s*((?<div>[/%])\\s*(?<val>\\d+))*");
    private static final Pattern RELATION_PATTERN = Pattern.compile("(?<rel>!?=)");
    private static final Pattern VALUE_RANGE_PATTERN = Pattern.compile("(?<start>\\d+)\\.\\.(?<end>\\d+)|(?<value>\\d+)");

    public CompactNumberFormat(String decimalPattern, DecimalFormatSymbols symbols, String[] compactPatterns) {
        this(decimalPattern, symbols, compactPatterns, "");
    }

    public CompactNumberFormat(String decimalPattern, DecimalFormatSymbols symbols, String[] compactPatterns, String pluralRules) {
        Objects.requireNonNull(decimalPattern, "decimalPattern");
        Objects.requireNonNull(symbols, "symbols");
        Objects.requireNonNull(compactPatterns, "compactPatterns");
        Objects.requireNonNull(pluralRules, "pluralRules");
        this.symbols = symbols;
        this.decimalFormat = new DecimalFormat(SPECIAL_PATTERN, this.symbols);
        this.setMaximumIntegerDigits(this.decimalFormat.getMaximumIntegerDigits());
        this.setMinimumIntegerDigits(this.decimalFormat.getMinimumIntegerDigits());
        this.setMaximumFractionDigits(this.decimalFormat.getMaximumFractionDigits());
        this.setMinimumFractionDigits(this.decimalFormat.getMinimumFractionDigits());
        super.setGroupingUsed(this.decimalFormat.isGroupingUsed());
        super.setParseIntegerOnly(this.decimalFormat.isParseIntegerOnly());
        this.compactPatterns = compactPatterns;
        this.decimalPattern = decimalPattern;
        this.defaultDecimalFormat = new DecimalFormat(this.decimalPattern, this.symbols);
        this.defaultDecimalFormat.setMaximumFractionDigits(0);
        this.pluralRules = pluralRules;
        this.processCompactPatterns();
    }

    @Override
    public final StringBuffer format(Object number, StringBuffer toAppendTo, FieldPosition fieldPosition) {
        if (number == null) {
            throw new IllegalArgumentException("Cannot format null as a number");
        }
        if (number instanceof Long || number instanceof Integer || number instanceof Short || number instanceof Byte || number instanceof AtomicInteger || number instanceof AtomicLong || number instanceof BigInteger && ((BigInteger)number).bitLength() < 64) {
            return this.format(((Number)number).longValue(), toAppendTo, fieldPosition);
        }
        if (number instanceof BigDecimal) {
            return this.format((BigDecimal)number, toAppendTo, fieldPosition);
        }
        if (number instanceof BigInteger) {
            return this.format((BigInteger)number, toAppendTo, fieldPosition);
        }
        if (number instanceof Number) {
            return this.format(((Number)number).doubleValue(), toAppendTo, fieldPosition);
        }
        throw new IllegalArgumentException("Cannot format " + number.getClass().getName() + " as a number");
    }

    @Override
    public StringBuffer format(double number, StringBuffer result, FieldPosition fieldPosition) {
        fieldPosition.setBeginIndex(0);
        fieldPosition.setEndIndex(0);
        return this.format(number, result, fieldPosition.getFieldDelegate());
    }

    private StringBuffer format(double number, StringBuffer result, Format.FieldDelegate delegate) {
        boolean nanOrInfinity = this.decimalFormat.handleNaN(number, result, delegate);
        if (nanOrInfinity) {
            return result;
        }
        boolean isNegative = number < 0.0 || number == 0.0 && 1.0 / number < 0.0;
        nanOrInfinity = this.decimalFormat.handleInfinity(number, result, delegate, isNegative);
        if (nanOrInfinity) {
            return result;
        }
        DigitList dList = new DigitList();
        dList.setRoundingMode(this.getRoundingMode());
        number = isNegative ? -number : number;
        dList.set(isNegative, number, this.getMinimumFractionDigits());
        double roundedNumber = dList.getDouble();
        int compactDataIndex = this.selectCompactPattern((long)roundedNumber);
        if (compactDataIndex != -1) {
            long divisor = (Long)this.divisors.get(compactDataIndex);
            int iPart = this.getIntegerPart(number, divisor);
            String prefix = this.getAffix(false, true, isNegative, compactDataIndex, iPart);
            String suffix = this.getAffix(false, false, isNegative, compactDataIndex, iPart);
            if (!prefix.isEmpty() || !suffix.isEmpty()) {
                this.appendPrefix(result, prefix, delegate);
                if (!this.placeHolderPatterns.get(compactDataIndex).get(iPart).isEmpty()) {
                    this.decimalFormat.setDigitList(roundedNumber /= (double)divisor, isNegative, this.getMaximumFractionDigits());
                    this.decimalFormat.subformatNumber(result, delegate, isNegative, false, this.getMaximumIntegerDigits(), this.getMinimumIntegerDigits(), this.getMaximumFractionDigits(), this.getMinimumFractionDigits());
                    this.appendSuffix(result, suffix, delegate);
                }
            } else {
                this.defaultDecimalFormat.doubleSubformat(number, result, delegate, isNegative);
            }
        } else {
            this.defaultDecimalFormat.doubleSubformat(number, result, delegate, isNegative);
        }
        return result;
    }

    @Override
    public StringBuffer format(long number, StringBuffer result, FieldPosition fieldPosition) {
        fieldPosition.setBeginIndex(0);
        fieldPosition.setEndIndex(0);
        return this.format(number, result, fieldPosition.getFieldDelegate());
    }

    private StringBuffer format(long number, StringBuffer result, Format.FieldDelegate delegate) {
        boolean isNegative;
        boolean bl = isNegative = number < 0L;
        if (isNegative) {
            number = -number;
        }
        if (number < 0L) {
            BigInteger bigIntegerValue = BigInteger.valueOf(number);
            return this.format(bigIntegerValue, result, delegate, true);
        }
        int compactDataIndex = this.selectCompactPattern(number);
        if (compactDataIndex != -1) {
            long divisor = (Long)this.divisors.get(compactDataIndex);
            int iPart = this.getIntegerPart(number, divisor);
            String prefix = this.getAffix(false, true, isNegative, compactDataIndex, iPart);
            String suffix = this.getAffix(false, false, isNegative, compactDataIndex, iPart);
            if (!prefix.isEmpty() || !suffix.isEmpty()) {
                this.appendPrefix(result, prefix, delegate);
                if (!this.placeHolderPatterns.get(compactDataIndex).get(iPart).isEmpty()) {
                    if (number % divisor == 0L) {
                        this.decimalFormat.setDigitList(number /= divisor, isNegative, 0);
                        this.decimalFormat.subformatNumber(result, delegate, isNegative, true, this.getMaximumIntegerDigits(), this.getMinimumIntegerDigits(), this.getMaximumFractionDigits(), this.getMinimumFractionDigits());
                    } else {
                        double dNumber = (double)number / (double)divisor;
                        this.decimalFormat.setDigitList(dNumber, isNegative, this.getMaximumFractionDigits());
                        this.decimalFormat.subformatNumber(result, delegate, isNegative, false, this.getMaximumIntegerDigits(), this.getMinimumIntegerDigits(), this.getMaximumFractionDigits(), this.getMinimumFractionDigits());
                    }
                    this.appendSuffix(result, suffix, delegate);
                }
            } else {
                number = isNegative ? -number : number;
                this.defaultDecimalFormat.format(number, result, delegate);
            }
        } else {
            number = isNegative ? -number : number;
            this.defaultDecimalFormat.format(number, result, delegate);
        }
        return result;
    }

    private StringBuffer format(BigDecimal number, StringBuffer result, FieldPosition fieldPosition) {
        Objects.requireNonNull(number);
        fieldPosition.setBeginIndex(0);
        fieldPosition.setEndIndex(0);
        return this.format(number, result, fieldPosition.getFieldDelegate());
    }

    private StringBuffer format(BigDecimal number, StringBuffer result, Format.FieldDelegate delegate) {
        int compactDataIndex;
        boolean isNegative;
        boolean bl = isNegative = number.signum() == -1;
        if (isNegative) {
            number = number.negate();
        }
        if ((number = number.setScale(this.getMinimumFractionDigits(), this.getRoundingMode())).toBigInteger().bitLength() < 64) {
            long longNumber = number.toBigInteger().longValue();
            compactDataIndex = this.selectCompactPattern(longNumber);
        } else {
            compactDataIndex = this.selectCompactPattern(number.toBigInteger());
        }
        if (compactDataIndex != -1) {
            Number divisor = this.divisors.get(compactDataIndex);
            int iPart = this.getIntegerPart(number.doubleValue(), divisor.doubleValue());
            String prefix = this.getAffix(false, true, isNegative, compactDataIndex, iPart);
            String suffix = this.getAffix(false, false, isNegative, compactDataIndex, iPart);
            if (!prefix.isEmpty() || !suffix.isEmpty()) {
                this.appendPrefix(result, prefix, delegate);
                if (!this.placeHolderPatterns.get(compactDataIndex).get(iPart).isEmpty()) {
                    number = number.divide(new BigDecimal(divisor.toString()), this.getRoundingMode());
                    this.decimalFormat.setDigitList(number, isNegative, this.getMaximumFractionDigits());
                    this.decimalFormat.subformatNumber(result, delegate, isNegative, false, this.getMaximumIntegerDigits(), this.getMinimumIntegerDigits(), this.getMaximumFractionDigits(), this.getMinimumFractionDigits());
                    this.appendSuffix(result, suffix, delegate);
                }
            } else {
                number = isNegative ? number.negate() : number;
                this.defaultDecimalFormat.format(number, result, delegate);
            }
        } else {
            number = isNegative ? number.negate() : number;
            this.defaultDecimalFormat.format(number, result, delegate);
        }
        return result;
    }

    private StringBuffer format(BigInteger number, StringBuffer result, FieldPosition fieldPosition) {
        Objects.requireNonNull(number);
        fieldPosition.setBeginIndex(0);
        fieldPosition.setEndIndex(0);
        return this.format(number, result, fieldPosition.getFieldDelegate(), false);
    }

    private StringBuffer format(BigInteger number, StringBuffer result, Format.FieldDelegate delegate, boolean formatLong) {
        int compactDataIndex;
        boolean isNegative;
        boolean bl = isNegative = number.signum() == -1;
        if (isNegative) {
            number = number.negate();
        }
        if ((compactDataIndex = this.selectCompactPattern(number)) != -1) {
            Number divisor = this.divisors.get(compactDataIndex);
            int iPart = this.getIntegerPart(number.doubleValue(), divisor.doubleValue());
            String prefix = this.getAffix(false, true, isNegative, compactDataIndex, iPart);
            String suffix = this.getAffix(false, false, isNegative, compactDataIndex, iPart);
            if (!prefix.isEmpty() || !suffix.isEmpty()) {
                this.appendPrefix(result, prefix, delegate);
                if (!this.placeHolderPatterns.get(compactDataIndex).get(iPart).isEmpty()) {
                    if (number.mod(new BigInteger(divisor.toString())).compareTo(BigInteger.ZERO) == 0) {
                        number = number.divide(new BigInteger(divisor.toString()));
                        this.decimalFormat.setDigitList(number, isNegative, 0);
                        this.decimalFormat.subformatNumber(result, delegate, isNegative, true, this.getMaximumIntegerDigits(), this.getMinimumIntegerDigits(), this.getMaximumFractionDigits(), this.getMinimumFractionDigits());
                    } else {
                        BigDecimal nDecimal = new BigDecimal(number).divide(new BigDecimal(divisor.toString()), this.getRoundingMode());
                        this.decimalFormat.setDigitList(nDecimal, isNegative, this.getMaximumFractionDigits());
                        this.decimalFormat.subformatNumber(result, delegate, isNegative, false, this.getMaximumIntegerDigits(), this.getMinimumIntegerDigits(), this.getMaximumFractionDigits(), this.getMinimumFractionDigits());
                    }
                    this.appendSuffix(result, suffix, delegate);
                }
            } else {
                number = isNegative ? number.negate() : number;
                this.defaultDecimalFormat.format(number, result, delegate, formatLong);
            }
        } else {
            number = isNegative ? number.negate() : number;
            this.defaultDecimalFormat.format(number, result, delegate, formatLong);
        }
        return result;
    }

    private String getAffix(boolean isExpanded, boolean isPrefix, boolean isNegative, int compactDataIndex, int iPart) {
        return (isExpanded ? (isPrefix ? (isNegative ? this.negativePrefixes : this.positivePrefixes) : (isNegative ? this.negativeSuffixes : this.positiveSuffixes)) : (isPrefix ? (isNegative ? this.negativePrefixPatterns : this.positivePrefixPatterns) : (isNegative ? this.negativeSuffixPatterns : this.positiveSuffixPatterns))).get(compactDataIndex).get(iPart);
    }

    private void appendPrefix(StringBuffer result, String prefix, Format.FieldDelegate delegate) {
        this.append(result, this.expandAffix(prefix), delegate, this.getFieldPositions(prefix, NumberFormat.Field.PREFIX));
    }

    private void appendSuffix(StringBuffer result, String suffix, Format.FieldDelegate delegate) {
        this.append(result, this.expandAffix(suffix), delegate, this.getFieldPositions(suffix, NumberFormat.Field.SUFFIX));
    }

    private void append(StringBuffer result, String string, Format.FieldDelegate delegate, List<FieldPosition> positions) {
        if (!string.isEmpty()) {
            int start = result.length();
            result.append(string);
            for (FieldPosition fp : positions) {
                Format.Field attribute = fp.getFieldAttribute();
                delegate.formatted(attribute, attribute, start + fp.getBeginIndex(), start + fp.getEndIndex(), result);
            }
        }
    }

    private String expandAffix(String pattern) {
        if (pattern.indexOf(39) < 0) {
            return pattern;
        }
        StringBuilder sb = new StringBuilder();
        int index = 0;
        while (index < pattern.length()) {
            char ch;
            if ((ch = pattern.charAt(index++)) == '\'' && (ch = pattern.charAt(index++)) == '-') {
                sb.append(this.symbols.getMinusSignText());
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    private List<FieldPosition> getFieldPositions(String pattern, NumberFormat.Field field) {
        ArrayList<FieldPosition> positions = new ArrayList<FieldPosition>();
        StringBuilder affix = new StringBuilder();
        int stringIndex = 0;
        int index = 0;
        while (index < pattern.length()) {
            char ch;
            if ((ch = pattern.charAt(index++)) == '\'' && (ch = pattern.charAt(index++)) == '-') {
                String minusText = this.symbols.getMinusSignText();
                FieldPosition fp = new FieldPosition(NumberFormat.Field.SIGN);
                fp.setBeginIndex(stringIndex);
                fp.setEndIndex(stringIndex + minusText.length());
                positions.add(fp);
                stringIndex += minusText.length();
                affix.append(minusText);
                continue;
            }
            ++stringIndex;
            affix.append(ch);
        }
        if (affix.length() != 0) {
            FieldPosition fp = new FieldPosition(field);
            fp.setBeginIndex(0);
            fp.setEndIndex(affix.length());
            positions.add(fp);
        }
        return positions;
    }

    private int selectCompactPattern(long number) {
        if (this.compactPatterns.length == 0) {
            return -1;
        }
        int dataIndex = number <= 1L ? 0 : (int)Math.log10(number);
        dataIndex = Math.min(dataIndex, this.compactPatterns.length - 1);
        return dataIndex;
    }

    private int selectCompactPattern(BigInteger number) {
        int matchedIndex = -1;
        if (this.compactPatterns.length == 0) {
            return matchedIndex;
        }
        BigInteger currentValue = BigInteger.ONE;
        int index = 0;
        while (index < this.compactPatterns.length) {
            if (number.compareTo(currentValue) <= 0) {
                if (number.compareTo(currentValue) < 0) break;
                matchedIndex = index;
                break;
            }
            matchedIndex = index++;
            currentValue = currentValue.multiply(BigInteger.valueOf(10L));
        }
        return matchedIndex;
    }

    @Override
    public AttributedCharacterIterator formatToCharacterIterator(Object obj) {
        CharacterIteratorFieldDelegate delegate = new CharacterIteratorFieldDelegate();
        StringBuffer sb = new StringBuffer();
        if (obj instanceof Double || obj instanceof Float) {
            this.format(((Number)obj).doubleValue(), sb, (Format.FieldDelegate)delegate);
        } else if (obj instanceof Long || obj instanceof Integer || obj instanceof Short || obj instanceof Byte || obj instanceof AtomicInteger || obj instanceof AtomicLong) {
            this.format(((Number)obj).longValue(), sb, (Format.FieldDelegate)delegate);
        } else if (obj instanceof BigDecimal) {
            this.format((BigDecimal)obj, sb, (Format.FieldDelegate)delegate);
        } else if (obj instanceof BigInteger) {
            this.format((BigInteger)obj, sb, delegate, false);
        } else {
            if (obj == null) {
                throw new NullPointerException("formatToCharacterIterator must be passed non-null object");
            }
            throw new IllegalArgumentException("Cannot format given Object as a Number");
        }
        return delegate.getIterator(sb.toString());
    }

    private Number computeDivisor(String minIntDigits, int patternIndex) {
        int count = minIntDigits.length();
        Number matchedValue = patternIndex < 19 ? Long.valueOf((long)Math.pow(10.0, patternIndex)) : BigInteger.valueOf(10L).pow(patternIndex);
        Number divisor = matchedValue;
        if (count > 0) {
            if (matchedValue instanceof BigInteger) {
                Number bigValue = matchedValue;
                if (((BigInteger)bigValue).compareTo(BigInteger.valueOf((long)Math.pow(10.0, count - 1))) < 0) {
                    throw new IllegalArgumentException("Invalid Pattern [" + this.compactPatterns[patternIndex] + "]: min integer digits specified exceeds the limit for the index " + patternIndex);
                }
                divisor = ((BigInteger)bigValue).divide(BigInteger.valueOf((long)Math.pow(10.0, count - 1)));
            } else {
                long longValue = (Long)matchedValue;
                if (longValue < (long)Math.pow(10.0, count - 1)) {
                    throw new IllegalArgumentException("Invalid Pattern [" + this.compactPatterns[patternIndex] + "]: min integer digits specified exceeds the limit for the index " + patternIndex);
                }
                divisor = longValue / (long)Math.pow(10.0, count - 1);
            }
        }
        return divisor;
    }

    private void processCompactPatterns() {
        int size = this.compactPatterns.length;
        this.positivePrefixPatterns = new ArrayList<Patterns>(size);
        this.negativePrefixPatterns = new ArrayList<Patterns>(size);
        this.positiveSuffixPatterns = new ArrayList<Patterns>(size);
        this.negativeSuffixPatterns = new ArrayList<Patterns>(size);
        this.divisors = new ArrayList<Number>(size);
        this.placeHolderPatterns = new ArrayList<Patterns>(size);
        for (int index = 0; index < size; ++index) {
            Matcher m;
            String text = this.compactPatterns[index];
            this.positivePrefixPatterns.add(new Patterns());
            this.negativePrefixPatterns.add(new Patterns());
            this.positiveSuffixPatterns.add(new Patterns());
            this.negativeSuffixPatterns.add(new Patterns());
            this.placeHolderPatterns.add(new Patterns());
            Matcher matcher = m = text != null ? PLURALS.matcher(text) : null;
            if (m != null && m.matches()) {
                int idx = index;
                String plurals = m.group("plurals");
                COUNT_PATTERN.matcher(plurals).results().forEach(mr -> this.applyPattern(mr.group(1), mr.group(2), idx));
                continue;
            }
            this.applyPattern("other", text, index);
        }
        this.rulesMap = this.buildPluralRulesMap();
    }

    private Map<String, String> buildPluralRulesMap() {
        if (this.pluralRules.length() > 2048) {
            throw new IllegalArgumentException("plural rules is too long (> 2,048)");
        }
        try {
            return Arrays.stream(this.pluralRules.split(";")).map(this::validateRule).collect(Collectors.toMap(r -> r.replaceFirst(":.*", ""), r -> r.replaceFirst("[^:]+:", "")));
        }
        catch (IllegalStateException ise) {
            throw new IllegalArgumentException(ise);
        }
    }

    private String validateRule(String rule) {
        Matcher validator;
        if (!((rule = rule.trim()).isEmpty() || rule.equals("other:") || (validator = PLURALRULES_PATTERN.matcher(rule)).matches())) {
            throw new IllegalArgumentException("Invalid plural rules syntax: " + rule);
        }
        return rule;
    }

    private void applyPattern(String count, String pattern, int index) {
        if (pattern == null) {
            throw new IllegalArgumentException("A null compact pattern encountered at index: " + index);
        }
        int start = 0;
        boolean gotNegative = false;
        String positivePrefix = "";
        String positiveSuffix = "";
        String negativePrefix = "";
        String negativeSuffix = "";
        String zeros = "";
        for (int j = 1; j >= 0 && start < pattern.length(); --j) {
            StringBuffer prefix = new StringBuffer();
            StringBuffer suffix = new StringBuffer();
            boolean inQuote = false;
            int phase = 0;
            StringBuffer affix = prefix;
            block12: for (int pos = start; pos < pattern.length(); ++pos) {
                char ch = pattern.charAt(pos);
                switch (phase) {
                    case 0: 
                    case 2: {
                        if (inQuote) {
                            if (ch == '\'') {
                                if (pos + 1 < pattern.length() && pattern.charAt(pos + 1) == '\'') {
                                    ++pos;
                                    affix.append("''");
                                    continue block12;
                                }
                                inQuote = false;
                                continue block12;
                            }
                        } else {
                            switch (ch) {
                                case '0': {
                                    phase = 1;
                                    --pos;
                                    continue block12;
                                }
                                case '\'': {
                                    if (pos + 1 < pattern.length() && pattern.charAt(pos + 1) == '\'') {
                                        ++pos;
                                        affix.append("''");
                                        continue block12;
                                    }
                                    inQuote = true;
                                    continue block12;
                                }
                                case ';': {
                                    if (phase == 0 || j == 0) {
                                        throw new IllegalArgumentException("Unquoted special character '" + ch + "' in pattern \"" + pattern + "\"");
                                    }
                                    start = pos + 1;
                                    pos = pattern.length();
                                    continue block12;
                                }
                                case '-': {
                                    affix.append("'-");
                                    continue block12;
                                }
                                case '#': 
                                case '%': 
                                case ',': 
                                case '.': 
                                case '\u00a4': 
                                case '\u2030': {
                                    throw new IllegalArgumentException("Unquoted special character '" + ch + "' in pattern \"" + pattern + "\"");
                                }
                            }
                        }
                        affix.append(ch);
                        continue block12;
                    }
                    case 1: {
                        if (j == 0) {
                            while (pos < pattern.length()) {
                                char negPatternChar = pattern.charAt(pos);
                                if (negPatternChar == '0') {
                                    ++pos;
                                    continue;
                                }
                                --pos;
                                phase = 2;
                                affix = suffix;
                                continue block12;
                            }
                            continue block12;
                        }
                        if (ch == '0') {
                            zeros = zeros + SPECIAL_PATTERN;
                            continue block12;
                        }
                        phase = 2;
                        affix = suffix;
                        --pos;
                    }
                }
            }
            if (inQuote) {
                throw new IllegalArgumentException("Invalid single quote in pattern \"" + pattern + "\"");
            }
            if (j == 1) {
                positivePrefix = prefix.toString();
                positiveSuffix = suffix.toString();
                negativePrefix = positivePrefix;
                negativeSuffix = positiveSuffix;
            } else {
                negativePrefix = prefix.toString();
                negativeSuffix = suffix.toString();
                gotNegative = true;
            }
            if (gotNegative && (!negativePrefix.equals(positivePrefix) || !negativeSuffix.equals(positiveSuffix))) continue;
            negativeSuffix = positiveSuffix;
            negativePrefix = "'-" + positivePrefix;
        }
        if (!positivePrefix.isEmpty() || !positiveSuffix.isEmpty()) {
            this.positivePrefixPatterns.get(index).put(count, positivePrefix);
            this.negativePrefixPatterns.get(index).put(count, negativePrefix);
            this.positiveSuffixPatterns.get(index).put(count, positiveSuffix);
            this.negativeSuffixPatterns.get(index).put(count, negativeSuffix);
            this.placeHolderPatterns.get(index).put(count, zeros);
            if (this.divisors.size() <= index) {
                this.divisors.add(this.computeDivisor(zeros, index));
            }
        } else {
            this.positivePrefixPatterns.get(index).put(count, "");
            this.negativePrefixPatterns.get(index).put(count, "");
            this.positiveSuffixPatterns.get(index).put(count, "");
            this.negativeSuffixPatterns.get(index).put(count, "");
            this.placeHolderPatterns.get(index).put(count, "");
            if (this.divisors.size() <= index) {
                this.divisors.add(1L);
            }
        }
    }

    private void expandAffixPatterns() {
        this.positivePrefixes = new ArrayList<Patterns>(this.compactPatterns.length);
        this.negativePrefixes = new ArrayList<Patterns>(this.compactPatterns.length);
        this.positiveSuffixes = new ArrayList<Patterns>(this.compactPatterns.length);
        this.negativeSuffixes = new ArrayList<Patterns>(this.compactPatterns.length);
        for (int index = 0; index < this.compactPatterns.length; ++index) {
            this.positivePrefixes.add(this.positivePrefixPatterns.get(index).expandAffix());
            this.negativePrefixes.add(this.negativePrefixPatterns.get(index).expandAffix());
            this.positiveSuffixes.add(this.positiveSuffixPatterns.get(index).expandAffix());
            this.negativeSuffixes.add(this.negativeSuffixPatterns.get(index).expandAffix());
        }
    }

    @Override
    public Number parse(String text, ParsePosition pos) {
        Number cnfResult;
        Objects.requireNonNull(text);
        Objects.requireNonNull(pos);
        if (this.positivePrefixes == null) {
            this.expandAffixPatterns();
        }
        Number cnfMultiplier = 1L;
        if (text.regionMatches(pos.index, this.symbols.getNaN(), 0, this.symbols.getNaN().length())) {
            pos.index += this.symbols.getNaN().length();
            return Double.NaN;
        }
        int position = pos.index;
        int oldStart = pos.index;
        boolean gotPositive = false;
        boolean gotNegative = false;
        int matchedPosIndex = -1;
        int matchedNegIndex = -1;
        String matchedPosPrefix = "";
        String matchedNegPrefix = "";
        String defaultPosPrefix = this.defaultDecimalFormat.getPositivePrefix();
        String defaultNegPrefix = this.defaultDecimalFormat.getNegativePrefix();
        double num = this.parseNumberPart(text, position);
        for (int compactIndex = 0; compactIndex < this.compactPatterns.length; ++compactIndex) {
            String positivePrefix = this.getAffix(true, true, false, compactIndex, (int)num);
            String negativePrefix = this.getAffix(true, true, true, compactIndex, (int)num);
            boolean match = this.matchAffix(text, position, positivePrefix, defaultPosPrefix, matchedPosPrefix);
            if (match) {
                matchedPosIndex = compactIndex;
                matchedPosPrefix = positivePrefix;
                gotPositive = true;
            }
            if (!(match = this.matchAffix(text, position, negativePrefix, defaultNegPrefix, matchedNegPrefix))) continue;
            matchedNegIndex = compactIndex;
            matchedNegPrefix = negativePrefix;
            gotNegative = true;
        }
        if (!gotPositive && !gotNegative) {
            if (text.regionMatches(pos.index, defaultPosPrefix, 0, defaultPosPrefix.length())) {
                matchedPosPrefix = defaultPosPrefix;
                gotPositive = true;
            }
            if (text.regionMatches(pos.index, defaultNegPrefix, 0, defaultNegPrefix.length())) {
                matchedNegPrefix = defaultNegPrefix;
                gotNegative = true;
            }
        }
        if (gotPositive && gotNegative) {
            if (matchedPosPrefix.length() > matchedNegPrefix.length()) {
                gotNegative = false;
            } else if (matchedPosPrefix.length() < matchedNegPrefix.length()) {
                gotPositive = false;
            }
        }
        if (gotPositive || gotNegative) {
            int matchedIndex;
            position += gotPositive ? matchedPosPrefix.length() : matchedNegPrefix.length();
            int n = matchedIndex = gotPositive ? matchedPosIndex : matchedNegIndex;
            if (matchedIndex != -1) {
                cnfMultiplier = this.divisors.get(matchedIndex);
                if (this.placeHolderPatterns.get(matchedIndex).get(num).isEmpty()) {
                    pos.index = position;
                    return cnfMultiplier;
                }
            }
        }
        this.digitList.setRoundingMode(this.getRoundingMode());
        boolean[] status = new boolean[2];
        position = this.decimalFormat.subparseNumber(text, position, this.digitList, false, false, status);
        if (position == -1) {
            pos.index = oldStart;
            pos.errorIndex = oldStart;
            return null;
        }
        if (this.isParseIntegerOnly() && text.charAt(position) == this.symbols.getDecimalSeparator()) {
            char ch;
            int digit;
            ++position;
            while (position < text.length() && ((digit = (ch = text.charAt(position)) - this.symbols.getZeroDigit()) >= 0 && digit <= 9 || (digit = Character.digit(ch, 10)) >= 0 && digit <= 9)) {
                ++position;
            }
        }
        pos.index = position;
        Number multiplier = this.computeParseMultiplier(text, pos, gotPositive ? matchedPosPrefix : matchedNegPrefix, status, gotPositive, gotNegative, num);
        if (multiplier.longValue() == -1L) {
            return null;
        }
        if (multiplier.longValue() != 1L) {
            cnfMultiplier = multiplier;
        }
        if (status[0]) {
            if (status[1]) {
                return Double.POSITIVE_INFINITY;
            }
            return Double.NEGATIVE_INFINITY;
        }
        if (this.isParseBigDecimal()) {
            BigDecimal bigDecimalResult = this.digitList.getBigDecimal();
            if (cnfMultiplier.longValue() != 1L) {
                bigDecimalResult = bigDecimalResult.multiply(new BigDecimal(cnfMultiplier.toString()));
            }
            if (!status[1]) {
                bigDecimalResult = bigDecimalResult.negate();
            }
            return bigDecimalResult;
        }
        if (this.digitList.fitsIntoLong(status[1], this.isParseIntegerOnly())) {
            long longResult = this.digitList.getLong();
            cnfResult = this.generateParseResult(longResult, false, longResult < 0L, status, cnfMultiplier);
        } else {
            cnfResult = this.generateParseResult(this.digitList.getDouble(), true, false, status, cnfMultiplier);
        }
        return cnfResult;
    }

    private double parseNumberPart(String text, int position) {
        if (text.startsWith(this.symbols.getInfinity(), position)) {
            return Double.POSITIVE_INFINITY;
        }
        if (!text.startsWith(this.symbols.getNaN(), position)) {
            Matcher m = DIGITS.matcher(text);
            if (m.find(position)) {
                String digits = m.group();
                int cp = digits.codePointAt(0);
                if (Character.isDigit(cp)) {
                    return Double.parseDouble(digits.codePoints().map(Character::getNumericValue).mapToObj(Integer::toString).collect(Collectors.joining()));
                }
            } else {
                return 1.0;
            }
        }
        return Double.NaN;
    }

    private Number generateParseResult(Number number, boolean gotDouble, boolean gotLongMin, boolean[] status, Number cnfMultiplier) {
        if (gotDouble) {
            if (cnfMultiplier.longValue() != 1L) {
                long longResult;
                double doubleResult = number.doubleValue() * cnfMultiplier.doubleValue();
                gotDouble = (doubleResult = ((Double)this.convertIfNegative(doubleResult, status, gotLongMin)).doubleValue()) != (double)(longResult = (long)doubleResult) || doubleResult == 0.0 && 1.0 / doubleResult < 0.0;
                return gotDouble ? (Number)doubleResult : (Number)longResult;
            }
        } else if (cnfMultiplier.longValue() != 1L) {
            Number result;
            if (cnfMultiplier instanceof Long && !gotLongMin) {
                long longMultiplier = (Long)cnfMultiplier;
                try {
                    result = Math.multiplyExact(number.longValue(), longMultiplier);
                }
                catch (ArithmeticException ex) {
                    result = number.doubleValue() * cnfMultiplier.doubleValue();
                }
            } else {
                result = number.doubleValue() * cnfMultiplier.doubleValue();
            }
            return this.convertIfNegative(result, status, gotLongMin);
        }
        return this.convertIfNegative(number, status, gotLongMin);
    }

    private Number convertIfNegative(Number number, boolean[] status, boolean gotLongMin) {
        if (!status[1] && !gotLongMin) {
            if (number instanceof Long) {
                return -((Long)number).longValue();
            }
            return -((Double)number).doubleValue();
        }
        return number;
    }

    private boolean matchAffix(String text, int position, String affix, String defaultAffix, String matchedAffix) {
        if (!affix.isEmpty() && !affix.equals(defaultAffix) && matchedAffix.length() < affix.length()) {
            return text.regionMatches(position, affix, 0, affix.length());
        }
        return false;
    }

    private boolean matchPrefixAndSuffix(String text, int position, String prefix, String matchedPrefix, String defaultPrefix, String suffix, String matchedSuffix, String defaultSuffix) {
        if (prefix.equals(matchedPrefix) || matchedPrefix.equals(defaultPrefix)) {
            return this.matchAffix(text, position, suffix, defaultSuffix, matchedSuffix);
        }
        return false;
    }

    private Number computeParseMultiplier(String text, ParsePosition parsePosition, String matchedPrefix, boolean[] status, boolean gotPositive, boolean gotNegative, double num) {
        Long cnfMultiplier;
        int position = parsePosition.index;
        boolean gotPos = false;
        boolean gotNeg = false;
        int matchedPosIndex = -1;
        int matchedNegIndex = -1;
        String matchedPosSuffix = "";
        String matchedNegSuffix = "";
        for (int compactIndex = 0; compactIndex < this.compactPatterns.length; ++compactIndex) {
            String positivePrefix = this.getAffix(true, true, false, compactIndex, (int)num);
            String negativePrefix = this.getAffix(true, true, true, compactIndex, (int)num);
            String positiveSuffix = this.getAffix(true, false, false, compactIndex, (int)num);
            String negativeSuffix = this.getAffix(true, false, true, compactIndex, (int)num);
            boolean match = this.matchPrefixAndSuffix(text, position, positivePrefix, matchedPrefix, this.defaultDecimalFormat.getPositivePrefix(), positiveSuffix, matchedPosSuffix, this.defaultDecimalFormat.getPositiveSuffix());
            if (match) {
                matchedPosIndex = compactIndex;
                matchedPosSuffix = positiveSuffix;
                gotPos = true;
            }
            if (!(match = this.matchPrefixAndSuffix(text, position, negativePrefix, matchedPrefix, this.defaultDecimalFormat.getNegativePrefix(), negativeSuffix, matchedNegSuffix, this.defaultDecimalFormat.getNegativeSuffix()))) continue;
            matchedNegIndex = compactIndex;
            matchedNegSuffix = negativeSuffix;
            gotNeg = true;
        }
        if (!gotPos && !gotNeg) {
            String positiveSuffix = this.defaultDecimalFormat.getPositiveSuffix();
            String negativeSuffix = this.defaultDecimalFormat.getNegativeSuffix();
            if (text.regionMatches(position, positiveSuffix, 0, positiveSuffix.length())) {
                matchedPosSuffix = positiveSuffix;
                gotPos = true;
            }
            if (text.regionMatches(position, negativeSuffix, 0, negativeSuffix.length())) {
                matchedNegSuffix = negativeSuffix;
                gotNeg = true;
            }
        }
        if (gotPos && gotNeg) {
            if (matchedPosSuffix.length() > matchedNegSuffix.length()) {
                gotNeg = false;
            } else if (matchedPosSuffix.length() < matchedNegSuffix.length()) {
                gotPos = false;
            } else {
                gotPos = gotPositive;
                gotNeg = gotNegative;
            }
        }
        if (gotPos == gotNeg) {
            parsePosition.errorIndex = position;
            return -1L;
        }
        if (gotPos) {
            parsePosition.index = position + matchedPosSuffix.length();
            cnfMultiplier = matchedPosIndex != -1 ? (Number)this.divisors.get(matchedPosIndex) : (Number)1L;
        } else {
            parsePosition.index = position + matchedNegSuffix.length();
            cnfMultiplier = matchedNegIndex != -1 ? (Number)this.divisors.get(matchedNegIndex) : (Number)1L;
        }
        status[1] = gotPos;
        return cnfMultiplier;
    }

    private void readObject(ObjectInputStream inStream) throws IOException, ClassNotFoundException {
        inStream.defaultReadObject();
        if (this.decimalPattern == null || this.compactPatterns == null || this.symbols == null || this.roundingMode == null) {
            throw new InvalidObjectException("One of the 'decimalPattern', 'compactPatterns', 'symbols' or 'roundingMode' is null");
        }
        if (this.getMaximumIntegerDigits() > 309 || this.getMaximumFractionDigits() > 340) {
            throw new InvalidObjectException("Digit count out of range");
        }
        if (this.groupingSize < 0) {
            throw new InvalidObjectException("Grouping size is negative");
        }
        if (this.pluralRules == null) {
            this.pluralRules = "";
        }
        try {
            this.processCompactPatterns();
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidObjectException(ex.getMessage());
        }
        this.decimalFormat = new DecimalFormat(SPECIAL_PATTERN, this.symbols);
        this.decimalFormat.setMaximumFractionDigits(this.getMaximumFractionDigits());
        this.decimalFormat.setMinimumFractionDigits(this.getMinimumFractionDigits());
        this.decimalFormat.setMaximumIntegerDigits(this.getMaximumIntegerDigits());
        this.decimalFormat.setMinimumIntegerDigits(this.getMinimumIntegerDigits());
        this.decimalFormat.setRoundingMode(this.getRoundingMode());
        this.decimalFormat.setGroupingSize(this.getGroupingSize());
        this.decimalFormat.setGroupingUsed(this.isGroupingUsed());
        this.decimalFormat.setParseIntegerOnly(this.isParseIntegerOnly());
        try {
            this.defaultDecimalFormat = new DecimalFormat(this.decimalPattern, this.symbols);
            this.defaultDecimalFormat.setMaximumFractionDigits(0);
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidObjectException(ex.getMessage());
        }
    }

    @Override
    public void setMaximumIntegerDigits(int newValue) {
        this.decimalFormat.setMaximumIntegerDigits(Math.min(newValue, 309));
        super.setMaximumIntegerDigits(this.decimalFormat.getMaximumIntegerDigits());
        if (this.decimalFormat.getMinimumIntegerDigits() > this.decimalFormat.getMaximumIntegerDigits()) {
            this.decimalFormat.setMinimumIntegerDigits(this.decimalFormat.getMaximumIntegerDigits());
            super.setMinimumIntegerDigits(this.decimalFormat.getMinimumIntegerDigits());
        }
    }

    @Override
    public void setMinimumIntegerDigits(int newValue) {
        this.decimalFormat.setMinimumIntegerDigits(Math.min(newValue, 309));
        super.setMinimumIntegerDigits(this.decimalFormat.getMinimumIntegerDigits());
        if (this.decimalFormat.getMinimumIntegerDigits() > this.decimalFormat.getMaximumIntegerDigits()) {
            this.decimalFormat.setMaximumIntegerDigits(this.decimalFormat.getMinimumIntegerDigits());
            super.setMaximumIntegerDigits(this.decimalFormat.getMaximumIntegerDigits());
        }
    }

    @Override
    public void setMinimumFractionDigits(int newValue) {
        this.decimalFormat.setMinimumFractionDigits(Math.min(newValue, 340));
        super.setMinimumFractionDigits(this.decimalFormat.getMinimumFractionDigits());
        if (this.decimalFormat.getMinimumFractionDigits() > this.decimalFormat.getMaximumFractionDigits()) {
            this.decimalFormat.setMaximumFractionDigits(this.decimalFormat.getMinimumFractionDigits());
            super.setMaximumFractionDigits(this.decimalFormat.getMaximumFractionDigits());
        }
    }

    @Override
    public void setMaximumFractionDigits(int newValue) {
        this.decimalFormat.setMaximumFractionDigits(Math.min(newValue, 340));
        super.setMaximumFractionDigits(this.decimalFormat.getMaximumFractionDigits());
        if (this.decimalFormat.getMinimumFractionDigits() > this.decimalFormat.getMaximumFractionDigits()) {
            this.decimalFormat.setMinimumFractionDigits(this.decimalFormat.getMaximumFractionDigits());
            super.setMinimumFractionDigits(this.decimalFormat.getMinimumFractionDigits());
        }
    }

    @Override
    public RoundingMode getRoundingMode() {
        return this.roundingMode;
    }

    @Override
    public void setRoundingMode(RoundingMode roundingMode) {
        this.decimalFormat.setRoundingMode(roundingMode);
        this.roundingMode = roundingMode;
    }

    public int getGroupingSize() {
        return this.groupingSize;
    }

    public void setGroupingSize(int newValue) {
        if (newValue < 0 || newValue > 127) {
            throw new IllegalArgumentException("The value passed is negative or larger than 127");
        }
        this.groupingSize = (byte)newValue;
        this.decimalFormat.setGroupingSize(this.groupingSize);
    }

    @Override
    public boolean isGroupingUsed() {
        return super.isGroupingUsed();
    }

    @Override
    public void setGroupingUsed(boolean newValue) {
        this.decimalFormat.setGroupingUsed(newValue);
        super.setGroupingUsed(newValue);
    }

    @Override
    public boolean isParseIntegerOnly() {
        return super.isParseIntegerOnly();
    }

    @Override
    public void setParseIntegerOnly(boolean value) {
        this.decimalFormat.setParseIntegerOnly(value);
        super.setParseIntegerOnly(value);
    }

    public boolean isParseBigDecimal() {
        return this.parseBigDecimal;
    }

    public void setParseBigDecimal(boolean newValue) {
        this.parseBigDecimal = newValue;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        CompactNumberFormat other = (CompactNumberFormat)obj;
        return this.decimalPattern.equals(other.decimalPattern) && this.symbols.equals(other.symbols) && Arrays.equals(this.compactPatterns, other.compactPatterns) && this.roundingMode.equals((Object)other.roundingMode) && this.pluralRules.equals(other.pluralRules) && this.groupingSize == other.groupingSize && this.parseBigDecimal == other.parseBigDecimal;
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Objects.hash(new Object[]{this.decimalPattern, this.symbols, this.roundingMode, this.pluralRules}) + Arrays.hashCode(this.compactPatterns) + this.groupingSize + Boolean.hashCode(this.parseBigDecimal);
    }

    @Override
    public CompactNumberFormat clone() {
        CompactNumberFormat other = (CompactNumberFormat)super.clone();
        other.compactPatterns = (String[])this.compactPatterns.clone();
        other.symbols = (DecimalFormatSymbols)this.symbols.clone();
        return other;
    }

    private int getIntegerPart(double number, double divisor) {
        return BigDecimal.valueOf(number).divide(BigDecimal.valueOf(divisor), this.roundingMode).intValue();
    }

    private String getPluralCategory(double input) {
        if (this.rulesMap != null) {
            return this.rulesMap.entrySet().stream().filter(e -> CompactNumberFormat.matchPluralRule((String)e.getValue(), input)).map(Map.Entry::getKey).findFirst().orElse("other");
        }
        return "other";
    }

    private static boolean matchPluralRule(String condition, double input) {
        return Arrays.stream(condition.split("or")).anyMatch(and_condition -> Arrays.stream(and_condition.split("and")).allMatch(r -> CompactNumberFormat.relationCheck(r, input)));
    }

    private static boolean valOrRangeMatches(String valueOrRange, double input) {
        Matcher m = VALUE_RANGE_PATTERN.matcher(valueOrRange);
        if (m.find()) {
            String value = m.group("value");
            if (value != null) {
                return input == Double.parseDouble(value);
            }
            return input >= Double.parseDouble(m.group("start")) && input <= Double.parseDouble(m.group("end"));
        }
        return false;
    }

    private static boolean relationCheck(String relation, double input) {
        Matcher expr = EXPR_PATTERN.matcher(relation);
        if (expr.find()) {
            double lop = CompactNumberFormat.evalLOperand(expr, input);
            Matcher rel = RELATION_PATTERN.matcher(relation);
            if (rel.find(expr.end())) {
                Stream<String> conditions = Arrays.stream(relation.substring(rel.end()).split(","));
                if (Objects.equals(rel.group("rel"), "!=")) {
                    return conditions.noneMatch(c -> CompactNumberFormat.valOrRangeMatches(c, lop));
                }
                return conditions.anyMatch(c -> CompactNumberFormat.valOrRangeMatches(c, lop));
            }
        }
        return false;
    }

    private static double evalLOperand(Matcher expr, double input) {
        double ret = 0.0;
        if (input == Double.POSITIVE_INFINITY) {
            ret = input;
        } else {
            String divop;
            String op = expr.group("op");
            if (Objects.equals(op, "n") || Objects.equals(op, "i")) {
                ret = input;
            }
            if ((divop = expr.group("div")) != null) {
                String divisor = expr.group("val");
                switch (divop) {
                    case "%": {
                        ret %= Double.parseDouble(divisor);
                        break;
                    }
                    case "/": {
                        ret /= Double.parseDouble(divisor);
                    }
                }
            }
        }
        return ret;
    }

    private final class Patterns {
        private final Map<String, String> patternsMap = new HashMap<String, String>();

        private Patterns() {
        }

        void put(String count, String pattern) {
            this.patternsMap.put(count, pattern);
        }

        String get(double num) {
            return this.patternsMap.getOrDefault(CompactNumberFormat.this.getPluralCategory(num), this.patternsMap.getOrDefault("other", ""));
        }

        Patterns expandAffix() {
            Patterns ret = new Patterns();
            this.patternsMap.forEach((key, value) -> ret.put((String)key, CompactNumberFormat.this.expandAffix((String)value)));
            return ret;
        }
    }
}

