/*
 * Decompiled with CFR 0.152.
 */
package java.time;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneOffset;
import java.time.ZoneRegion;
import java.time.ZonedDateTime;

final class Ser
implements Externalizable {
    private static final long serialVersionUID = -7683839454370182990L;
    static final byte DURATION_TYPE = 1;
    static final byte INSTANT_TYPE = 2;
    static final byte LOCAL_DATE_TYPE = 3;
    static final byte LOCAL_TIME_TYPE = 4;
    static final byte LOCAL_DATE_TIME_TYPE = 5;
    static final byte ZONE_DATE_TIME_TYPE = 6;
    static final byte ZONE_REGION_TYPE = 7;
    static final byte ZONE_OFFSET_TYPE = 8;
    static final byte OFFSET_TIME_TYPE = 9;
    static final byte OFFSET_DATE_TIME_TYPE = 10;
    static final byte YEAR_TYPE = 11;
    static final byte YEAR_MONTH_TYPE = 12;
    static final byte MONTH_DAY_TYPE = 13;
    static final byte PERIOD_TYPE = 14;
    private byte type;
    private Serializable object;

    public Ser() {
    }

    Ser(byte type, Serializable object2) {
        this.type = type;
        this.object = object2;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        Ser.writeInternal(this.type, this.object, out);
    }

    static void writeInternal(byte type, Object object2, ObjectOutput out) throws IOException {
        out.writeByte(type);
        switch (type) {
            case 1: {
                ((Duration)object2).writeExternal(out);
                break;
            }
            case 2: {
                ((Instant)object2).writeExternal(out);
                break;
            }
            case 3: {
                ((LocalDate)object2).writeExternal(out);
                break;
            }
            case 5: {
                ((LocalDateTime)object2).writeExternal(out);
                break;
            }
            case 4: {
                ((LocalTime)object2).writeExternal(out);
                break;
            }
            case 7: {
                ((ZoneRegion)object2).writeExternal(out);
                break;
            }
            case 8: {
                ((ZoneOffset)object2).writeExternal(out);
                break;
            }
            case 6: {
                ((ZonedDateTime)object2).writeExternal(out);
                break;
            }
            case 9: {
                ((OffsetTime)object2).writeExternal(out);
                break;
            }
            case 10: {
                ((OffsetDateTime)object2).writeExternal(out);
                break;
            }
            case 11: {
                ((Year)object2).writeExternal(out);
                break;
            }
            case 12: {
                ((YearMonth)object2).writeExternal(out);
                break;
            }
            case 13: {
                ((MonthDay)object2).writeExternal(out);
                break;
            }
            case 14: {
                ((Period)object2).writeExternal(out);
                break;
            }
            default: {
                throw new InvalidClassException("Unknown serialized type");
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.type = in.readByte();
        this.object = Ser.readInternal(this.type, in);
    }

    static Serializable read(ObjectInput in) throws IOException, ClassNotFoundException {
        byte type = in.readByte();
        return Ser.readInternal(type, in);
    }

    private static Serializable readInternal(byte type, ObjectInput in) throws IOException, ClassNotFoundException {
        switch (type) {
            case 1: {
                return Duration.readExternal(in);
            }
            case 2: {
                return Instant.readExternal(in);
            }
            case 3: {
                return LocalDate.readExternal(in);
            }
            case 5: {
                return LocalDateTime.readExternal(in);
            }
            case 4: {
                return LocalTime.readExternal(in);
            }
            case 6: {
                return ZonedDateTime.readExternal(in);
            }
            case 8: {
                return ZoneOffset.readExternal(in);
            }
            case 7: {
                return ZoneRegion.readExternal(in);
            }
            case 9: {
                return OffsetTime.readExternal(in);
            }
            case 10: {
                return OffsetDateTime.readExternal(in);
            }
            case 11: {
                return Year.readExternal(in);
            }
            case 12: {
                return YearMonth.readExternal(in);
            }
            case 13: {
                return MonthDay.readExternal(in);
            }
            case 14: {
                return Period.readExternal(in);
            }
        }
        throw new StreamCorruptedException("Unknown serialized type");
    }

    private Object readResolve() {
        return this.object;
    }
}

