/*
 * Decompiled with CFR 0.152.
 */
package java.time.chrono;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateImpl;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.chrono.ChronoZonedDateTimeImpl;
import java.time.chrono.Chronology;
import java.time.chrono.Ser;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalUnit;
import java.time.temporal.ValueRange;
import java.util.Objects;

final class ChronoLocalDateTimeImpl<D extends ChronoLocalDate>
implements ChronoLocalDateTime<D>,
Temporal,
TemporalAdjuster,
Serializable {
    private static final long serialVersionUID = 4556003607393004514L;
    static final int HOURS_PER_DAY = 24;
    static final int MINUTES_PER_HOUR = 60;
    static final int MINUTES_PER_DAY = 1440;
    static final int SECONDS_PER_MINUTE = 60;
    static final int SECONDS_PER_HOUR = 3600;
    static final int SECONDS_PER_DAY = 86400;
    static final long MILLIS_PER_DAY = 86400000L;
    static final long MICROS_PER_DAY = 86400000000L;
    static final long NANOS_PER_SECOND = 1000000000L;
    static final long NANOS_PER_MINUTE = 60000000000L;
    static final long NANOS_PER_HOUR = 3600000000000L;
    static final long NANOS_PER_DAY = 86400000000000L;
    private final transient D date;
    private final transient LocalTime time;

    static <R extends ChronoLocalDate> ChronoLocalDateTimeImpl<R> of(R date, LocalTime time) {
        return new ChronoLocalDateTimeImpl<R>(date, time);
    }

    static <R extends ChronoLocalDate> ChronoLocalDateTimeImpl<R> ensureValid(Chronology chrono, Temporal temporal) {
        ChronoLocalDateTimeImpl other = (ChronoLocalDateTimeImpl)temporal;
        if (!chrono.equals(other.getChronology())) {
            throw new ClassCastException("Chronology mismatch, required: " + chrono.getId() + ", actual: " + other.getChronology().getId());
        }
        return other;
    }

    private ChronoLocalDateTimeImpl(D date, LocalTime time) {
        Objects.requireNonNull(date, "date");
        Objects.requireNonNull(time, "time");
        this.date = date;
        this.time = time;
    }

    private ChronoLocalDateTimeImpl<D> with(Temporal newDate, LocalTime newTime) {
        if (this.date == newDate && this.time == newTime) {
            return this;
        }
        Object cd = ChronoLocalDateImpl.ensureValid(this.date.getChronology(), newDate);
        return new ChronoLocalDateTimeImpl(cd, newTime);
    }

    @Override
    public D toLocalDate() {
        return this.date;
    }

    @Override
    public LocalTime toLocalTime() {
        return this.time;
    }

    @Override
    public boolean isSupported(TemporalField field) {
        if (field instanceof ChronoField) {
            ChronoField chronoField = (ChronoField)field;
            return chronoField.isDateBased() || chronoField.isTimeBased();
        }
        return field != null && field.isSupportedBy(this);
    }

    @Override
    public ValueRange range(TemporalField field) {
        if (field instanceof ChronoField) {
            ChronoField chronoField = (ChronoField)field;
            return chronoField.isTimeBased() ? this.time.range(field) : this.date.range(field);
        }
        return field.rangeRefinedBy(this);
    }

    @Override
    public int get(TemporalField field) {
        if (field instanceof ChronoField) {
            ChronoField chronoField = (ChronoField)field;
            return chronoField.isTimeBased() ? this.time.get(field) : this.date.get(field);
        }
        return this.range(field).checkValidIntValue(this.getLong(field), field);
    }

    @Override
    public long getLong(TemporalField field) {
        if (field instanceof ChronoField) {
            ChronoField chronoField = (ChronoField)field;
            return chronoField.isTimeBased() ? this.time.getLong(field) : this.date.getLong(field);
        }
        return field.getFrom(this);
    }

    @Override
    public ChronoLocalDateTimeImpl<D> with(TemporalAdjuster adjuster) {
        if (adjuster instanceof ChronoLocalDate) {
            return this.with((ChronoLocalDate)adjuster, this.time);
        }
        if (adjuster instanceof LocalTime) {
            return this.with((Temporal)this.date, (LocalTime)adjuster);
        }
        if (adjuster instanceof ChronoLocalDateTimeImpl) {
            return ChronoLocalDateTimeImpl.ensureValid(this.date.getChronology(), (ChronoLocalDateTimeImpl)adjuster);
        }
        return ChronoLocalDateTimeImpl.ensureValid(this.date.getChronology(), (ChronoLocalDateTimeImpl)adjuster.adjustInto(this));
    }

    @Override
    public ChronoLocalDateTimeImpl<D> with(TemporalField field, long newValue) {
        if (field instanceof ChronoField) {
            ChronoField chronoField = (ChronoField)field;
            if (chronoField.isTimeBased()) {
                return this.with((Temporal)this.date, this.time.with(field, newValue));
            }
            return this.with(this.date.with(field, newValue), this.time);
        }
        return ChronoLocalDateTimeImpl.ensureValid(this.date.getChronology(), field.adjustInto(this, newValue));
    }

    @Override
    public ChronoLocalDateTimeImpl<D> plus(long amountToAdd, TemporalUnit unit) {
        if (unit instanceof ChronoUnit) {
            ChronoUnit chronoUnit = (ChronoUnit)unit;
            switch (chronoUnit) {
                case NANOS: {
                    return this.plusNanos(amountToAdd);
                }
                case MICROS: {
                    return this.plusDays(amountToAdd / 86400000000L).plusNanos(amountToAdd % 86400000000L * 1000L);
                }
                case MILLIS: {
                    return this.plusDays(amountToAdd / 86400000L).plusNanos(amountToAdd % 86400000L * 1000000L);
                }
                case SECONDS: {
                    return this.plusSeconds(amountToAdd);
                }
                case MINUTES: {
                    return this.plusMinutes(amountToAdd);
                }
                case HOURS: {
                    return this.plusHours(amountToAdd);
                }
                case HALF_DAYS: {
                    return this.plusDays(amountToAdd / 256L).plusHours(amountToAdd % 256L * 12L);
                }
            }
            return this.with(this.date.plus(amountToAdd, unit), this.time);
        }
        return ChronoLocalDateTimeImpl.ensureValid(this.date.getChronology(), unit.addTo(this, amountToAdd));
    }

    private ChronoLocalDateTimeImpl<D> plusDays(long days) {
        return this.with(this.date.plus(days, ChronoUnit.DAYS), this.time);
    }

    private ChronoLocalDateTimeImpl<D> plusHours(long hours) {
        return this.plusWithOverflow(this.date, hours, 0L, 0L, 0L);
    }

    private ChronoLocalDateTimeImpl<D> plusMinutes(long minutes) {
        return this.plusWithOverflow(this.date, 0L, minutes, 0L, 0L);
    }

    ChronoLocalDateTimeImpl<D> plusSeconds(long seconds) {
        return this.plusWithOverflow(this.date, 0L, 0L, seconds, 0L);
    }

    private ChronoLocalDateTimeImpl<D> plusNanos(long nanos) {
        return this.plusWithOverflow(this.date, 0L, 0L, 0L, nanos);
    }

    private ChronoLocalDateTimeImpl<D> plusWithOverflow(D newDate, long hours, long minutes, long seconds, long nanos) {
        if ((hours | minutes | seconds | nanos) == 0L) {
            return this.with((Temporal)newDate, this.time);
        }
        long totDays = nanos / 86400000000000L + seconds / 86400L + minutes / 1440L + hours / 24L;
        long totNanos = nanos % 86400000000000L + seconds % 86400L * 1000000000L + minutes % 1440L * 60000000000L + hours % 24L * 3600000000000L;
        long curNoD = this.time.toNanoOfDay();
        long newNoD = Math.floorMod(totNanos, 86400000000000L);
        LocalTime newTime = newNoD == curNoD ? this.time : LocalTime.ofNanoOfDay(newNoD);
        return this.with(newDate.plus(totDays += Math.floorDiv(totNanos += curNoD, 86400000000000L), ChronoUnit.DAYS), newTime);
    }

    @Override
    public ChronoZonedDateTime<D> atZone(ZoneId zone) {
        return ChronoZonedDateTimeImpl.ofBest(this, zone, null);
    }

    @Override
    public long until(Temporal endExclusive, TemporalUnit unit) {
        Objects.requireNonNull(endExclusive, "endExclusive");
        ChronoLocalDateTime<? extends ChronoLocalDate> end = this.getChronology().localDateTime(endExclusive);
        if (unit instanceof ChronoUnit) {
            ChronoUnit chronoUnit = (ChronoUnit)unit;
            if (unit.isTimeBased()) {
                long amount = end.getLong(ChronoField.EPOCH_DAY) - this.date.getLong(ChronoField.EPOCH_DAY);
                switch (chronoUnit) {
                    case NANOS: {
                        amount = Math.multiplyExact(amount, 86400000000000L);
                        break;
                    }
                    case MICROS: {
                        amount = Math.multiplyExact(amount, 86400000000L);
                        break;
                    }
                    case MILLIS: {
                        amount = Math.multiplyExact(amount, 86400000L);
                        break;
                    }
                    case SECONDS: {
                        amount = Math.multiplyExact(amount, 86400);
                        break;
                    }
                    case MINUTES: {
                        amount = Math.multiplyExact(amount, 1440);
                        break;
                    }
                    case HOURS: {
                        amount = Math.multiplyExact(amount, 24);
                        break;
                    }
                    case HALF_DAYS: {
                        amount = Math.multiplyExact(amount, 2);
                    }
                }
                return Math.addExact(amount, this.time.until(end.toLocalTime(), unit));
            }
            ChronoLocalDate endDate = end.toLocalDate();
            if (end.toLocalTime().isBefore(this.time)) {
                endDate = endDate.minus(1L, ChronoUnit.DAYS);
            }
            return this.date.until(endDate, unit);
        }
        Objects.requireNonNull(unit, "unit");
        return unit.between(this, end);
    }

    private Object writeReplace() {
        return new Ser(2, this);
    }

    private void readObject(ObjectInputStream s) throws InvalidObjectException {
        throw new InvalidObjectException("Deserialization via serialization delegate");
    }

    void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.date);
        out.writeObject(this.time);
    }

    static ChronoLocalDateTime<?> readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        ChronoLocalDate date = (ChronoLocalDate)in.readObject();
        LocalTime time = (LocalTime)in.readObject();
        return date.atTime(time);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ChronoLocalDateTime) {
            return this.compareTo((ChronoLocalDateTime)obj) == 0;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.toLocalDate().hashCode() ^ this.toLocalTime().hashCode();
    }

    @Override
    public String toString() {
        return this.toLocalDate().toString() + 'T' + this.toLocalTime().toString();
    }
}

