/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import jdk.internal.util.ArraysSupport;

public abstract class AbstractCollection<E>
implements Collection<E> {
    protected AbstractCollection() {
    }

    @Override
    public abstract Iterator<E> iterator();

    @Override
    public abstract int size();

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        Iterator<E> it = this.iterator();
        if (o == null) {
            while (it.hasNext()) {
                if (it.next() != null) continue;
                return true;
            }
        } else {
            while (it.hasNext()) {
                if (!o.equals(it.next())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Object[] toArray() {
        Object[] r = new Object[this.size()];
        Iterator<E> it = this.iterator();
        for (int i = 0; i < r.length; ++i) {
            if (!it.hasNext()) {
                return Arrays.copyOf(r, i);
            }
            r[i] = it.next();
        }
        return it.hasNext() ? AbstractCollection.finishToArray(r, it) : r;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int size = this.size();
        T[] r = a.length >= size ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        Iterator<E> it = this.iterator();
        for (int i = 0; i < r.length; ++i) {
            if (!it.hasNext()) {
                if (a == r) {
                    r[i] = null;
                } else {
                    if (a.length < i) {
                        return Arrays.copyOf(r, i);
                    }
                    System.arraycopy(r, 0, a, 0, i);
                    if (a.length > i) {
                        a[i] = null;
                    }
                }
                return a;
            }
            r[i] = it.next();
        }
        return it.hasNext() ? AbstractCollection.finishToArray(r, it) : r;
    }

    private static <T> T[] finishToArray(T[] r, Iterator<?> it) {
        int len;
        int i = len = r.length;
        while (it.hasNext()) {
            if (i == len) {
                len = ArraysSupport.newLength(len, 1, (len >> 1) + 1);
                r = Arrays.copyOf(r, len);
            }
            r[i++] = it.next();
        }
        return i == len ? r : Arrays.copyOf(r, i);
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        Iterator<E> it = this.iterator();
        if (o == null) {
            while (it.hasNext()) {
                if (it.next() != null) continue;
                it.remove();
                return true;
            }
        } else {
            while (it.hasNext()) {
                if (!o.equals(it.next())) continue;
                it.remove();
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object e : c) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean modified = false;
        for (E e : c) {
            if (!this.add(e)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        Objects.requireNonNull(c);
        boolean modified = false;
        Iterator<E> it = this.iterator();
        while (it.hasNext()) {
            if (!c.contains(it.next())) continue;
            it.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Objects.requireNonNull(c);
        boolean modified = false;
        Iterator<E> it = this.iterator();
        while (it.hasNext()) {
            if (c.contains(it.next())) continue;
            it.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public void clear() {
        Iterator<E> it = this.iterator();
        while (it.hasNext()) {
            it.next();
            it.remove();
        }
    }

    public String toString() {
        Iterator<E> it = this.iterator();
        if (!it.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            E e;
            sb.append((Object)((e = it.next()) == this ? "(this Collection)" : e));
            if (!it.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(',').append(' ');
        }
    }
}

